<?php

namespace Drupal\acquia_contenthub\Event\ServiceQueue;

use Acquia\ContentHubClient\ContentHubClient;
use Drupal\Component\EventDispatcher\Event;

/**
 * Event for handling failed service queue items.
 *
 * This event is dispatched when service queue items pulled from the ContentHub
 * service fail to be processed by the module.
 *
 * @see \Drupal\acquia_contenthub\Libs\ServiceQueue\ServiceQueueHandler
 */
class ServiceQueueItemsFailedEvent extends Event {

  /**
   * Failed queue items with their failure reasons.
   *
   * @var array
   *   Array keyed by entity UUID with values of 'queue_item' and 'reason'.
   */
  protected array $failedQueueItems;

  /**
   * The ContentHub Client.
   *
   * @var \Acquia\ContentHubClient\ContentHubClient
   */
  protected ContentHubClient $client;

  /**
   * Constructs a ServiceQueueItemsFailedEvent object.
   *
   * @param array $failed_queue_items
   *   Failed queue items keyed by entity UUID with values containing:
   *   - 'queue_item': \Drupal\acquia_contenthub\Libs\ServiceQueue\QueueItem
   *   - 'reason': string describing the failure reason.
   * @param \Acquia\ContentHubClient\ContentHubClient $client
   *   The ContentHub Client.
   */
  public function __construct(array $failed_queue_items, ContentHubClient $client) {
    $this->failedQueueItems = $failed_queue_items;
    $this->client = $client;
  }

  /**
   * Provides failed queue items with their failure reasons.
   *
   * @return array
   *   Failed queue items keyed by entity UUID with values containing:
   *   - 'queue_item': \Drupal\acquia_contenthub\Libs\ServiceQueue\QueueItem
   *   - 'reason': string describing the failure reason.
   */
  public function getFailedQueueItems(): array {
    return $this->failedQueueItems;
  }

  /**
   * Gets the ContentHub Client.
   *
   * @return \Acquia\ContentHubClient\ContentHubClient
   *   The ContentHub Client.
   */
  public function getClient(): ContentHubClient {
    return $this->client;
  }

}
