<?php

namespace Drupal\Tests\acquia_contenthub\Unit\Event\ServiceQueue;

use Acquia\ContentHubClient\ContentHubClient;
use Drupal\acquia_contenthub\Event\ServiceQueue\ServiceQueueItemsFailedEvent;
use Drupal\acquia_contenthub\Libs\ServiceQueue\QueueItem;
use Drupal\Tests\UnitTestCase;

/**
 * Tests for ServiceQueueItemsFailedEvent.
 *
 * @group acquia_contenthub
 *
 * @package Drupal\Tests\acquia_contenthub\Unit\Event\ServiceQueue
 *
 * @coversDefaultClass \Drupal\acquia_contenthub\Event\ServiceQueue\ServiceQueueItemsFailedEvent
 */
class ServiceQueueItemsFailedEventTest extends UnitTestCase {

  /**
   * Test getters and setters.
   *
   * @covers ::getFailedQueueItems
   */
  public function testGettersAndSetters(): void {
    $queue_item_data = [
      'id' => '123',
      'entity_uuid' => '5f71af85-cbb0-48ac-84f3-97083bf16367',
      'client_uuid' => '8fb4c61c-bc0c-4451-a1aa-f576bf4eb966',
      'state' => 'queued',
      'payload' => [
        'action' => 'entity_create',
        'reason' => 'interest list',
      ],
      'visible_at' => '1753879023',
      'created_at' => '1753879023',
      'updated_at' => '1753879023',
    ];

    $queue_item = QueueItem::fromArray($queue_item_data);
    $client = $this->prophesize(ContentHubClient::class);

    $failed_queue_items = [
      $queue_item->getEntityUuid() => [
        'queue_item' => $queue_item,
        'reason' => 'Test failure reason',
      ],
    ];

    $event = new ServiceQueueItemsFailedEvent($failed_queue_items, $client->reveal());

    $this->assertSame($failed_queue_items, $event->getFailedQueueItems());
    $this->assertSame($client->reveal(), $event->getClient());

    $failed_items = $event->getFailedQueueItems();
    $this->assertArrayHasKey($queue_item->getEntityUuid(), $failed_items);
    $this->assertArrayHasKey('queue_item', $failed_items[$queue_item->getEntityUuid()]);
    $this->assertArrayHasKey('reason', $failed_items[$queue_item->getEntityUuid()]);
    $this->assertInstanceOf(QueueItem::class, $failed_items[$queue_item->getEntityUuid()]['queue_item']);
    $this->assertEquals('Test failure reason', $failed_items[$queue_item->getEntityUuid()]['reason']);
  }

}
