<?php

namespace Drupal\acquia_contenthub\Event\ServiceQueue;

use Acquia\ContentHubClient\ContentHubClient;
use Drupal\Component\EventDispatcher\Event;

/**
 * Event indicating that service queue items have been processed.
 *
 * This event is dispatched after pulled queue items from the ContentHub
 * service have been processed by the module.
 *
 * @see \Drupal\acquia_contenthub\Libs\ServiceQueue\ServiceQueueHandler
 */
class ServiceQueueItemsProcessingFinishedEvent extends Event {

  /**
   * Processed queue items.
   *
   * @var \Drupal\acquia_contenthub\Libs\ServiceQueue\QueueItem[]
   */
  protected array $processedQueueItems;

  /**
   * The ContentHub Client.
   *
   * @var \Acquia\ContentHubClient\ContentHubClient
   */
  protected ContentHubClient $client;

  /**
   * Constructs a ServiceQueueItemsProcessingFinishedEvent object.
   *
   * @param \Drupal\acquia_contenthub\Libs\ServiceQueue\QueueItem[] $queue_items
   *   Successfully processed queue items.
   * @param \Acquia\ContentHubClient\ContentHubClient $client
   *   The ContentHub Client.
   */
  public function __construct(array $queue_items, ContentHubClient $client) {
    $this->processedQueueItems = $queue_items;
    $this->client = $client;
  }

  /**
   * Gets successfully processed queue items.
   *
   * @return \Drupal\acquia_contenthub\Libs\ServiceQueue\QueueItem[]
   *   Array of successfully processed QueueItem objects.
   */
  public function getProcessedQueueItems(): array {
    return $this->processedQueueItems;
  }

  /**
   * Gets the ContentHub Client.
   *
   * @return \Acquia\ContentHubClient\ContentHubClient
   *   The ContentHub Client.
   */
  public function getClient(): ContentHubClient {
    return $this->client;
  }

}
