<?php

namespace Drupal\acquia_contenthub\Libs\ServiceQueue;

/**
 * Interface for queue item action strategies.
 *
 * Defines the contract for different types of actions that can be performed
 * on queue items during pull syndication.
 *
 * @package Drupal\acquia_contenthub\Libs\ServiceQueue
 */
interface QueueItemActionInterface {

  /**
   * Executes the action for the given queue item.
   *
   * @param \Drupal\acquia_contenthub\Libs\ServiceQueue\QueueItem[] $queue_items
   *   Array of QueueItem objects to process.
   *
   * @throws \Exception
   *   When the action cannot be executed.
   */
  public function execute(array $queue_items): void;

  /**
   * Determines if this action can handle the given queue item.
   *
   * @param \Drupal\acquia_contenthub\Libs\ServiceQueue\QueueItem $queue_item
   *   The queue item to check.
   *
   * @return bool
   *   TRUE if this action can handle the queue item, FALSE otherwise.
   */
  public function canHandle(QueueItem $queue_item): bool;

}
