<?php

namespace Drupal\Tests\acquia_contenthub\Unit\Event\ServiceQueue;

use Acquia\ContentHubClient\ContentHubClient;
use Drupal\acquia_contenthub\Event\ServiceQueue\ServiceQueueItemsProcessingFinishedEvent;
use Drupal\acquia_contenthub\Libs\ServiceQueue\QueueItem;
use Drupal\Tests\UnitTestCase;

/**
 * Tests for ServiceQueueItemsProcessingFinishedEvent.
 *
 * @group acquia_contenthub
 *
 * @package Drupal\Tests\acquia_contenthub\Unit\Event\ServiceQueue
 *
 * @coversDefaultClass \Drupal\acquia_contenthub\Event\ServiceQueue\ServiceQueueItemsProcessingFinishedEvent
 */
class ServiceQueueItemsProcessingFinishedEventTest extends UnitTestCase {

  /**
   * Test getter and setter.
   *
   * @covers ::getProcessedQueueItems
   * @covers ::getClient
   */
  public function testGetterSetter(): void {
    $queue_item_data = [
      'id' => '123',
      'entity_uuid' => '5f71af85-cbb0-48ac-84f3-97083bf16367',
      'client_uuid' => '8fb4c61c-bc0c-4451-a1aa-f576bf4eb966',
      'state' => 'queued',
      'payload' => [
        'action' => 'entity_create',
        'reason' => 'interest list',
      ],
      'visible_at' => '1753879023',
      'created_at' => '1753879023',
      'updated_at' => '1753879023',
    ];

    $queue_item = QueueItem::fromArray($queue_item_data);
    $client = $this->prophesize(ContentHubClient::class);

    $processed_queue_items = [$queue_item];
    $event = new ServiceQueueItemsProcessingFinishedEvent($processed_queue_items, $client->reveal());

    $this->assertSame($processed_queue_items, $event->getProcessedQueueItems());
    $this->assertSame($client->reveal(), $event->getClient());

    $processed_items = $event->getProcessedQueueItems();
    $this->assertCount(1, $processed_items);
    $this->assertInstanceOf(QueueItem::class, $processed_items[0]);
    $this->assertEquals('5f71af85-cbb0-48ac-84f3-97083bf16367', $processed_items[0]->getEntityUuid());
  }

}
