<?php

declare(strict_types=1);

namespace Drupal\acquia_dam\Plugin\Field\FieldType;

use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Defines the 'acquia_dam_{bundle}_item' field type.
 *
 * The bundle part is derived from the Acquia DAM media source plugin ID.
 * For example, for the 'acquia_dam_asset:image' media source plugin,
 * the field type will be 'acquia_dam_image_item'.
 *
 * DO NOT CHANGE ID in below, it is used in the deriver. If you want to change,
 * keep the same value for BASE_FIELD_NAME constant.
 *
 *
 * @FieldType(
 *   id = "acquia_dam",
 *   label = @Translation("Acquia DAM Asset Field Item"),
 *   description = @Translation("Base field type for Acquia DAM asset field items."),
 *   no_ui = TRUE,
 *   list_class = "Drupal\acquia_dam\Plugin\Field\AssetFieldItemList",
 *   deriver = "Drupal\acquia_dam\Plugin\Derivative\AssetSourceFieldTypeDeriver"
 * )
 */
class AssetFieldType extends FieldItemBase {

  /**
   * The field name.
   */
  const BASE_FIELD_NAME = 'acquia_dam';

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition): array {
    $properties['src'] = DataDefinition::create('uri')
      ->setLabel(t('The asset source URL'))
      ->setReadOnly(TRUE)
      ->setRequired(TRUE);
    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition): array {
    // The field is computed, so no schema is needed.
    return [];
  }

}
