<?php

declare(strict_types=1);

namespace Drupal\acquia_dam\Plugin\media\acquia_dam;

/**
 * Archive Media Source Type.
 *
 * @AssetMediaSource(
 *   id = "archive",
 *   label = @Translation("Acquia DAM: Archive"),
 *   default_thumbnail_filename = "generic.png",
 *   asset_search_key = "ft",
 *   asset_search_value = "compressed_archive",
 * )
 */
final class Archive extends MediaSourceTypeBase implements MediaSourceTypeInterface {

  /**
   * {@inheritdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->assetFieldFormatterConfiguration[$this->embedCodeAssetField] = [
      'type' => 'acquia_dam_embed_code',
      'label' => 'hidden',
      'settings' => [
        'embed_style' => 'link_download',
      ],
      'third_party_settings' => [],
      'region' => 'content',
    ];
  }

}
