<?php

declare(strict_types=1);

namespace Drupal\Tests\acquia_dam\Kernel;

use Drupal\canvas\PropExpressions\StructuredData\StructuredDataPropExpression;
use Drupal\canvas\PropShape\StorablePropShape;
use Drupal\media\Entity\MediaType;
use Drupal\Tests\canvas\Kernel\MediaLibraryHookStoragePropAlterTest;
use Symfony\Component\Yaml\Yaml;

/**
 * @covers \Drupal\acquia_dam\Hook\CanvasHooks::acquiaDamStoragePropShapeAlter
 * @covers \acquia_dam_module_implements_alter()
 * @group acquia_dam_canvas
 * @group acquia_dam_kernel
 */
class AcquiaDamHookStoragePropShapeAlterTest extends MediaLibraryHookStoragePropAlterTest {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'acquia_dam',
    'acquia_dam_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    // Set test DAM domain to use middleware.
    $this->config('acquia_dam.settings')
      ->set('domain', 'test.widencollective.com')
      ->save();

    $module_path = $this->container->get('extension.list.module')->getPath('acquia_dam');
    MediaType::create(
      Yaml::parseFile($module_path . '/config/install/media.type.acquia_dam_image_asset.yml')
    )->save();
  }

  /**
   * @return \Drupal\canvas\PropShape\StorablePropShape[]
   */
  public static function getExpectedStorablePropShapes(): array {
    $storable_prop_shapes = parent::getExpectedStorablePropShapes();
    $image_shapes = array_intersect_key(
      $storable_prop_shapes,
      array_flip([
        'type=object&$ref=json-schema-definitions://canvas.module/image',
        'type=array&items[$ref]=json-schema-definitions://canvas.module/image&items[type]=object',
        'type=array&items[$ref]=json-schema-definitions://canvas.module/image&items[type]=object&maxItems=2',
      ]),
    );
    foreach ($image_shapes as $k => $image_shape) {
      $storable_prop_shapes[$k] = new StorablePropShape(
        shape: $image_shape->shape,
        cardinality: $image_shape->cardinality,
        fieldWidget: 'media_library_widget',
        // @phpstan-ignore-next-line
        fieldTypeProp: StructuredDataPropExpression::fromString("ℹ︎entity_reference␟{src↝entity␜␜entity:media:acquia_dam_image_asset|baby_photos|vacation_photos␝acquia_dam_image_item|field_media_image|field_media_image_1␞␟src_with_alternate_widths|src_with_alternate_widths|src_with_alternate_widths,alt↝entity␜␜entity:media:acquia_dam_image_asset|baby_photos|vacation_photos␝acquia_dam_image_item|field_media_image|field_media_image_1␞␟alt|alt|alt,width↝entity␜␜entity:media:acquia_dam_image_asset|baby_photos|vacation_photos␝acquia_dam_image_item|field_media_image|field_media_image_1␞␟width|width|width,height↝entity␜␜entity:media:acquia_dam_image_asset|baby_photos|vacation_photos␝acquia_dam_image_item|field_media_image|field_media_image_1␞␟height|height|height}"),
        fieldStorageSettings: [
          'target_type' => 'media',
        ],
        fieldInstanceSettings: [
          'handler' => 'default:media',
          'handler_settings' => [
            'target_bundles' => [
              'acquia_dam_image_asset' => 'acquia_dam_image_asset',
              'baby_photos' => 'baby_photos',
              'vacation_photos' => 'vacation_photos',
            ],
          ],
        ],
      );
    }

    return $storable_prop_shapes;
  }

}
