<?php

declare(strict_types=1);

namespace Drupal\Tests\acquia_dam\Kernel;

use Drupal\acquia_dam\Entity\MediaSourceField;
use Drupal\media\Entity\Media;

/**
 * Tests the getAssetStatus method in the Asset class.
 *
 * @group acquia_dam_kernel
 */
class AssetGetStatusTest extends AcquiaDamKernelTestBase {

  public function setUp(): void {
    parent::setUp();
    $this->installConfig('system');
  }

  /**
   * Tests the getAssetStatus method.
   *
   * @dataProvider assetStatusDataProvider
   */
  public function testGetAssetStatus(string $asset_id, string $version_id, string $expected_status): void {
    $media_type = $this->createDocumentMediaType();

    // Create a media entity with the provided data.
    $media = Media::create([
      'bundle' => $media_type->id(),
      MediaSourceField::SOURCE_FIELD_NAME => [
        'asset_id' => $asset_id,
        'version_id' => $version_id,
      ],
    ]);
    $media->save();

    // Create an instance of the Asset class.
    $asset = $media->getSource();

    // Test the method.
    $status = $asset->getStatus($media);

    // Assert the expected status.
    $this->assertTrue($status->isInSync($media));
    $this->assertEquals($expected_status, $status->getValue());
  }

  /**
   * Data provider for testGetAssetStatusWithDataProvider.
   *
   * @return array
   *   An array of test cases.
   */
  public static function assetStatusDataProvider(): array {
    return [
      ['4f656c07-6a08-47b3-9403-16082d2fcda2', 'c6a1d232-4460-43de-afd2-b3bd53ade80f', 'Released'],
      ['a56fb261-8ad5-4e0d-8323-0e8a3659ed39', '4f656c07-6a08-47b3-9403-16082d2fcda8', 'Unreleased'],
      ['a56fb261-8ad5-4e0d-8323-0e8a3659ed38', '4f656c07-6a08-47b3-9403-16082d2fcda8', 'Expired'],
      ['c2bbed58-427f-43f7-91d8-c380307dac67', '4f656c07-6a08-47b3-9403-16082d2fcda8', 'Deleted'],
    ];
  }

}
