<?php

declare(strict_types=1);

namespace Drupal\acquia_dam\Plugin\Linkit\Substitution;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;
use Drupal\linkit\Plugin\Linkit\Substitution\Media;
use Drupal\media\MediaInterface;
use Drupal\acquia_dam\Plugin\media\Source\Asset;

/**
 * A substitution plugin for the URL to a asset.
 *
 * Custom plugin for DAM assets because the source field is the DAM ID, not the
 * actual file reference field.
 *
 * @Substitution(
 *   id = "acquia_dam_asset",
 *   label = @Translation("Direct URL to Acquia DAM Assets"),
 * )
 */
class DamAsset extends Media {

  /**
   * {@inheritdoc}
   */
  public function getUrl(EntityInterface $entity): ?Url {
    // We need special handling for Acquia DAM media sources.
    // LinkIt assumes that a Media source field will be a FileInterface which is
    // not a valid assumption.
    if ($entity instanceof MediaInterface) {
      $source = $entity->getSource();
      if ($source instanceof Asset) {
        $asset_id = $source->getMetadata($entity, 'asset_id');
        $version_id = $source->getMetadata($entity, 'version_id');
        $uri = 'acquia-dam://' . $asset_id . '/' . $version_id;

        return $this->fileUrlGenerator->generate($uri);
      }
    }

    return parent::getUrl($entity);
  }

}
