<?php

namespace Drupal\acquia_dam\Plugin\views\area;

use Drupal\views\Plugin\views\area\AreaPluginBase;
use Drupal\views_remote_data\Plugin\views\query\RemoteDataQuery;

/**
 * A handler to display a message when there are no results.
 *
 * @ingroup views_area_handlers
 *
 * @ViewsArea("acquia_dam_no_results_text")
 */
final class AcquiaDamTextCustom extends AreaPluginBase {

  /**
   * {@inheritDoc}
   */
  public function render($empty = FALSE) {
    assert($this->query instanceof RemoteDataQuery);

    $no_results_message = "No result found ";
    foreach ($this->query->where as $condition_group) {
      \Drupal::logger('acquia_dam')->info(print_r($condition_group['conditions'],true));
      foreach ($condition_group['conditions'] as $condition) {
        $field = implode('.', $condition['field']);
        if ($field === 'search') {
          $no_results_message .= " for search keyword " . $condition['value'];
        }
        elseif ($field === 'cat') {
          $no_results_message .= " with category " . $condition['value'];
        }
        elseif (in_array($field, ['ff', 'ft'], TRUE)) {
          $no_results_message .= " for media type " . $condition['value'];
        }
        else {
          $no_results_message .= " with filter ";
          $no_results_message .= is_array($condition['value']) ? implode(',', array_values($condition['value'])) : $condition['value'];
        }
      }
    }

    return ['#markup' => $no_results_message . '.'];
  }

}
