<?php

namespace Drupal\acquia_key_provider;

/**
 * A simple, test-friendly interface for environment variable read operations.
 *
 * @internal
 */
interface EnvironmentReaderInterface {

  /**
   * Gets an environment variable by name.
   *
   * @param string $name
   *   The name of the environment variable to get.
   *
   * @return string
   *   The value of the environment variable, which may be an empty string.
   */
  public function getEnv(string $name): string;

}
