<?php

namespace Drupal\acquia_key_provider;

/**
 * Default file reader implementation that simply calls native functions.
 *
 * @internal
 */
class FileReader implements FileReaderInterface {

  /**
   * {@inheritdoc}
   */
  public function isFile(string $filename): bool {
    return is_file($filename);
  }

  /**
   * {@inheritdoc}
   */
  public function isReadable(string $filename): bool {
    return is_readable($filename);
  }

  /**
   * {@inheritdoc}
   */
  public function getContents(string $filename): string|false {
    return file_get_contents($filename);
  }

}
