<?php

namespace Drupal\acquia_key_provider;

/**
 * A simple, test-friendly interface for file read operations.
 *
 * @internal
 */
interface FileReaderInterface {

  /**
   * Is the provided filename is a regular file?
   *
   * @param string $filename
   *   The path to the file.
   *
   * @return bool
   *   TRUE if it's a regular file, otherwise FALSE.
   */
  public function isFile(string $filename): bool;

  /**
   * Does the provided file exist and is readable?
   *
   * @param string $filename
   *   The path to the file.
   *
   * @return bool
   *   TRUE if the file exists and is readable, otherwise FALSE.
   */
  public function isReadable(string $filename): bool;

  /**
   * Reads the entire file contents into a string.
   *
   * @param string $filename
   *   The path to the file.
   *
   * @return string|false
   *   The entire file contents, or FALSE on failure.
   */
  public function getContents(string $filename): string|false;

}
