<?php

namespace Drupal\acquia_key_provider_test;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Service provider implementation for the helper module.
 */
class AcquiaKeyProviderTestServiceProvider extends ServiceProviderBase {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    parent::alter($container);
    if ($container->hasDefinition('acquia_key_provider.file_reader')) {
      $definition = $container->getDefinition('acquia_key_provider.file_reader');
      $definition->setClass(MockFileReader::class);
      $definition->setArguments([
        new Reference('request_stack'),
      ]);
    }
    if ($container->hasDefinition('acquia_key_provider.environment_reader')) {
      $definition = $container->getDefinition('acquia_key_provider.environment_reader');
      $definition->setClass(MockEnvironmentReader::class);
      $definition->setArguments([
        new Reference('request_stack'),
      ]);
    }
  }

}
