<?php

namespace Drupal\acquia_key_provider_test;

use Drupal\acquia_key_provider\EnvironmentReaderInterface;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * A mock environment reader implementation based on query parameters.
 *
 * This mock is useful in functional tests.
 */
class MockEnvironmentReader implements EnvironmentReaderInterface {

  /**
   * Service constructor.
   *
   * @param \Symfony\Component\HttpFoundation\RequestStack $requestStack
   *   The request stack service.
   */
  public function __construct(
    protected RequestStack $requestStack,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getEnv(string $name): string {
    return $this->requestStack->getCurrentRequest()->query->get($name, '');
  }

}
