<?php

namespace Drupal\acquia_key_provider_test;

use Drupal\acquia_key_provider\FileReaderInterface;
use Symfony\Component\HttpFoundation\RequestStack;

/**
 * A mock file reader implementation based on query parameters.
 *
 * This mock is useful in functional tests.
 */
class MockFileReader implements FileReaderInterface {

  /**
   * Service constructor.
   *
   * @param \Symfony\Component\HttpFoundation\RequestStack $requestStack
   *   The request stack service.
   */
  public function __construct(
    protected RequestStack $requestStack,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function isFile(string $filename): bool {
    return (bool) $this->requestStack->getCurrentRequest()->query->get('is_file');
  }

  /**
   * {@inheritdoc}
   */
  public function isReadable(string $filename): bool {
    return (bool) $this->requestStack->getCurrentRequest()->query->get('is_readable');
  }

  /**
   * {@inheritdoc}
   */
  public function getContents(string $filename): string|false {
    return $this->requestStack->getCurrentRequest()->query->get('file_contents', FALSE);
  }

}
