<?php

namespace Drupal\Tests\acquia_key_provider\Functional;

use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;

/**
 * Test cases for the key provider configuration form.
 *
 * @group acquia_key_provider
 */
class AcquiaFileKeyProviderFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'key',
    'acquia_key_provider',
    'acquia_key_provider_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Test case for the key provider configuration form.
   */
  public function testConfigurationForm() {

    // Login as admin.
    $this->drupalLogin($this->rootUser);

    // Ensure the appropriate warning message is displayed for non-Acquia
    // hosting environments.
    $this->drupalGet(Url::fromRoute('entity.key.edit_form', ['key' => 'test_key']));
    $this->submitForm([], 'Edit');
    $this->assertSession()->pageTextContains('This does not appear to be an Acquia hosted application. If this is a local development environment, the "AH_SITE_GROUP" and "AH_SITE_ENVIRONMENT" environment variables may have to be temporarily created in order to proceed.');
    $this->assertSession()->pageTextContains('This file should exist within the /mnt/gfs/[application].[environment]/nobackup/ directory');
    // Ensure the warning message goes away appropriately.
    $this->drupalGet(Url::fromRoute('entity.key.edit_form', [
      'key' => 'test_key',
    ], [
      'query' => [
        'AH_SITE_GROUP' => 'test-application',
        'AH_SITE_ENVIRONMENT' => 'test-environment',
      ],
    ])
    );
    $this->submitForm([], 'Edit');
    $this->assertSession()->pageTextNotContains('This does not appear to be an Acquia hosted application. If this is a local development environment, the "AH_SITE_GROUP" and "AH_SITE_ENVIRONMENT" environment variables may have to be temporarily created in order to proceed.');
    $this->assertSession()->pageTextContains('This file should exist within the /mnt/gfs/test-application.test-environment/nobackup/ directory');

    // Ensure keys cannot be saved if they don't exist.
    $this->drupalGet(Url::fromRoute('entity.key.edit_form', [
      'key' => 'test_key',
    ], [
      'query' => [
        'AH_SITE_GROUP' => 'test-application',
        'AH_SITE_ENVIRONMENT' => 'test-environment',
        'is_file' => FALSE,
      ],
    ])
    );
    $this->submitForm([], 'Edit');
    $this->submitForm([], 'Save');
    $this->assertSession()->pageTextContains('The file /mnt/gfs/test-application.test-environment/nobackup/test.pem does not exist.');

    // Ensure keys cannot be saved if they aren't readable.
    $this->drupalGet(Url::fromRoute('entity.key.edit_form', [
      'key' => 'test_key',
    ], [
      'query' => [
        'AH_SITE_GROUP' => 'test-application',
        'AH_SITE_ENVIRONMENT' => 'test-environment',
        'is_file' => TRUE,
        'is_readable' => FALSE,
      ],
    ])
    );
    $this->submitForm([], 'Edit');
    $this->submitForm([], 'Save');
    $this->assertSession()->pageTextContains('The file /mnt/gfs/test-application.test-environment/nobackup/test.pem is not readable.');

    // Ensure keys can be saved if they are readable.
    $this->drupalGet(Url::fromRoute('entity.key.edit_form', [
      'key' => 'test_key',
    ], [
      'query' => [
        'AH_SITE_GROUP' => 'test-application',
        'AH_SITE_ENVIRONMENT' => 'test-environment',
        'is_file' => TRUE,
        'is_readable' => TRUE,
      ],
    ])
    );
    $this->submitForm([], 'Edit');
    $this->submitForm([], 'Save');
    $this->assertSession()->pageTextContains('The key Test key has been updated.');

  }

}
