# Acquia Optimize Module

Module that implements the Acquia Optimize Quick Scan for editors in Drupal to see potential SEO and accessibility issues on any page.

## Features

- Checks the page for accessibility problems against a range of guidelines
- Offers suggestions to improve Search Engine Optimization of a page
- Gives a "reading level" to a page to assess the difficulty of a page
- Real-time AJAX scanning with progress indicators
- Detailed categorization of SEO issues (warnings, alerts, info, technical)
- Accessibility compliance checking for WCAG 2.0, 2.1, and 2.2 standards
- Optimize extension support for [Experience Builder](https://www.drupal.org/project/experience_builder) pages, allowing editors to run optimization scans without leaving the XB authoring environment

## Installation

1. Install with Composer:  
```sh  
composer require drupal/acquia_optimize
```

2. Enable the module from `/admin/modules`.

## Configuration

**Configuration changes can only be made by those who have been given the `administer acquia optimize` permission on Drupal**

1. Go to the module configuration page on your Drupal installation:
```sh
/admin/config/content/acquia-optimize
```
2. Set the API Key and API Url to the ones from your account on https://new.monsido.com
   - API keys are securely masked in the interface for security
   - The system will validate your API connection before saving

3. Choose an `Accessibility Guideline` level from the dropdown. Available options include:
   - WCAG2-A, WCAG2-AA, WCAG2-AAA
   - WCAG21-A, WCAG21-AA, WCAG21-AAA  
   - WCAG22-A, WCAG22-AA, WCAG22-AAA

4. Enable Debug Mode (optional) for detailed logging during development

## Usage

**The quick scan can be performed by any editor with the permission `scan acquia optimize`**

### Regular Content Pages

The Quick Scan can be performed on content pages in Drupal. This can be found in the side bar under the name `Acquia Optimize`

The plugin cannot be used until the node has been saved. The button will be greyed out if the node is not saved. If the node has been saved, the `Start Quick Scan` button will be clickable, and will perform a quick scan on the node as if it was loaded to a user reading the page.

### Experience Builder (XB) Pages

For sites using [Experience Builder](https://www.drupal.org/project/experience_builder), the Acquia Optimize extension is seamlessly integrated into the XB authoring environment:

1. **Access the Extension**: While editing an XB page, look for the Acquia Optimize extension in the sidebar
2. **One-Click Scanning**: Click the "Start Quick Scan" button to analyze the current page layout
3. **Real-Time Results**: View optimization suggestions without leaving the XB interface
4. **Iterative Improvement**: Make changes to your XB layout and re-scan to see improvements
5. **Context-Aware Analysis**: The scan analyzes the actual rendered output including all XB components and styling

The XB integration allows content creators to:
- Optimize accessibility and SEO while building pages visually
- Test different layout variations for better performance
- Ensure compliance with accessibility guidelines during the design process
- Get immediate feedback on content readability and structure


### Scan Results

The scan results provide detailed information about:

- **Total Issues Found**: Overview of all detected problems
- **SEO Opportunities**: 
  - High impact (warnings)
  - Medium impact (alerts) 
  - Low impact (info)
  - Technical SEO issues
- **Accessibility Issues**: Categorized by WCAG compliance levels (A, AA, AAA)
- **Readability Level**: Assessment of content difficulty

## API Integration

The module uses a factory pattern for API client creation, allowing for:
- Flexible API endpoint configuration
- Secure credential handling
- Connection validation
- Error handling and logging

## Tests

Tests can be run with `phpunit --group acquia-optimize`.

The module includes:
- Unit tests for utility functions
- Functional tests for form validation
- Integration tests for API connectivity
- Render tests for template output
