<?php

namespace Drupal\Tests\acquia_optimize\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the Acquia Optimize button on content edit page.
 *
 * @group acquia_optimize
 */
class CreatePageContentTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['node', 'acquia_optimize'];

  /**
   * Theme to enable.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * A user with permissions to view Optimize button.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $acquiaOptimizeUser;

  /**
   * A user without permissions to view Optimize button.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $normalContentEditor;

  /**
   * An array of node objects.
   *
   * @var \Drupal\node\NodeInterface
   */
  protected $node;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->drupalCreateContentType(['type' => 'page']);
    $this->node = $this->drupalCreateNode(['type' => 'page']);
    $this->acquiaOptimizeUser = $this->createUser(['edit any page content', 'scan acquia optimize'], NULL, FALSE);
    $this->normalContentEditor = $this->createUser(['edit any page content'], NULL, FALSE);
  }

  /**
   * Tests that the button is visible to user with the correct permission.
   */
  public function testButtonIsVisibleToAdminUsers() {
    // Login as user with permission.
    $this->drupalLogin($this->acquiaOptimizeUser);
    $this->drupalGet("/node/{$this->node->id()}/edit");

    // Check if API key is configured to determine expected button text.
    $utilities = \Drupal::service('acquia_optimize.utilities');
    if ($utilities->apiKeyHasBeenSet()) {
      $this->assertSession()->pageTextContains('Acquia Optimize - Quick Scan');
    }
  }

  /**
   * Tests that button is not visible to users without the correct permissions.
   */
  public function testButtonIsNotVisibleToNormalUsers() {
    // Login as user without permission.
    $this->drupalLogin($this->normalContentEditor);
    $this->drupalGet("/node/{$this->node->id()}/edit");

    // The button should not be visible at all, regardless of API key status.
    $this->assertSession()->pageTextNotContains('Acquia Optimize - Quick Scan');
    $this->assertSession()->pageTextNotContains('Acquia Optimize - Configure API');
  }

}
