// SVG components
export const ExternalLinkIcon = () => (
  <svg
    width="14"
    height="14"
    viewBox="0 0 24 24"
    fill="currentColor"
    style={{ marginLeft: '4px' }}
  >
    <path d="M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6v2H5v11h11v-6h2zM13 3v2h4.586l-7.793 7.793 1.414 1.414L19 6.414V11h2V3h-8z"/>
  </svg>
);

// No permission icon component
export const NoPermissionIcon = () => (
  <svg style={{ width: '48px', height: '48px', marginBottom: '15px', color: 'var(--ao-red)' }} viewBox="0 0 24 24" fill="currentColor">
    <path d="M12 4c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm0 14c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"/>
    <path d="M11 7h2v7h-2zm0 8h2v2h-2z"/>
  </svg>
);

// Wheel icon component
export const WheelIcon = () => (
  <svg
    width="14"
    height="14"
    viewBox="0 0 24 24"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    style={{ marginRight: '5px' }}
  >
    <path d="M12.22 2h-.44a2 2 0 0 0-2 2v.18a2 2 0 0 1-1 1.73l-.43.25a2 2 0 0 1-2 0l-.15-.08a2 2 0 0 0-2.73.73l-.22.38a2 2 0 0 0 .73 2.73l.15.1a2 2 0 0 1 1 1.72v.51a2 2 0 0 1-1 1.74l-.15.09a2 2 0 0 0-.73 2.73l.22.38a2 2 0 0 0 2.73.73l.15-.08a2 2 0 0 1 2 0l.43.25a2 2 0 0 1 1 1.73V20a2 2 0 0 0 2 2h.44a2 2 0 0 0 2-2v-.18a2 2 0 0 1 1-1.73l.43-.25a2 2 0 0 1 2 0l.15.08a2 2 0 0 0 2.73-.73l.22-.39a2 2 0 0 0-.73-2.73l-.15-.08a2 2 0 0 1-1-1.74v-.5a2 2 0 0 1 1-1.74l.15-.09a2 2 0 0 0 .73-2.73l-.22-.38a2 2 0 0 0-2.73-.73l-.15.08a2 2 0 0 1-2 0l-.43-.25a2 2 0 0 1-1-1.73V4a2 2 0 0 0-2-2z" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
    <circle cx="12" cy="12" r="3" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
  </svg>
);

// Retry icon component
export const RetryIcon = () => (
  <svg
    width="16"
    height="16"
    viewBox="0 0 24 24"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
    style={{ marginRight: '8px' }}
  >
    <path d="M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z" fill="white" />
  </svg>
);

export const NoIssueIcon = () => (
  <svg className="ao-results-icon" viewBox="0 0 24 24" fill="currentColor">
    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-2-13.5l-2.5 2.5 6 6 6-6-2.5-2.5-3.5 3.5-3.5-3.5z"/>
  </svg>
);

export const WarningIcon = () => (
  <svg className="ao-results-icon" viewBox="0 0 24 24" fill="currentColor">
    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-1-13h2v6h-2zm0 8h2v2h-2z"/>
  </svg>
);


// Accessibility icon component
export const AccessibilityIcon = () => (
  <svg className="ao-category-icon" viewBox="0 0 24 24" fill="currentColor">
    <path d="M12 5C13.6569 5 15 6.34315 15 8C15 9.65685 13.6569 11 12 11C10.3431 11 9 9.65685 9 8C9 6.34315 10.3431 5 12 5ZM12 12C14.7614 12 17 9.76142 17 7C17 4.23858 14.7614 2 12 2C9.23858 2 7 4.23858 7 7C7 9.76142 9.23858 12 12 12ZM8.5 14C5.46243 14 3 16.4624 3 19.5V21C3 21.5523 3.44772 22 4 22H20C20.5523 22 21 21.5523 21 21V19.5C21 16.4624 18.5376 14 15.5 14H8.5Z"/>
  </svg>
);

// Readability icon component
export const ReadabilityIcon = () => (
  <svg className="ao-category-icon" viewBox="0 0 24 24" fill="currentColor">
    <path d="M3 17V5C3 3.9 3.9 3 5 3H19C20.1 3 21 3.9 21 5V17C21 18.1 20.1 19 19 19H5C3.9 19 3 18.1 3 17ZM5 17H19V5H5V17ZM7 7H17V9H7V7ZM7 11H17V13H7V11Z"/>
  </svg>
);

// Data privacy icon component
export const DataPrivacyIcon = () => (
  <svg style={{ width: '24px', height: '24px', marginRight: '12px', color: '#0078ff' }} viewBox="0 0 24 24" fill="currentColor">
    <path d="M12 1L3 5V11C3 16.55 6.84 21.74 12 23C17.16 21.74 21 16.55 21 11V5L12 1ZM19 11C19 15.5 16.2 19.69 12 21.5C7.8 19.69 5 15.5 5 11V6.3L12 3.19L19 6.3V11ZM12 7C10.34 7 9 8.34 9 10C9 11.31 9.83 12.42 11 12.83V16H13V12.83C14.17 12.42 15 11.31 15 10C15 8.34 13.66 7 12 7ZM12 11C11.45 11 11 10.55 11 10C11 9.45 11.45 9 12 9C12.55 9 13 9.45 13 10C13 10.55 12.55 11 12 11Z"/>
  </svg>
);

// SEO icon component
export const SeoIcon = () => (
  <svg style={{ width: '24px', height: '24px', marginRight: '12px', color: '#0078ff' }} viewBox="0 0 24 24" fill="currentColor">
    <path d="M3 13H5V11H3V13ZM3 17H5V15H3V17ZM3 9H5V7H3V9ZM7 13H21V11H7V13ZM7 17H21V15H7V17ZM7 7V9H21V7H7Z"/>
  </svg>
);

export const GenericCheckIcon = () => (
  <svg style={{ width: '18px', height: '18px', marginRight: '6px', color: '#00cc00' }} viewBox="0 0 24 24" fill="currentColor">
    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-2-5.5l6-6 1.5 1.5-7.5 7.5L6 14l1.5-1.5 2.5 2.5z"/>
  </svg>
);

export const GenericWarningIcon = () => (
  <svg style={{ width: '18px', height: '18px', marginRight: '6px', color: '#cc0000' }} viewBox="0 0 24 24" fill="currentColor">
    <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-1-13h2v6h-2zm0 8h2v2h-2z"/>
  </svg>
);

// Acquia Optimize logo component
export const AcquiaOptimizeLogo = ({ OptimizeLogo = "", alt = "Acquia Optimize logo", className = "ao-logo" }) => (
   <img
      src= {OptimizeLogo}
      alt={alt}
      className={className}
    />
);
