export const useUIHandlers = (state) => {
  // UI interaction handlers
  const toggleSection = (section) => {
    state.setExpandedSections({
      ...state.expandedSections,
      [section]: !state.expandedSections[section]
    });
  };

  const showIssuesForLevel = (level, e) => {
    e.stopPropagation();
    state.setDetailedIssues({
      ...state.detailedIssues,
      [level]: !state.detailedIssues[level]
    });
  };

  const showSeoIssuesForCategory = (category, e) => {
    e.stopPropagation();
    state.setDetailedIssues({
      ...state.detailedIssues,
      [category]: !state.detailedIssues[category]
    });
  };

  return {
    toggleSection,
    showIssuesForLevel,
    showSeoIssuesForCategory
  };
};
