<?php

namespace Drupal\acquia_optimize\Controller;

use Drupal\Core\Entity\EntityInterface;
use Drupal\node\Controller\NodePreviewController;
use Drupal\user\Entity\User;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Controller for Acquia Optimize for node preview page.
 */
class AcquiaOptimizePreviewController extends NodePreviewController {

  /**
   * The account switcher service.
   *
   * @var \Drupal\Core\Session\AccountSwitcherInterface
   */
  protected $accountSwitcher;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->accountSwitcher = $container->get('account_switcher');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function view(EntityInterface $node_preview, $view_mode_id = 'full', $langcode = NULL) {
    // We are switching to anonymous user so that content is rendered without
    // any user-specific context (like personalized content, admin toolbar etc).
    // This ensures that the preview is consistent and not influenced
    // by the current user's permissions or roles.
    $anonymous = User::load(0);
    $this->accountSwitcher->switchTo($anonymous);

    // Get the base render array from parent.
    return parent::view($node_preview, $view_mode_id, $langcode);
  }

}
