<?php

namespace Drupal\Tests\acquia_optimize\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the Acquia Optimize admin form access.
 *
 * @group acquia_optimize
 */
class AdminFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['acquia_optimize'];

  /**
   * A user with admin permissions.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $adminUser;

  /**
   * A user without admin permissions.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $normalUser;

  /**
   * Theme to enable.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->adminUser = $this->drupalCreateUser(['administer acquia optimize']);
    $this->normalUser = $this->drupalCreateUser();
  }

  /**
   * Tests that the admin form is accessible by users with role.
   */
  public function testAdminCanAccessSettingsForm() {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/content/acquia-optimize');
    $this->assertSession()->statusCodeEquals(200);
  }

  /**
   * Tests that the admin can change the form configuration.
   */
  public function testAdminCanChangeSettingsForm() {
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/content/acquia-optimize');
    $this->assertSession()->statusCodeEquals(200);

    // Use a valid API key format and
    // Wrong url format to trigger validation error.
    $edit = [
      'api_key' => 'abcdef0123456789abcdef0123456789abcdef01',
      'api_url' => 'example.com',
      'accessibility' => 'WCAG2-A',
    ];
    $this->submitForm($edit, 'Save configuration');
    $this->assertSession()->pageTextContains('Please enter a valid URL');

    // Correct URL format.
    $edit = [
      'api_key' => 'abcdef0123456789abcdef0123456789abcdef01',
      'api_url' => 'https://example.monsido.com/api',
      'accessibility' => 'WCAG2-A',
    ];
    $this->submitForm($edit, 'Save configuration');

    // The form will fail API connection validation in test environment,
    // so we expect the config not to be saved due to validation errors.
    $this->assertSession()->pageTextNotContains('Please enter a valid URL');

    // Since API connection will fail, expect an error message.
    $this->assertSession()->pageTextContains('API connection failed');
  }

  /**
   * Tests that the admin form is inaccessible by users without role.
   */
  public function testNormalUserCannotAccessSettingsForm() {
    $this->drupalLogin($this->normalUser);
    $this->drupalGet('/admin/config/content/acquia-optimize');
    $this->assertSession()->statusCodeEquals(403);
  }

}
