import { useSelector } from 'react-redux';
import ReactDOM from 'react-dom';
import ConceptProver from './ConceptProver';
import { useState, useEffect } from 'react';

const EXTENSION_ID = 'acquia-optimize';

const AcquiaOptimizeExtension = () => {
  const [portalRoot, setPortalRoot] = useState(null);

  // Get the currently active extension from the XB React app's Redux store.
  const activeExtension = useSelector(
    (state) => state.extensions.activeExtension,
  );

  useEffect(() => {
    if (activeExtension?.id) {
      // Wait for a tick here to ensure the div in the extension modal has been rendered so we can portal
      // our extension into it.
      requestAnimationFrame(() => {
        const targetDiv = document.querySelector(
          `#extensionPortalContainer.xb-extension-${activeExtension.id}`,
        );
        if (targetDiv) {
          setPortalRoot(targetDiv);
        }
      });
    }
  }, [activeExtension]);

  // We don't want to render anything if the Extension is not active in the XB app.
  if (activeExtension?.id !== EXTENSION_ID || !portalRoot) {
    return null;
  }
  return ReactDOM.createPortal(
    <ConceptProver />,
    portalRoot,
  );
};

export default AcquiaOptimizeExtension;
