/**
 * Button component with consistent styling for the Acquia Optimize extension
 */
const Button = (props) => {
  const baseStyles = {
    display: 'inline-flex',
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: 'var(--ao-primary-blue, #0078ff)',
    color: 'white',
    border: 'none',
    borderRadius: '4px',
    padding: '10px 20px',
    fontSize: '15px',
    fontWeight: '600',
    cursor: 'pointer',
    transition: 'background-color 0.2s ease',
    fontFamily: '"SF Pro", system-ui, -apple-system, BlinkMacSystemFont, sans-serif'
  };

  // Combine provided style props with base styles
  const combinedStyles = {
    ...baseStyles,
    ...(props.style || {})
  };

  // Remove style prop to avoid passing it twice
  const { style, ...otherProps } = props;

  return (
    <button
      style={combinedStyles}
      {...otherProps}
    >
      {props.children}
    </button>
  );
};

export default Button;
