(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(require('react-dom'), require('react')) :
  typeof define === 'function' && define.amd ? define(['react-dom', 'react'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.ReactDom, global.React));
})(this, (function (require$$0, ReactOriginal) { 'use strict';

  function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

  function _interopNamespace(e) {
    if (e && e.__esModule) return e;
    var n = Object.create(null);
    if (e) {
      Object.keys(e).forEach(function (k) {
        if (k !== 'default') {
          var d = Object.getOwnPropertyDescriptor(e, k);
          Object.defineProperty(n, k, d.get ? d : {
            enumerable: true,
            get: function () { return e[k]; }
          });
        }
      });
    }
    n["default"] = e;
    return Object.freeze(n);
  }

  var require$$0__default = /*#__PURE__*/_interopDefaultLegacy(require$$0);
  var ReactOriginal__default = /*#__PURE__*/_interopDefaultLegacy(ReactOriginal);
  var ReactOriginal__namespace = /*#__PURE__*/_interopNamespace(ReactOriginal);

  var withSelector = {exports: {}};

  var useSyncExternalStoreWithSelector_development = {};

  /**
   * @license React
   * use-sync-external-store-with-selector.development.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var hasRequiredUseSyncExternalStoreWithSelector_development;

  function requireUseSyncExternalStoreWithSelector_development () {
  	if (hasRequiredUseSyncExternalStoreWithSelector_development) return useSyncExternalStoreWithSelector_development;
  	hasRequiredUseSyncExternalStoreWithSelector_development = 1;

  	{
  	  (function() {

  	/* global __REACT_DEVTOOLS_GLOBAL_HOOK__ */
  	if (
  	  typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ !== 'undefined' &&
  	  typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStart ===
  	    'function'
  	) {
  	  __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStart(new Error());
  	}
  	          var React = ReactOriginal__default["default"];

  	/**
  	 * inlined Object.is polyfill to avoid requiring consumers ship their own
  	 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
  	 */
  	function is(x, y) {
  	  return x === y && (x !== 0 || 1 / x === 1 / y) || x !== x && y !== y // eslint-disable-line no-self-compare
  	  ;
  	}

  	var objectIs = typeof Object.is === 'function' ? Object.is : is;

  	var useSyncExternalStore = React.useSyncExternalStore;

  	// for CommonJS interop.

  	var useRef = React.useRef,
  	    useEffect = React.useEffect,
  	    useMemo = React.useMemo,
  	    useDebugValue = React.useDebugValue; // Same as useSyncExternalStore, but supports selector and isEqual arguments.

  	function useSyncExternalStoreWithSelector(subscribe, getSnapshot, getServerSnapshot, selector, isEqual) {
  	  // Use this to track the rendered snapshot.
  	  var instRef = useRef(null);
  	  var inst;

  	  if (instRef.current === null) {
  	    inst = {
  	      hasValue: false,
  	      value: null
  	    };
  	    instRef.current = inst;
  	  } else {
  	    inst = instRef.current;
  	  }

  	  var _useMemo = useMemo(function () {
  	    // Track the memoized state using closure variables that are local to this
  	    // memoized instance of a getSnapshot function. Intentionally not using a
  	    // useRef hook, because that state would be shared across all concurrent
  	    // copies of the hook/component.
  	    var hasMemo = false;
  	    var memoizedSnapshot;
  	    var memoizedSelection;

  	    var memoizedSelector = function (nextSnapshot) {
  	      if (!hasMemo) {
  	        // The first time the hook is called, there is no memoized result.
  	        hasMemo = true;
  	        memoizedSnapshot = nextSnapshot;

  	        var _nextSelection = selector(nextSnapshot);

  	        if (isEqual !== undefined) {
  	          // Even if the selector has changed, the currently rendered selection
  	          // may be equal to the new selection. We should attempt to reuse the
  	          // current value if possible, to preserve downstream memoizations.
  	          if (inst.hasValue) {
  	            var currentSelection = inst.value;

  	            if (isEqual(currentSelection, _nextSelection)) {
  	              memoizedSelection = currentSelection;
  	              return currentSelection;
  	            }
  	          }
  	        }

  	        memoizedSelection = _nextSelection;
  	        return _nextSelection;
  	      } // We may be able to reuse the previous invocation's result.


  	      // We may be able to reuse the previous invocation's result.
  	      var prevSnapshot = memoizedSnapshot;
  	      var prevSelection = memoizedSelection;

  	      if (objectIs(prevSnapshot, nextSnapshot)) {
  	        // The snapshot is the same as last time. Reuse the previous selection.
  	        return prevSelection;
  	      } // The snapshot has changed, so we need to compute a new selection.


  	      // The snapshot has changed, so we need to compute a new selection.
  	      var nextSelection = selector(nextSnapshot); // If a custom isEqual function is provided, use that to check if the data
  	      // has changed. If it hasn't, return the previous selection. That signals
  	      // to React that the selections are conceptually equal, and we can bail
  	      // out of rendering.

  	      // If a custom isEqual function is provided, use that to check if the data
  	      // has changed. If it hasn't, return the previous selection. That signals
  	      // to React that the selections are conceptually equal, and we can bail
  	      // out of rendering.
  	      if (isEqual !== undefined && isEqual(prevSelection, nextSelection)) {
  	        return prevSelection;
  	      }

  	      memoizedSnapshot = nextSnapshot;
  	      memoizedSelection = nextSelection;
  	      return nextSelection;
  	    }; // Assigning this to a constant so that Flow knows it can't change.


  	    // Assigning this to a constant so that Flow knows it can't change.
  	    var maybeGetServerSnapshot = getServerSnapshot === undefined ? null : getServerSnapshot;

  	    var getSnapshotWithSelector = function () {
  	      return memoizedSelector(getSnapshot());
  	    };

  	    var getServerSnapshotWithSelector = maybeGetServerSnapshot === null ? undefined : function () {
  	      return memoizedSelector(maybeGetServerSnapshot());
  	    };
  	    return [getSnapshotWithSelector, getServerSnapshotWithSelector];
  	  }, [getSnapshot, getServerSnapshot, selector, isEqual]),
  	      getSelection = _useMemo[0],
  	      getServerSelection = _useMemo[1];

  	  var value = useSyncExternalStore(subscribe, getSelection, getServerSelection);
  	  useEffect(function () {
  	    inst.hasValue = true;
  	    inst.value = value;
  	  }, [value]);
  	  useDebugValue(value);
  	  return value;
  	}

  	useSyncExternalStoreWithSelector_development.useSyncExternalStoreWithSelector = useSyncExternalStoreWithSelector;
  	          /* global __REACT_DEVTOOLS_GLOBAL_HOOK__ */
  	if (
  	  typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ !== 'undefined' &&
  	  typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStop ===
  	    'function'
  	) {
  	  __REACT_DEVTOOLS_GLOBAL_HOOK__.registerInternalModuleStop(new Error());
  	}
  	        
  	  })();
  	}
  	return useSyncExternalStoreWithSelector_development;
  }

  var hasRequiredWithSelector;

  function requireWithSelector () {
  	if (hasRequiredWithSelector) return withSelector.exports;
  	hasRequiredWithSelector = 1;

  	{
  	  withSelector.exports = requireUseSyncExternalStoreWithSelector_development();
  	}
  	return withSelector.exports;
  }

  var withSelectorExports = requireWithSelector();

  // src/index.ts
  var React = (
    // prettier-ignore
    // @ts-ignore
    "default" in ReactOriginal__namespace ? ReactOriginal__namespace["default"] : ReactOriginal__namespace
  );

  // src/components/Context.ts
  var ContextKey = Symbol.for(`react-redux-context`);
  var gT = typeof globalThis !== "undefined" ? globalThis : (
    /* fall back to a per-module scope (pre-8.1 behaviour) if `globalThis` is not available */
    {}
  );
  function getContext() {
    if (!React.createContext)
      return {};
    const contextMap = gT[ContextKey] ?? (gT[ContextKey] = /* @__PURE__ */ new Map());
    let realContext = contextMap.get(React.createContext);
    if (!realContext) {
      realContext = React.createContext(
        null
      );
      {
        realContext.displayName = "ReactRedux";
      }
      contextMap.set(React.createContext, realContext);
    }
    return realContext;
  }
  var ReactReduxContext = /* @__PURE__ */ getContext();

  // src/utils/useSyncExternalStore.ts
  var notInitialized = () => {
    throw new Error("uSES not initialized!");
  };

  // src/hooks/useReduxContext.ts
  function createReduxContextHook(context = ReactReduxContext) {
    return function useReduxContext2() {
      const contextValue = React.useContext(context);
      if (!contextValue) {
        throw new Error(
          "could not find react-redux context value; please ensure the component is wrapped in a <Provider>"
        );
      }
      return contextValue;
    };
  }
  var useReduxContext = /* @__PURE__ */ createReduxContextHook();

  // src/hooks/useSelector.ts
  var useSyncExternalStoreWithSelector = notInitialized;
  var initializeUseSelector = (fn) => {
    useSyncExternalStoreWithSelector = fn;
  };
  var refEquality = (a, b) => a === b;
  function createSelectorHook(context = ReactReduxContext) {
    const useReduxContext2 = context === ReactReduxContext ? useReduxContext : createReduxContextHook(context);
    const useSelector2 = (selector, equalityFnOrOptions = {}) => {
      const { equalityFn = refEquality, devModeChecks = {} } = typeof equalityFnOrOptions === "function" ? { equalityFn: equalityFnOrOptions } : equalityFnOrOptions;
      {
        if (!selector) {
          throw new Error(`You must pass a selector to useSelector`);
        }
        if (typeof selector !== "function") {
          throw new Error(`You must pass a function as a selector to useSelector`);
        }
        if (typeof equalityFn !== "function") {
          throw new Error(
            `You must pass a function as an equality function to useSelector`
          );
        }
      }
      const {
        store,
        subscription,
        getServerState,
        stabilityCheck,
        identityFunctionCheck
      } = useReduxContext2();
      const firstRun = React.useRef(true);
      const wrappedSelector = React.useCallback(
        {
          [selector.name](state) {
            const selected = selector(state);
            {
              const {
                identityFunctionCheck: finalIdentityFunctionCheck,
                stabilityCheck: finalStabilityCheck
              } = {
                stabilityCheck,
                identityFunctionCheck,
                ...devModeChecks
              };
              if (finalStabilityCheck === "always" || finalStabilityCheck === "once" && firstRun.current) {
                const toCompare = selector(state);
                if (!equalityFn(selected, toCompare)) {
                  let stack = void 0;
                  try {
                    throw new Error();
                  } catch (e) {
                    ({ stack } = e);
                  }
                  console.warn(
                    "Selector " + (selector.name || "unknown") + " returned a different result when called with the same parameters. This can lead to unnecessary rerenders.\nSelectors that return a new reference (such as an object or an array) should be memoized: https://redux.js.org/usage/deriving-data-selectors#optimizing-selectors-with-memoization",
                    {
                      state,
                      selected,
                      selected2: toCompare,
                      stack
                    }
                  );
                }
              }
              if (finalIdentityFunctionCheck === "always" || finalIdentityFunctionCheck === "once" && firstRun.current) {
                if (selected === state) {
                  let stack = void 0;
                  try {
                    throw new Error();
                  } catch (e) {
                    ({ stack } = e);
                  }
                  console.warn(
                    "Selector " + (selector.name || "unknown") + " returned the root state when called. This can lead to unnecessary rerenders.\nSelectors that return the entire state are almost certainly a mistake, as they will cause a rerender whenever *anything* in state changes.",
                    { stack }
                  );
                }
              }
              if (firstRun.current)
                firstRun.current = false;
            }
            return selected;
          }
        }[selector.name],
        [selector, stabilityCheck, devModeChecks.stabilityCheck]
      );
      const selectedState = useSyncExternalStoreWithSelector(
        subscription.addNestedSub,
        store.getState,
        getServerState || store.getState,
        wrappedSelector,
        equalityFn
      );
      React.useDebugValue(selectedState);
      return selectedState;
    };
    Object.assign(useSelector2, {
      withTypes: () => useSelector2
    });
    return useSelector2;
  }
  var useSelector = /* @__PURE__ */ createSelectorHook();

  // src/utils/batch.ts
  function defaultNoopBatch(callback) {
    callback();
  }

  // src/utils/Subscription.ts
  function createListenerCollection() {
    let first = null;
    let last = null;
    return {
      clear() {
        first = null;
        last = null;
      },
      notify() {
        defaultNoopBatch(() => {
          let listener = first;
          while (listener) {
            listener.callback();
            listener = listener.next;
          }
        });
      },
      get() {
        const listeners = [];
        let listener = first;
        while (listener) {
          listeners.push(listener);
          listener = listener.next;
        }
        return listeners;
      },
      subscribe(callback) {
        let isSubscribed = true;
        const listener = last = {
          callback,
          next: null,
          prev: last
        };
        if (listener.prev) {
          listener.prev.next = listener;
        } else {
          first = listener;
        }
        return function unsubscribe() {
          if (!isSubscribed || first === null)
            return;
          isSubscribed = false;
          if (listener.next) {
            listener.next.prev = listener.prev;
          } else {
            last = listener.prev;
          }
          if (listener.prev) {
            listener.prev.next = listener.next;
          } else {
            first = listener.next;
          }
        };
      }
    };
  }
  var nullListeners = {
    notify() {
    },
    get: () => []
  };
  function createSubscription(store, parentSub) {
    let unsubscribe;
    let listeners = nullListeners;
    let subscriptionsAmount = 0;
    let selfSubscribed = false;
    function addNestedSub(listener) {
      trySubscribe();
      const cleanupListener = listeners.subscribe(listener);
      let removed = false;
      return () => {
        if (!removed) {
          removed = true;
          cleanupListener();
          tryUnsubscribe();
        }
      };
    }
    function notifyNestedSubs() {
      listeners.notify();
    }
    function handleChangeWrapper() {
      if (subscription.onStateChange) {
        subscription.onStateChange();
      }
    }
    function isSubscribed() {
      return selfSubscribed;
    }
    function trySubscribe() {
      subscriptionsAmount++;
      if (!unsubscribe) {
        unsubscribe = parentSub ? parentSub.addNestedSub(handleChangeWrapper) : store.subscribe(handleChangeWrapper);
        listeners = createListenerCollection();
      }
    }
    function tryUnsubscribe() {
      subscriptionsAmount--;
      if (unsubscribe && subscriptionsAmount === 0) {
        unsubscribe();
        unsubscribe = void 0;
        listeners.clear();
        listeners = nullListeners;
      }
    }
    function trySubscribeSelf() {
      if (!selfSubscribed) {
        selfSubscribed = true;
        trySubscribe();
      }
    }
    function tryUnsubscribeSelf() {
      if (selfSubscribed) {
        selfSubscribed = false;
        tryUnsubscribe();
      }
    }
    const subscription = {
      addNestedSub,
      notifyNestedSubs,
      handleChangeWrapper,
      isSubscribed,
      trySubscribe: trySubscribeSelf,
      tryUnsubscribe: tryUnsubscribeSelf,
      getListeners: () => listeners
    };
    return subscription;
  }

  // src/utils/useIsomorphicLayoutEffect.ts
  var canUseDOM = !!(typeof window !== "undefined" && typeof window.document !== "undefined" && typeof window.document.createElement !== "undefined");
  var isReactNative = typeof navigator !== "undefined" && navigator.product === "ReactNative";
  var useIsomorphicLayoutEffect = canUseDOM || isReactNative ? React.useLayoutEffect : React.useEffect;

  // src/components/Provider.tsx
  function Provider({
    store,
    context,
    children,
    serverState,
    stabilityCheck = "once",
    identityFunctionCheck = "once"
  }) {
    const contextValue = React.useMemo(() => {
      const subscription = createSubscription(store);
      return {
        store,
        subscription,
        getServerState: serverState ? () => serverState : void 0,
        stabilityCheck,
        identityFunctionCheck
      };
    }, [store, serverState, stabilityCheck, identityFunctionCheck]);
    const previousState = React.useMemo(() => store.getState(), [store]);
    useIsomorphicLayoutEffect(() => {
      const { subscription } = contextValue;
      subscription.onStateChange = subscription.notifyNestedSubs;
      subscription.trySubscribe();
      if (previousState !== store.getState()) {
        subscription.notifyNestedSubs();
      }
      return () => {
        subscription.tryUnsubscribe();
        subscription.onStateChange = void 0;
      };
    }, [contextValue, previousState]);
    const Context = context || ReactReduxContext;
    return /* @__PURE__ */ React.createElement(Context.Provider, { value: contextValue }, children);
  }
  var Provider_default = Provider;

  // src/index.ts
  initializeUseSelector(withSelectorExports.useSyncExternalStoreWithSelector);

  var client = {};

  var hasRequiredClient;

  function requireClient () {
  	if (hasRequiredClient) return client;
  	hasRequiredClient = 1;

  	var m = require$$0__default["default"];
  	{
  	  var i = m.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;
  	  client.createRoot = function(c, o) {
  	    i.usingClientEntryPoint = true;
  	    try {
  	      return m.createRoot(c, o);
  	    } finally {
  	      i.usingClientEntryPoint = false;
  	    }
  	  };
  	  client.hydrateRoot = function(c, h, o) {
  	    i.usingClientEntryPoint = true;
  	    try {
  	      return m.hydrateRoot(c, h, o);
  	    } finally {
  	      i.usingClientEntryPoint = false;
  	    }
  	  };
  	}
  	return client;
  }

  var clientExports = requireClient();

  function _arrayLikeToArray(r, a) {
    (null == a || a > r.length) && (a = r.length);
    for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e];
    return n;
  }
  function _arrayWithHoles(r) {
    if (Array.isArray(r)) return r;
  }
  function _assertThisInitialized(e) {
    if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    return e;
  }
  function asyncGeneratorStep(n, t, e, r, o, a, c) {
    try {
      var i = n[a](c),
        u = i.value;
    } catch (n) {
      return void e(n);
    }
    i.done ? t(u) : Promise.resolve(u).then(r, o);
  }
  function _asyncToGenerator(n) {
    return function () {
      var t = this,
        e = arguments;
      return new Promise(function (r, o) {
        var a = n.apply(t, e);
        function _next(n) {
          asyncGeneratorStep(a, r, o, _next, _throw, "next", n);
        }
        function _throw(n) {
          asyncGeneratorStep(a, r, o, _next, _throw, "throw", n);
        }
        _next(void 0);
      });
    };
  }
  function _callSuper(t, o, e) {
    return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e));
  }
  function _classCallCheck(a, n) {
    if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function");
  }
  function _construct(t, e, r) {
    if (_isNativeReflectConstruct()) return Reflect.construct.apply(null, arguments);
    var o = [null];
    o.push.apply(o, e);
    var p = new (t.bind.apply(t, o))();
    return r && _setPrototypeOf(p, r.prototype), p;
  }
  function _defineProperties(e, r) {
    for (var t = 0; t < r.length; t++) {
      var o = r[t];
      o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o);
    }
  }
  function _createClass(e, r, t) {
    return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", {
      writable: !1
    }), e;
  }
  function _defineProperty(e, r, t) {
    return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, {
      value: t,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }) : e[r] = t, e;
  }
  function _getPrototypeOf(t) {
    return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) {
      return t.__proto__ || Object.getPrototypeOf(t);
    }, _getPrototypeOf(t);
  }
  function _inherits(t, e) {
    if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function");
    t.prototype = Object.create(e && e.prototype, {
      constructor: {
        value: t,
        writable: !0,
        configurable: !0
      }
    }), Object.defineProperty(t, "prototype", {
      writable: !1
    }), e && _setPrototypeOf(t, e);
  }
  function _isNativeFunction(t) {
    try {
      return -1 !== Function.toString.call(t).indexOf("[native code]");
    } catch (n) {
      return "function" == typeof t;
    }
  }
  function _isNativeReflectConstruct() {
    try {
      var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
    } catch (t) {}
    return (_isNativeReflectConstruct = function () {
      return !!t;
    })();
  }
  function _iterableToArrayLimit(r, l) {
    var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"];
    if (null != t) {
      var e,
        n,
        i,
        u,
        a = [],
        f = !0,
        o = !1;
      try {
        if (i = (t = t.call(r)).next, 0 === l) {
          if (Object(t) !== t) return;
          f = !1;
        } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0);
      } catch (r) {
        o = !0, n = r;
      } finally {
        try {
          if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return;
        } finally {
          if (o) throw n;
        }
      }
      return a;
    }
  }
  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  function ownKeys(e, r) {
    var t = Object.keys(e);
    if (Object.getOwnPropertySymbols) {
      var o = Object.getOwnPropertySymbols(e);
      r && (o = o.filter(function (r) {
        return Object.getOwnPropertyDescriptor(e, r).enumerable;
      })), t.push.apply(t, o);
    }
    return t;
  }
  function _objectSpread2(e) {
    for (var r = 1; r < arguments.length; r++) {
      var t = null != arguments[r] ? arguments[r] : {};
      r % 2 ? ownKeys(Object(t), !0).forEach(function (r) {
        _defineProperty(e, r, t[r]);
      }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) {
        Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r));
      });
    }
    return e;
  }
  function _objectWithoutProperties(e, t) {
    if (null == e) return {};
    var o,
      r,
      i = _objectWithoutPropertiesLoose(e, t);
    if (Object.getOwnPropertySymbols) {
      var s = Object.getOwnPropertySymbols(e);
      for (r = 0; r < s.length; r++) o = s[r], t.includes(o) || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]);
    }
    return i;
  }
  function _objectWithoutPropertiesLoose(r, e) {
    if (null == r) return {};
    var t = {};
    for (var n in r) if ({}.hasOwnProperty.call(r, n)) {
      if (e.includes(n)) continue;
      t[n] = r[n];
    }
    return t;
  }
  function _possibleConstructorReturn(t, e) {
    if (e && ("object" == typeof e || "function" == typeof e)) return e;
    if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined");
    return _assertThisInitialized(t);
  }
  function _regeneratorRuntime() {
    _regeneratorRuntime = function () {
      return e;
    };
    var t,
      e = {},
      r = Object.prototype,
      n = r.hasOwnProperty,
      o = Object.defineProperty || function (t, e, r) {
        t[e] = r.value;
      },
      i = "function" == typeof Symbol ? Symbol : {},
      a = i.iterator || "@@iterator",
      c = i.asyncIterator || "@@asyncIterator",
      u = i.toStringTag || "@@toStringTag";
    function define(t, e, r) {
      return Object.defineProperty(t, e, {
        value: r,
        enumerable: !0,
        configurable: !0,
        writable: !0
      }), t[e];
    }
    try {
      define({}, "");
    } catch (t) {
      define = function (t, e, r) {
        return t[e] = r;
      };
    }
    function wrap(t, e, r, n) {
      var i = e && e.prototype instanceof Generator ? e : Generator,
        a = Object.create(i.prototype),
        c = new Context(n || []);
      return o(a, "_invoke", {
        value: makeInvokeMethod(t, r, c)
      }), a;
    }
    function tryCatch(t, e, r) {
      try {
        return {
          type: "normal",
          arg: t.call(e, r)
        };
      } catch (t) {
        return {
          type: "throw",
          arg: t
        };
      }
    }
    e.wrap = wrap;
    var h = "suspendedStart",
      l = "suspendedYield",
      f = "executing",
      s = "completed",
      y = {};
    function Generator() {}
    function GeneratorFunction() {}
    function GeneratorFunctionPrototype() {}
    var p = {};
    define(p, a, function () {
      return this;
    });
    var d = Object.getPrototypeOf,
      v = d && d(d(values([])));
    v && v !== r && n.call(v, a) && (p = v);
    var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p);
    function defineIteratorMethods(t) {
      ["next", "throw", "return"].forEach(function (e) {
        define(t, e, function (t) {
          return this._invoke(e, t);
        });
      });
    }
    function AsyncIterator(t, e) {
      function invoke(r, o, i, a) {
        var c = tryCatch(t[r], t, o);
        if ("throw" !== c.type) {
          var u = c.arg,
            h = u.value;
          return h && "object" == typeof h && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) {
            invoke("next", t, i, a);
          }, function (t) {
            invoke("throw", t, i, a);
          }) : e.resolve(h).then(function (t) {
            u.value = t, i(u);
          }, function (t) {
            return invoke("throw", t, i, a);
          });
        }
        a(c.arg);
      }
      var r;
      o(this, "_invoke", {
        value: function (t, n) {
          function callInvokeWithMethodAndArg() {
            return new e(function (e, r) {
              invoke(t, n, e, r);
            });
          }
          return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
        }
      });
    }
    function makeInvokeMethod(e, r, n) {
      var o = h;
      return function (i, a) {
        if (o === f) throw Error("Generator is already running");
        if (o === s) {
          if ("throw" === i) throw a;
          return {
            value: t,
            done: !0
          };
        }
        for (n.method = i, n.arg = a;;) {
          var c = n.delegate;
          if (c) {
            var u = maybeInvokeDelegate(c, n);
            if (u) {
              if (u === y) continue;
              return u;
            }
          }
          if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) {
            if (o === h) throw o = s, n.arg;
            n.dispatchException(n.arg);
          } else "return" === n.method && n.abrupt("return", n.arg);
          o = f;
          var p = tryCatch(e, r, n);
          if ("normal" === p.type) {
            if (o = n.done ? s : l, p.arg === y) continue;
            return {
              value: p.arg,
              done: n.done
            };
          }
          "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg);
        }
      };
    }
    function maybeInvokeDelegate(e, r) {
      var n = r.method,
        o = e.iterator[n];
      if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y;
      var i = tryCatch(o, e.iterator, r.arg);
      if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y;
      var a = i.arg;
      return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y);
    }
    function pushTryEntry(t) {
      var e = {
        tryLoc: t[0]
      };
      1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e);
    }
    function resetTryEntry(t) {
      var e = t.completion || {};
      e.type = "normal", delete e.arg, t.completion = e;
    }
    function Context(t) {
      this.tryEntries = [{
        tryLoc: "root"
      }], t.forEach(pushTryEntry, this), this.reset(!0);
    }
    function values(e) {
      if (e || "" === e) {
        var r = e[a];
        if (r) return r.call(e);
        if ("function" == typeof e.next) return e;
        if (!isNaN(e.length)) {
          var o = -1,
            i = function next() {
              for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next;
              return next.value = t, next.done = !0, next;
            };
          return i.next = i;
        }
      }
      throw new TypeError(typeof e + " is not iterable");
    }
    return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", {
      value: GeneratorFunctionPrototype,
      configurable: !0
    }), o(GeneratorFunctionPrototype, "constructor", {
      value: GeneratorFunction,
      configurable: !0
    }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) {
      var e = "function" == typeof t && t.constructor;
      return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name));
    }, e.mark = function (t) {
      return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t;
    }, e.awrap = function (t) {
      return {
        __await: t
      };
    }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () {
      return this;
    }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) {
      void 0 === i && (i = Promise);
      var a = new AsyncIterator(wrap(t, r, n, o), i);
      return e.isGeneratorFunction(r) ? a : a.next().then(function (t) {
        return t.done ? t.value : a.next();
      });
    }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () {
      return this;
    }), define(g, "toString", function () {
      return "[object Generator]";
    }), e.keys = function (t) {
      var e = Object(t),
        r = [];
      for (var n in e) r.push(n);
      return r.reverse(), function next() {
        for (; r.length;) {
          var t = r.pop();
          if (t in e) return next.value = t, next.done = !1, next;
        }
        return next.done = !0, next;
      };
    }, e.values = values, Context.prototype = {
      constructor: Context,
      reset: function (e) {
        if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t);
      },
      stop: function () {
        this.done = !0;
        var t = this.tryEntries[0].completion;
        if ("throw" === t.type) throw t.arg;
        return this.rval;
      },
      dispatchException: function (e) {
        if (this.done) throw e;
        var r = this;
        function handle(n, o) {
          return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o;
        }
        for (var o = this.tryEntries.length - 1; o >= 0; --o) {
          var i = this.tryEntries[o],
            a = i.completion;
          if ("root" === i.tryLoc) return handle("end");
          if (i.tryLoc <= this.prev) {
            var c = n.call(i, "catchLoc"),
              u = n.call(i, "finallyLoc");
            if (c && u) {
              if (this.prev < i.catchLoc) return handle(i.catchLoc, !0);
              if (this.prev < i.finallyLoc) return handle(i.finallyLoc);
            } else if (c) {
              if (this.prev < i.catchLoc) return handle(i.catchLoc, !0);
            } else {
              if (!u) throw Error("try statement without catch or finally");
              if (this.prev < i.finallyLoc) return handle(i.finallyLoc);
            }
          }
        }
      },
      abrupt: function (t, e) {
        for (var r = this.tryEntries.length - 1; r >= 0; --r) {
          var o = this.tryEntries[r];
          if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) {
            var i = o;
            break;
          }
        }
        i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null);
        var a = i ? i.completion : {};
        return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a);
      },
      complete: function (t, e) {
        if ("throw" === t.type) throw t.arg;
        return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y;
      },
      finish: function (t) {
        for (var e = this.tryEntries.length - 1; e >= 0; --e) {
          var r = this.tryEntries[e];
          if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y;
        }
      },
      catch: function (t) {
        for (var e = this.tryEntries.length - 1; e >= 0; --e) {
          var r = this.tryEntries[e];
          if (r.tryLoc === t) {
            var n = r.completion;
            if ("throw" === n.type) {
              var o = n.arg;
              resetTryEntry(r);
            }
            return o;
          }
        }
        throw Error("illegal catch attempt");
      },
      delegateYield: function (e, r, n) {
        return this.delegate = {
          iterator: values(e),
          resultName: r,
          nextLoc: n
        }, "next" === this.method && (this.arg = t), y;
      }
    }, e;
  }
  function _setPrototypeOf(t, e) {
    return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) {
      return t.__proto__ = e, t;
    }, _setPrototypeOf(t, e);
  }
  function _slicedToArray(r, e) {
    return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest();
  }
  function _toPrimitive(t, r) {
    if ("object" != typeof t || !t) return t;
    var e = t[Symbol.toPrimitive];
    if (void 0 !== e) {
      var i = e.call(t, r || "default");
      if ("object" != typeof i) return i;
      throw new TypeError("@@toPrimitive must return a primitive value.");
    }
    return ("string" === r ? String : Number)(t);
  }
  function _toPropertyKey(t) {
    var i = _toPrimitive(t, "string");
    return "symbol" == typeof i ? i : i + "";
  }
  function _typeof(o) {
    "@babel/helpers - typeof";

    return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) {
      return typeof o;
    } : function (o) {
      return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o;
    }, _typeof(o);
  }
  function _unsupportedIterableToArray(r, a) {
    if (r) {
      if ("string" == typeof r) return _arrayLikeToArray(r, a);
      var t = {}.toString.call(r).slice(8, -1);
      return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0;
    }
  }
  function _wrapNativeSuper(t) {
    var r = "function" == typeof Map ? new Map() : void 0;
    return _wrapNativeSuper = function (t) {
      if (null === t || !_isNativeFunction(t)) return t;
      if ("function" != typeof t) throw new TypeError("Super expression must either be null or a function");
      if (void 0 !== r) {
        if (r.has(t)) return r.get(t);
        r.set(t, Wrapper);
      }
      function Wrapper() {
        return _construct(t, arguments, _getPrototypeOf(this).constructor);
      }
      return Wrapper.prototype = Object.create(t.prototype, {
        constructor: {
          value: Wrapper,
          enumerable: !1,
          writable: !0,
          configurable: !0
        }
      }), _setPrototypeOf(Wrapper, t);
    }, _wrapNativeSuper(t);
  }

  var useConceptProverState = function useConceptProverState() {
    // Form and UI state
    var _useState = ReactOriginal.useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      showApiKeyForm = _useState2[0],
      setShowApiKeyForm = _useState2[1];
    var _useState3 = ReactOriginal.useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isLoading = _useState4[0],
      setIsLoading = _useState4[1];
    var _useState5 = ReactOriginal.useState(''),
      _useState6 = _slicedToArray(_useState5, 2),
      apiKey = _useState6[0],
      setApiKey = _useState6[1];
    var _useState7 = ReactOriginal.useState(''),
      _useState8 = _slicedToArray(_useState7, 2),
      apiUrl = _useState8[0],
      setApiUrl = _useState8[1];
    var _useState9 = ReactOriginal.useState('WCAG21-AA'),
      _useState10 = _slicedToArray(_useState9, 2),
      accessibilityGuideline = _useState10[0],
      setAccessibilityGuideline = _useState10[1];
    var _useState11 = ReactOriginal.useState(''),
      _useState12 = _slicedToArray(_useState11, 2),
      helperText = _useState12[0],
      setHelperText = _useState12[1];
    var _useState13 = ReactOriginal.useState('initial'),
      _useState14 = _slicedToArray(_useState13, 2),
      currentView = _useState14[0],
      setCurrentView = _useState14[1];
    var _useState15 = ReactOriginal.useState(''),
      _useState16 = _slicedToArray(_useState15, 2),
      csrfToken = _useState16[0],
      setCsrfToken = _useState16[1];

    // Scan related state
    var _useState17 = ReactOriginal.useState(0),
      _useState18 = _slicedToArray(_useState17, 2),
      scanProgress = _useState18[0],
      setScanProgress = _useState18[1];
    var _useState19 = ReactOriginal.useState(null),
      _useState20 = _slicedToArray(_useState19, 2),
      scanResults = _useState20[0],
      setScanResults = _useState20[1];
    var _useState21 = ReactOriginal.useState(null),
      _useState22 = _slicedToArray(_useState21, 2),
      scanId = _useState22[0],
      setScanId = _useState22[1];

    // UI state
    var _useState23 = ReactOriginal.useState(true),
      _useState24 = _slicedToArray(_useState23, 2),
      isDebugMode = _useState24[0],
      setIsDebugMode = _useState24[1]; // Temporarily enabled for debugging
    var _useState25 = ReactOriginal.useState({
        accessibility: false,
        readability: false,
        seo: false,
        dataPrivacy: false
      }),
      _useState26 = _slicedToArray(_useState25, 2),
      expandedSections = _useState26[0],
      setExpandedSections = _useState26[1];
    var _useState27 = ReactOriginal.useState({
        A: false,
        AA: false,
        AAA: false,
        high: false,
        medium: false,
        low: false,
        technical: false
      }),
      _useState28 = _slicedToArray(_useState27, 2),
      detailedIssues = _useState28[0],
      setDetailedIssues = _useState28[1];

    // Permission state
    var _useState29 = ReactOriginal.useState(false),
      _useState30 = _slicedToArray(_useState29, 2),
      canConfigure = _useState30[0],
      setCanConfigure = _useState30[1];
    var _useState31 = ReactOriginal.useState(false),
      _useState32 = _slicedToArray(_useState31, 2),
      canScan = _useState32[0],
      setCanScan = _useState32[1];
    var _useState33 = ReactOriginal.useState(true),
      _useState34 = _slicedToArray(_useState33, 2),
      isInitialLoading = _useState34[0],
      setIsInitialLoading = _useState34[1];
    return {
      // Form state
      showApiKeyForm: showApiKeyForm,
      setShowApiKeyForm: setShowApiKeyForm,
      isLoading: isLoading,
      setIsLoading: setIsLoading,
      apiKey: apiKey,
      setApiKey: setApiKey,
      apiUrl: apiUrl,
      setApiUrl: setApiUrl,
      accessibilityGuideline: accessibilityGuideline,
      setAccessibilityGuideline: setAccessibilityGuideline,
      helperText: helperText,
      setHelperText: setHelperText,
      currentView: currentView,
      setCurrentView: setCurrentView,
      csrfToken: csrfToken,
      setCsrfToken: setCsrfToken,
      // Scan state
      scanProgress: scanProgress,
      setScanProgress: setScanProgress,
      scanResults: scanResults,
      setScanResults: setScanResults,
      scanId: scanId,
      setScanId: setScanId,
      // UI state
      isDebugMode: isDebugMode,
      setIsDebugMode: setIsDebugMode,
      expandedSections: expandedSections,
      setExpandedSections: setExpandedSections,
      detailedIssues: detailedIssues,
      setDetailedIssues: setDetailedIssues,
      // Permission state
      canConfigure: canConfigure,
      setCanConfigure: setCanConfigure,
      canScan: canScan,
      setCanScan: setCanScan,
      isInitialLoading: isInitialLoading,
      setIsInitialLoading: setIsInitialLoading
    };
  };

  // Helper function for conditional logging
  var debugError = function debugError(debugMode) {
    if (debugMode) {
      var _console;
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      (_console = console).error.apply(_console, args);
    }
  };

  // Get the dynamic module path from xbExtension settings
  var getDrupalSettings = function getDrupalSettings() {
    var _drupalSettings$xbExt;
    var _window = window,
      drupalSettings = _window.drupalSettings;
    return {
      imgSrc: (drupalSettings === null || drupalSettings === void 0 || (_drupalSettings$xbExt = drupalSettings.xbExtension) === null || _drupalSettings$xbExt === void 0 || (_drupalSettings$xbExt = _drupalSettings$xbExt.acquiaOptimize) === null || _drupalSettings$xbExt === void 0 ? void 0 : _drupalSettings$xbExt.imgSrc) || '',
      csrfToken: (drupalSettings === null || drupalSettings === void 0 ? void 0 : drupalSettings.csrf_token) || ''
    };
  };

  // Function to format the date in "Mon, 25 Nov 2024" format
  var formatScanDate = function formatScanDate() {
    var now = new Date();
    var options = {
      weekday: 'short',
      day: 'numeric',
      month: 'short',
      year: 'numeric'
    };
    return now.toLocaleDateString('en-US', options);
  };

  var _excluded$2 = ["encoded_page"];

  // API Error handling utility
  var ApiError = /*#__PURE__*/function (_Error) {
    function ApiError(message, statusCode) {
      var _this;
      var isRetryable = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      var originalError = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;
      var errorType = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 'API_ERROR';
      _classCallCheck(this, ApiError);
      _this = _callSuper(this, ApiError, [message]);
      _this.name = 'ApiError';
      _this.statusCode = statusCode;
      _this.isRetryable = isRetryable;
      _this.originalError = originalError;
      _this.errorType = errorType;
      _this.timestamp = new Date().toISOString();
      _this.preventFormSubmission = true; // Always prevent form submission on API errors
      return _this;
    }

    // Get user-friendly error details for UI display
    _inherits(ApiError, _Error);
    return _createClass(ApiError, [{
      key: "getErrorDetails",
      value: function getErrorDetails() {
        return {
          message: this.message,
          statusCode: this.statusCode,
          errorType: this.errorType,
          timestamp: this.timestamp,
          isRetryable: this.isRetryable,
          preventFormSubmission: this.preventFormSubmission
        };
      }

      // Check if error should be displayed to user
    }, {
      key: "shouldDisplayToUser",
      value: function shouldDisplayToUser() {
        // Don't display network timeouts as prominently
        return this.errorType !== 'NETWORK_TIMEOUT';
      }

      // Get field-specific errors for form validation
    }, {
      key: "getFieldErrors",
      value: function getFieldErrors() {
        var _this$originalError;
        var fieldErrors = {};
        if (this.statusCode === 400 && (_this$originalError = this.originalError) !== null && _this$originalError !== void 0 && _this$originalError.details) {
          // Parse validation errors from API response
          var details = this.originalError.details;
          if (details.errors) {
            Object.keys(details.errors).forEach(function (field) {
              fieldErrors[field] = details.errors[field];
            });
          }
        } else if (this.statusCode === 401) {
          fieldErrors.api_key = 'Invalid API key. Please check your credentials.';
        } else if (this.statusCode === 403 || this.statusCode === 422) {
          fieldErrors.api_key = 'Access denied. Please verify your API key and permissions.';
        }
        return fieldErrors;
      }
    }]);
  }(/*#__PURE__*/_wrapNativeSuper(Error)); // Status code to error message mapping
  var statusMessages = {
    400: 'Invalid request. Please check your input and try again.',
    401: 'Authentication failed. Please check your API key.',
    403: 'Access denied. You may not have permission to access this resource.',
    404: 'The requested resource was not found.',
    422: 'Access to the Acquia Optimize API was denied. Contact your administrator for help.',
    429: 'Too many requests. Please wait before trying again.',
    500: 'Server error occurred. Please try again later.',
    502: 'Service temporarily unavailable. Please try again later.',
    503: 'Service temporarily unavailable. Please try again later.',
    504: 'Request timeout. Please try again later.'
  };

  // Error types for better categorization
  var ERROR_TYPES = {
    VALIDATION_ERROR: 'VALIDATION_ERROR',
    AUTHENTICATION_ERROR: 'AUTHENTICATION_ERROR',
    AUTHORIZATION_ERROR: 'AUTHORIZATION_ERROR',
    NOT_FOUND_ERROR: 'NOT_FOUND_ERROR',
    RATE_LIMIT_ERROR: 'RATE_LIMIT_ERROR',
    SERVER_ERROR: 'SERVER_ERROR',
    NETWORK_ERROR: 'NETWORK_ERROR',
    TIMEOUT_ERROR: 'TIMEOUT_ERROR',
    UNKNOWN_ERROR: 'UNKNOWN_ERROR'
  };

  // Map status codes to error types
  var statusCodeToErrorType = {
    400: ERROR_TYPES.VALIDATION_ERROR,
    401: ERROR_TYPES.AUTHENTICATION_ERROR,
    403: ERROR_TYPES.AUTHORIZATION_ERROR,
    404: ERROR_TYPES.NOT_FOUND_ERROR,
    422: ERROR_TYPES.AUTHORIZATION_ERROR,
    429: ERROR_TYPES.RATE_LIMIT_ERROR,
    500: ERROR_TYPES.SERVER_ERROR,
    502: ERROR_TYPES.SERVER_ERROR,
    503: ERROR_TYPES.SERVER_ERROR,
    504: ERROR_TYPES.TIMEOUT_ERROR
  };

  // Timeout error codes
  var TIMEOUT_CODES = {
    NETWORK_TIMEOUT: 'NETWORK_TIMEOUT',
    REQUEST_TIMEOUT: 'REQUEST_TIMEOUT',
    ABORT_TIMEOUT: 'ABORT_TIMEOUT'
  };

  // Retryable status codes
  var RETRYABLE_STATUS_CODES = [429, 500, 502, 503, 504];

  /**
   * Get user-friendly error message from status code
   * @param {number} statusCode - HTTP status code
   * @param {string} defaultMessage - Default message if status code not mapped
   * @returns {string} User-friendly error message
   */
  var getErrorMessage = function getErrorMessage(statusCode) {
    var defaultMessage = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'An unexpected error occurred';
    return statusMessages[statusCode] || defaultMessage;
  };

  /**
   * Check if an error is retryable
   * @param {number|string} statusCode - HTTP status code or timeout code
   * @returns {boolean} Whether the error is retryable
   */
  var isRetryableError = function isRetryableError(statusCode) {
    if (typeof statusCode === 'string') {
      // Handle timeout codes
      return Object.values(TIMEOUT_CODES).includes(statusCode);
    }
    return RETRYABLE_STATUS_CODES.includes(statusCode);
  };

  /**
   * Create a timeout promise that rejects after specified milliseconds
   * @param {number} ms - Timeout in milliseconds
   * @param {string} timeoutType - Type of timeout for error handling
   * @returns {Promise} Promise that rejects with timeout error
   */
  var createTimeoutPromise = function createTimeoutPromise(ms) {
    var timeoutType = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : TIMEOUT_CODES.REQUEST_TIMEOUT;
    return new Promise(function (_, reject) {
      setTimeout(function () {
        reject(new ApiError('Request timeout. Please try again later.', timeoutType, true));
      }, ms);
    });
  };

  /**
   * Enhanced fetch with timeout and comprehensive error handling
   * @param {string} url - Request URL
   * @param {Object} options - Fetch options
   * @param {number} timeout - Timeout in milliseconds (default: 30000)
   * @param {string} csrfToken - CSRF token for POST requests
   * @returns {Promise} Promise that resolves with response or rejects with ApiError
   */
  var fetchWithErrorHandling = /*#__PURE__*/function () {
    var _ref = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(url) {
      var _options$method;
      var options,
        timeout,
        csrfToken,
        controller,
        signal,
        fetchOptions,
        response,
        errorMessage,
        isRetryable,
        errorType,
        errorDetails,
        contentType,
        textResponse,
        _args = arguments;
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            options = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};
            timeout = _args.length > 2 && _args[2] !== undefined ? _args[2] : 30000;
            csrfToken = _args.length > 3 && _args[3] !== undefined ? _args[3] : null;
            controller = new AbortController();
            signal = controller.signal;
            fetchOptions = _objectSpread2(_objectSpread2({}, options), {}, {
              signal: signal,
              credentials: 'same-origin',
              // Essential for Drupal session management
              mode: 'cors',
              headers: _objectSpread2(_objectSpread2({
                'Content-Type': 'application/json',
                'Accept': 'application/json',
                'Cache-Control': 'no-cache, no-store, must-revalidate',
                // Stronger cache prevention
                'X-Requested-With': 'XMLHttpRequest',
                // Identifies as AJAX request
                'Pragma': 'no-cache',
                // Additional cache prevention
                'Expires': '0',
                // Prevent caching
                'Connection': 'keep-alive',
                // Maintain connection
                'User-Agent': navigator.userAgent,
                // Identify browser
                'Accept-Language': navigator.language || 'en-US',
                // Browser language
                'Accept-Encoding': 'gzip, deflate, br'
              }, csrfToken && ['POST'].includes((_options$method = options.method) === null || _options$method === void 0 ? void 0 : _options$method.toUpperCase()) && {
                'X-CSRF-Token': csrfToken
              }), options.headers)
            });
            _context.prev = 6;
            _context.next = 9;
            return Promise.race([fetch(url, fetchOptions), createTimeoutPromise(timeout, TIMEOUT_CODES.REQUEST_TIMEOUT)]);
          case 9:
            response = _context.sent;
            if (response.ok) {
              _context.next = 33;
              break;
            }
            errorMessage = getErrorMessage(response.status);
            isRetryable = isRetryableError(response.status);
            errorType = statusCodeToErrorType[response.status] || ERROR_TYPES.UNKNOWN_ERROR; // Try to get additional error details from response body
            errorDetails = null;
            _context.prev = 15;
            contentType = response.headers.get('content-type');
            if (!(contentType && contentType.includes('application/json'))) {
              _context.next = 23;
              break;
            }
            _context.next = 20;
            return response.json();
          case 20:
            errorDetails = _context.sent;
            _context.next = 28;
            break;
          case 23:
            _context.next = 25;
            return response.text();
          case 25:
            textResponse = _context.sent;
            errorDetails = {
              rawResponse: textResponse
            };
            debugError(true, 'Non-JSON error response:', errorDetails);
          case 28:
            _context.next = 32;
            break;
          case 30:
            _context.prev = 30;
            _context.t0 = _context["catch"](15);
          case 32:
            throw new ApiError(errorMessage, response.status, isRetryable, {
              url: url,
              status: response.status,
              statusText: response.statusText,
              details: errorDetails
            }, errorType);
          case 33:
            return _context.abrupt("return", response);
          case 36:
            _context.prev = 36;
            _context.t1 = _context["catch"](6);
            if (!(_context.t1.name === 'AbortError')) {
              _context.next = 40;
              break;
            }
            throw new ApiError('Request was cancelled. Please try again.', TIMEOUT_CODES.ABORT_TIMEOUT, true, _context.t1, ERROR_TYPES.TIMEOUT_ERROR);
          case 40:
            if (!(_context.t1 instanceof ApiError)) {
              _context.next = 42;
              break;
            }
            throw _context.t1;
          case 42:
            if (!(_context.t1.name === 'TypeError' && _context.t1.message.includes('fetch'))) {
              _context.next = 44;
              break;
            }
            throw new ApiError('Network error. Please check your connection and try again.', TIMEOUT_CODES.NETWORK_TIMEOUT, true, _context.t1, ERROR_TYPES.NETWORK_ERROR);
          case 44:
            throw new ApiError('An unexpected error occurred. Please try again.', 'UNKNOWN_ERROR', false, _context.t1, ERROR_TYPES.UNKNOWN_ERROR);
          case 45:
          case "end":
            return _context.stop();
        }
      }, _callee, null, [[6, 36], [15, 30]]);
    }));
    return function fetchWithErrorHandling(_x) {
      return _ref.apply(this, arguments);
    };
  }();

  /**
   * Retry wrapper for API calls
   * @param {Function} apiCall - Function that returns a Promise
   * @param {number} maxRetries - Maximum number of retries (default: 3)
   * @param {number} baseDelay - Base delay between retries in ms (default: 1000)
   * @returns {Promise} Promise that resolves with result or rejects with final error
   */
  var withRetry = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2(apiCall) {
      var maxRetries,
        baseDelay,
        lastError,
        _loop,
        _ret,
        attempt,
        _args3 = arguments;
      return _regeneratorRuntime().wrap(function _callee2$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            maxRetries = _args3.length > 1 && _args3[1] !== undefined ? _args3[1] : 3;
            baseDelay = _args3.length > 2 && _args3[2] !== undefined ? _args3[2] : 1000;
            _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop() {
              var delay;
              return _regeneratorRuntime().wrap(function _loop$(_context2) {
                while (1) switch (_context2.prev = _context2.next) {
                  case 0:
                    _context2.prev = 0;
                    _context2.next = 3;
                    return apiCall();
                  case 3:
                    _context2.t0 = _context2.sent;
                    return _context2.abrupt("return", {
                      v: _context2.t0
                    });
                  case 7:
                    _context2.prev = 7;
                    _context2.t1 = _context2["catch"](0);
                    lastError = _context2.t1;

                    // Don't retry if it's not a retryable error or if we've reached max retries
                    if (!(!_context2.t1.isRetryable || attempt === maxRetries)) {
                      _context2.next = 12;
                      break;
                    }
                    return _context2.abrupt("return", 0);
                  case 12:
                    // Exponential backoff with jitter
                    delay = baseDelay * Math.pow(2, attempt) + Math.random() * 1000;
                    _context2.next = 15;
                    return new Promise(function (resolve) {
                      return setTimeout(resolve, delay);
                    });
                  case 15:
                  case "end":
                    return _context2.stop();
                }
              }, _loop, null, [[0, 7]]);
            });
            attempt = 0;
          case 4:
            if (!(attempt <= maxRetries)) {
              _context3.next = 14;
              break;
            }
            return _context3.delegateYield(_loop(), "t0", 6);
          case 6:
            _ret = _context3.t0;
            if (!(_ret === 0)) {
              _context3.next = 9;
              break;
            }
            return _context3.abrupt("break", 14);
          case 9:
            if (!_ret) {
              _context3.next = 11;
              break;
            }
            return _context3.abrupt("return", _ret.v);
          case 11:
            attempt++;
            _context3.next = 4;
            break;
          case 14:
            throw lastError;
          case 15:
          case "end":
            return _context3.stop();
        }
      }, _callee2);
    }));
    return function withRetry(_x2) {
      return _ref2.apply(this, arguments);
    };
  }();
  var useApiService = function useApiService() {
    var csrfToken = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    var fetchSettings = /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4() {
        return _regeneratorRuntime().wrap(function _callee4$(_context5) {
          while (1) switch (_context5.prev = _context5.next) {
            case 0:
              return _context5.abrupt("return", withRetry(/*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
                var response;
                return _regeneratorRuntime().wrap(function _callee3$(_context4) {
                  while (1) switch (_context4.prev = _context4.next) {
                    case 0:
                      _context4.next = 2;
                      return fetchWithErrorHandling("/acquia-optimize/api/settings", {
                        method: 'GET'
                      });
                    case 2:
                      response = _context4.sent;
                      _context4.next = 5;
                      return response.json();
                    case 5:
                      return _context4.abrupt("return", _context4.sent);
                    case 6:
                    case "end":
                      return _context4.stop();
                  }
                }, _callee3);
              }))));
            case 1:
            case "end":
              return _context5.stop();
          }
        }, _callee4);
      }));
      return function fetchSettings() {
        return _ref3.apply(this, arguments);
      };
    }();
    var saveSettings = /*#__PURE__*/function () {
      var _ref5 = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee6(settings) {
        return _regeneratorRuntime().wrap(function _callee6$(_context7) {
          while (1) switch (_context7.prev = _context7.next) {
            case 0:
              return _context7.abrupt("return", withRetry(/*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee5() {
                var response;
                return _regeneratorRuntime().wrap(function _callee5$(_context6) {
                  while (1) switch (_context6.prev = _context6.next) {
                    case 0:
                      _context6.next = 2;
                      return fetchWithErrorHandling("/acquia-optimize/api/settings", {
                        method: 'POST',
                        body: JSON.stringify(settings)
                      }, 30000, csrfToken);
                    case 2:
                      response = _context6.sent;
                      _context6.next = 5;
                      return response.json();
                    case 5:
                      return _context6.abrupt("return", _context6.sent);
                    case 6:
                    case "end":
                      return _context6.stop();
                  }
                }, _callee5);
              }))));
            case 1:
            case "end":
              return _context7.stop();
          }
        }, _callee6);
      }));
      return function saveSettings(_x3) {
        return _ref5.apply(this, arguments);
      };
    }();

    /**
     * Validate API connection using the provided credentials
     * This calls the PHP ApiClient::validateApiConnection() method
     * @param {string} apiKey - API key to validate
     * @param {string} apiUrl - API URL to validate
     * @returns {Promise} Promise that resolves with validation result or rejects with error
     */
    var validateApiConnection = /*#__PURE__*/function () {
      var _ref7 = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee7(apiKey, apiUrl) {
        var response;
        return _regeneratorRuntime().wrap(function _callee7$(_context8) {
          while (1) switch (_context8.prev = _context8.next) {
            case 0:
              _context8.next = 2;
              return fetchWithErrorHandling("/acquia-optimize/api/validate-connection", {
                method: 'POST',
                body: JSON.stringify({
                  api_key: apiKey,
                  api_url: apiUrl
                })
              }, 30000, csrfToken);
            case 2:
              response = _context8.sent;
              _context8.next = 5;
              return response.json();
            case 5:
              return _context8.abrupt("return", _context8.sent);
            case 6:
            case "end":
              return _context8.stop();
          }
        }, _callee7);
      }));
      return function validateApiConnection(_x4, _x5) {
        return _ref7.apply(this, arguments);
      };
    }();
    var startQuickScan = /*#__PURE__*/function () {
      var _ref8 = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee9(requestBody) {
        return _regeneratorRuntime().wrap(function _callee9$(_context10) {
          while (1) switch (_context10.prev = _context10.next) {
            case 0:
              return _context10.abrupt("return", withRetry(/*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee8() {
                var encoded_page, otherFields, finalRequestBody, response;
                return _regeneratorRuntime().wrap(function _callee8$(_context9) {
                  while (1) switch (_context9.prev = _context9.next) {
                    case 0:
                      // Handle encoded_page specially - it needs to be a JSON string, but other fields should be normal
                      encoded_page = requestBody.encoded_page, otherFields = _objectWithoutProperties(requestBody, _excluded$2); // Create the final request body with encoded_page properly stringified
                      finalRequestBody = _objectSpread2(_objectSpread2({}, otherFields), {}, {
                        encoded_page: JSON.stringify(encoded_page) // Convert object to JSON string
                      });
                      _context9.next = 4;
                      return fetchWithErrorHandling("/acquia-optimize/api/quick-scan", {
                        method: 'POST',
                        body: JSON.stringify(finalRequestBody)
                      }, 60000, csrfToken);
                    case 4:
                      response = _context9.sent;
                      return _context9.abrupt("return", response);
                    case 6:
                    case "end":
                      return _context9.stop();
                  }
                }, _callee8);
              }))));
            case 1:
            case "end":
              return _context10.stop();
          }
        }, _callee9);
      }));
      return function startQuickScan(_x6) {
        return _ref8.apply(this, arguments);
      };
    }();
    var checkScanStatus = /*#__PURE__*/function () {
      var _ref10 = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee10(scanId, isDebugMode) {
        var response, statusData;
        return _regeneratorRuntime().wrap(function _callee10$(_context11) {
          while (1) switch (_context11.prev = _context11.next) {
            case 0:
              _context11.prev = 0;
              _context11.next = 3;
              return fetchWithErrorHandling("/acquia-optimize/api/quick-scan/".concat(scanId), {
                method: 'GET'
              }, 45000);
            case 3:
              response = _context11.sent;
              _context11.next = 6;
              return response.json();
            case 6:
              statusData = _context11.sent;
              return _context11.abrupt("return", statusData);
            case 10:
              _context11.prev = 10;
              _context11.t0 = _context11["catch"](0);
              if (!(_context11.t0 instanceof ApiError)) {
                _context11.next = 23;
                break;
              }
              debugError(isDebugMode, 'Failed to check scan status:', _context11.t0.statusCode, _context11.t0.message);

              // For scan status checks, handle specific errors differently
              if (!(_context11.t0.statusCode === 404)) {
                _context11.next = 18;
                break;
              }
              return _context11.abrupt("return", null);
            case 18:
              if (![500, 502, 503].includes(_context11.t0.statusCode)) {
                _context11.next = 22;
                break;
              }
              throw _context11.t0;
            case 22:
              throw _context11.t0;
            case 23:
              debugError(isDebugMode, 'Error checking scan status:', _context11.t0);
              throw _context11.t0;
            case 25:
            case "end":
              return _context11.stop();
          }
        }, _callee10, null, [[0, 10]]);
      }));
      return function checkScanStatus(_x7, _x8) {
        return _ref10.apply(this, arguments);
      };
    }();
    return {
      fetchSettings: fetchSettings,
      saveSettings: saveSettings,
      validateApiConnection: validateApiConnection,
      startQuickScan: startQuickScan,
      checkScanStatus: checkScanStatus
    };
  };

  var useFormHandlers = function useFormHandlers(state, apiService) {
    var handleSubmit = /*#__PURE__*/function () {
      var _ref = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(e) {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              e.preventDefault();
              state.setIsLoading(true);
              state.setHelperText('');
              _context.prev = 3;
              _context.next = 6;
              return apiService.saveSettings({
                api_key: state.apiKey,
                api_url: state.apiUrl,
                accessibility: state.accessibilityGuideline
              });
            case 6:
              state.setHelperText('API key saved successfully!');
              // Hide form after successful save and show Quick Scan view
              setTimeout(function () {
                state.setShowApiKeyForm(false);
                state.setHelperText('');
                state.setCurrentView('quick-scan');
              }, 2000);
              _context.next = 14;
              break;
            case 10:
              _context.prev = 10;
              _context.t0 = _context["catch"](3);
              console.error('Error saving settings:', _context.t0);
              state.setHelperText("Error: ".concat(_context.t0.message));
            case 14:
              _context.prev = 14;
              state.setIsLoading(false);
              return _context.finish(14);
            case 17:
            case "end":
              return _context.stop();
          }
        }, _callee, null, [[3, 10, 14, 17]]);
      }));
      return function handleSubmit(_x) {
        return _ref.apply(this, arguments);
      };
    }();
    return {
      handleSubmit: handleSubmit
    };
  };

  var useUIHandlers = function useUIHandlers(state) {
    // UI interaction handlers
    var toggleSection = function toggleSection(section) {
      state.setExpandedSections(_objectSpread2(_objectSpread2({}, state.expandedSections), {}, _defineProperty({}, section, !state.expandedSections[section])));
    };
    var showIssuesForLevel = function showIssuesForLevel(level, e) {
      e.stopPropagation();
      state.setDetailedIssues(_objectSpread2(_objectSpread2({}, state.detailedIssues), {}, _defineProperty({}, level, !state.detailedIssues[level])));
    };
    var showSeoIssuesForCategory = function showSeoIssuesForCategory(category, e) {
      e.stopPropagation();
      state.setDetailedIssues(_objectSpread2(_objectSpread2({}, state.detailedIssues), {}, _defineProperty({}, category, !state.detailedIssues[category])));
    };
    return {
      toggleSection: toggleSection,
      showIssuesForLevel: showIssuesForLevel,
      showSeoIssuesForCategory: showSeoIssuesForCategory
    };
  };

  var HtmlCssCollector = /*#__PURE__*/function () {
    function HtmlCssCollector() {
      var isDebugMode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      _classCallCheck(this, HtmlCssCollector);
      this.isDebugMode = isDebugMode;
      this.tree = null;
      this.css = [];
      this.defaultStyles = {};
      this.disallowedTagNames = ['SCRIPT', 'STYLE', 'NOSCRIPT'];
    }

    /**
     * Collects HTML and CSS from various sources in priority order
     * @param {Object} layout - Redux layout state
     * @returns {Promise<{dom_tree: Object, css: Array, html: string, version: string, viewport: {w: number, h: number}}>}
     */
    return _createClass(HtmlCssCollector, [{
      key: "collectPageContent",
      value: (function () {
        var _collectPageContent = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(layout) {
          var iframeContent, htmlElement, pageHtml, targetDocument, viewport, domTree, cleanedElement, cleanedHtml;
          return _regeneratorRuntime().wrap(function _callee$(_context) {
            while (1) switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return this.getContentFromIframe();
              case 2:
                iframeContent = _context.sent;
                htmlElement = null;
                pageHtml = iframeContent.html;
                targetDocument = null;
                if (iframeContent.html && iframeContent.document) {
                  // Use iframe content as primary source
                  htmlElement = iframeContent.document.documentElement;
                  targetDocument = iframeContent.document;
                  if (this.isDebugMode) {
                    console.log('Using Experience Builder iframe content as primary source');
                  }
                } else {
                  // Fallback to current document
                  htmlElement = document.documentElement;
                  targetDocument = document;
                  pageHtml = document.documentElement.outerHTML;
                  if (this.isDebugMode) {
                    console.log('Using current document as fallback source');
                  }
                }

                // Last resort: Use layout data if no HTML found
                if (!pageHtml && layout) {
                  pageHtml = this.generateHtmlFromLayout(layout);
                  if (this.isDebugMode) {
                    console.warn('Using layout data as final fallback');
                  }
                }
                if (pageHtml) {
                  _context.next = 10;
                  break;
                }
                throw new Error('No HTML content could be collected from any source');
              case 10:
                // Get viewport size from the target document
                viewport = this.getViewPortSize(htmlElement, targetDocument);
                if (!(!viewport.width || !viewport.height)) {
                  _context.next = 13;
                  break;
                }
                throw new Error('No viewport size found');
              case 13:
                // Set default computed styles using the target document
                this.setDefaultComputedStyles(targetDocument);
                // Process DOM tree from the ORIGINAL element, not the cleaned one
                _context.next = 16;
                return this.processTree(htmlElement, targetDocument);
              case 16:
                domTree = _context.sent;
                // Remove extension elements from the HTML element
                cleanedElement = this.removeExtensionElements(htmlElement);
                cleanedHtml = this.cleanUpText(cleanedElement.outerHTML);
                return _context.abrupt("return", {
                  dom_tree: domTree,
                  css: this.css,
                  html: cleanedHtml,
                  version: '4.1.3',
                  viewport: {
                    w: viewport.width,
                    h: viewport.height
                  }
                });
              case 20:
              case "end":
                return _context.stop();
            }
          }, _callee, this);
        }));
        function collectPageContent(_x) {
          return _collectPageContent.apply(this, arguments);
        }
        return collectPageContent;
      }()
      /**
       * Attempts to extract content from Experience Builder iframe - PRIMARY SOURCE
       * @returns {Promise<{html: string, css: string, document: Document|null}>}
       */
      )
    }, {
      key: "getContentFromIframe",
      value: (function () {
        var _getContentFromIframe = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
          var xbIframe, iframeDoc, html;
          return _regeneratorRuntime().wrap(function _callee2$(_context2) {
            while (1) switch (_context2.prev = _context2.next) {
              case 0:
                _context2.prev = 0;
                xbIframe = document.querySelector('[data-xb-swap-active="true"][title="Preview"]');
                if (!(!xbIframe || !xbIframe.contentDocument)) {
                  _context2.next = 5;
                  break;
                }
                if (this.isDebugMode) {
                  console.warn('Experience Builder iframe not found or contentDocument not accessible');
                }
                return _context2.abrupt("return", {
                  html: '',
                  css: '',
                  document: null
                });
              case 5:
                iframeDoc = xbIframe.contentDocument; // Wait for iframe document to be ready
                if (!(iframeDoc.readyState !== 'complete')) {
                  _context2.next = 9;
                  break;
                }
                _context2.next = 9;
                return new Promise(function (resolve) {
                  var _checkReady = function checkReady() {
                    if (iframeDoc.readyState === 'complete') {
                      resolve();
                    } else {
                      setTimeout(_checkReady, 100);
                    }
                  };
                  _checkReady();
                });
              case 9:
                _context2.next = 11;
                return new Promise(function (resolve) {
                  return setTimeout(resolve, 3000);
                });
              case 11:
                // Get complete document content including DOCTYPE
                html = ''; // Add DOCTYPE if present
                if (iframeDoc.doctype) {
                  html += "<!DOCTYPE ".concat(iframeDoc.doctype.name);
                  if (iframeDoc.doctype.publicId) {
                    html += " PUBLIC \"".concat(iframeDoc.doctype.publicId, "\"");
                  }
                  if (iframeDoc.doctype.systemId) {
                    html += " \"".concat(iframeDoc.doctype.systemId, "\"");
                  }
                  html += '>\n';
                } else {
                  // Fallback DOCTYPE
                  html += '<!DOCTYPE html>\n';
                }

                // Add the complete HTML element
                html += iframeDoc.documentElement.outerHTML;

                // We don't collect CSS here anymore since we'll process styles during DOM tree processing
                return _context2.abrupt("return", {
                  html: html,
                  css: '',
                  // CSS will be processed later through computed styles
                  document: iframeDoc
                });
              case 17:
                _context2.prev = 17;
                _context2.t0 = _context2["catch"](0);
                if (this.isDebugMode) {
                  console.warn('Error accessing Experience Builder iframe content:', _context2.t0.message);
                }
                return _context2.abrupt("return", {
                  html: '',
                  css: '',
                  document: null
                });
              case 21:
              case "end":
                return _context2.stop();
            }
          }, _callee2, this, [[0, 17]]);
        }));
        function getContentFromIframe() {
          return _getContentFromIframe.apply(this, arguments);
        }
        return getContentFromIframe;
      }()
      /**
       * Generates basic HTML from layout data as fallback
       * @param {Object} layout - Redux layout state
       * @returns {string}
       */
      )
    }, {
      key: "generateHtmlFromLayout",
      value: function generateHtmlFromLayout(layout) {
        if (this.isDebugMode) {
          console.warn('Using layout data as fallback - this may produce limited results');
        }
        return "<!DOCTYPE html>\n<html>\n  <head>\n    <title>Drupal Experience Builder</title>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n  </head>\n  <body>\n    <div class=\"layout-container\">\n      ".concat(JSON.stringify(layout, ['title', 'content', 'metadata'], 2), "\n    </div>\n  </body>\n</html>");
      }

      /**
       * Removes extension elements from HTML (simplified without monsido logic)
       * @param {HTMLElement} html - HTML element to clean
       * @returns {HTMLElement} - Cleaned HTML element
       */
    }, {
      key: "removeExtensionElements",
      value: function removeExtensionElements(html) {
        var htmlClone = html.cloneNode(true);

        // Remove any remaining disallowed tag elements
        this.disallowedTagNames.forEach(function (tagName) {
          var elements = htmlClone.querySelectorAll(tagName);
          if (elements) {
            elements.forEach(function (element) {
              element.remove();
            });
          }
        });
        return htmlClone;
      }

      /**
       * Gets viewport size from the given HTML element and document
       * @param {HTMLElement} html - The HTML element to get viewport size from
       * @param {Document} targetDocument - The document to get viewport from
       * @returns {{width: number, height: number}}
       */
    }, {
      key: "getViewPortSize",
      value: function getViewPortSize(html) {
        var targetDocument = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : document;
        try {
          var _win$visualViewport, _win$visualViewport2;
          var win = targetDocument.defaultView || window;
          var viewportWidth = ((_win$visualViewport = win.visualViewport) === null || _win$visualViewport === void 0 ? void 0 : _win$visualViewport.width) || win.innerWidth || html.clientWidth || 1024;
          var viewportHeight = ((_win$visualViewport2 = win.visualViewport) === null || _win$visualViewport2 === void 0 ? void 0 : _win$visualViewport2.height) || win.innerHeight || html.clientHeight || 768;
          return {
            width: viewportWidth,
            height: viewportHeight
          };
        } catch (error) {
          if (this.isDebugMode) {
            console.warn('Error getting viewport size:', error);
          }
          return {
            width: 1024,
            height: 768
          };
        }
      }

      /**
       * Cleans up text content by removing excessive whitespace
       * @param {string} text - The text content to clean
       * @returns {string}
       */
    }, {
      key: "cleanUpText",
      value: function cleanUpText(text) {
        try {
          return text.replaceAll(/ +/g, ' ');
        } catch (error) {
          if (this.isDebugMode) {
            console.warn('Error cleaning up text:', error);
          }
          return text;
        }
      }

      /**
       * Sets default computed styles for the document element
       * @param {Document} targetDocument - The document to get default styles from
       */
    }, {
      key: "setDefaultComputedStyles",
      value: function setDefaultComputedStyles() {
        var targetDocument = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : document;
        try {
          var documentElement = targetDocument.documentElement;
          var win = targetDocument.defaultView;
          if (!win) {
            if (this.isDebugMode) {
              console.warn('No window context available for targetDocument');
            }
            // Fallback to main window
            this.defaultStyles = this.getStylesAsRecord(documentElement, document);
          } else {
            this.defaultStyles = this.getStylesAsRecord(documentElement, targetDocument);
          }
          if (Object.keys(this.defaultStyles).length === 0) {
            if (this.isDebugMode) {
              console.warn('No default styles collected, this may cause issues');
            }
          }
          var defaultStylesString = this.collectStyles(this.defaultStyles);
          var defaultCssRule = "".concat(defaultStylesString);
          this.css.push(defaultCssRule);
        } catch (error) {
          if (this.isDebugMode) {
            console.error('Error setting default computed styles:', error);
          }
        }
      }

      /**
       * Processes the DOM tree recursively
       * @param {HTMLElement | ShadowRoot} el - Element to process
       * @param {Document} targetDocument - The document to get styles from
       * @returns {Promise<Object>} - Tree structure
       */
    }, {
      key: "processTree",
      value: (function () {
        var _processTree = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee5(el) {
          var _this = this;
          var targetDocument,
            _args5 = arguments;
          return _regeneratorRuntime().wrap(function _callee5$(_context5) {
            while (1) switch (_context5.prev = _context5.next) {
              case 0:
                targetDocument = _args5.length > 1 && _args5[1] !== undefined ? _args5[1] : document;
                return _context5.abrupt("return", new Promise(/*#__PURE__*/function () {
                  var _ref = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee4(resolve) {
                    return _regeneratorRuntime().wrap(function _callee4$(_context4) {
                      while (1) switch (_context4.prev = _context4.next) {
                        case 0:
                          setTimeout(/*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
                            var data, shadowRoot, nodes, lastIndex, i, node, tagName, child, textContent;
                            return _regeneratorRuntime().wrap(function _callee3$(_context3) {
                              while (1) switch (_context3.prev = _context3.next) {
                                case 0:
                                  data = {};
                                  if (!(el.nodeType !== 11)) {
                                    _context3.next = 10;
                                    break;
                                  }
                                  // not a shadowRoot
                                  data.tn = el.tagName.toUpperCase();
                                  data.ci = _this.processStyles(el, targetDocument);
                                  data.a = _this.getAttributesList(el);

                                  // Handle shadow root if present
                                  shadowRoot = el.shadowRoot;
                                  if (!shadowRoot) {
                                    _context3.next = 10;
                                    break;
                                  }
                                  _context3.next = 9;
                                  return _this.processTree(shadowRoot, targetDocument);
                                case 9:
                                  data.sr = _context3.sent;
                                case 10:
                                  data.c = [];
                                  nodes = Array.from(el.childNodes);
                                  lastIndex = nodes.length - 1;
                                  if (!(!nodes.length && !data.c.length)) {
                                    _context3.next = 18;
                                    break;
                                  }
                                  delete data.c;
                                  resolve(data);
                                  _context3.next = 37;
                                  break;
                                case 18:
                                  i = 0;
                                case 19:
                                  if (!(i < nodes.length)) {
                                    _context3.next = 37;
                                    break;
                                  }
                                  node = nodes[i];
                                  if (!(node.nodeType === 1)) {
                                    _context3.next = 32;
                                    break;
                                  }
                                  // Element node
                                  tagName = node.tagName.toUpperCase();
                                  if (!_this.disallowedTagNames.includes(tagName)) {
                                    _context3.next = 26;
                                    break;
                                  }
                                  _context3.next = 30;
                                  break;
                                case 26:
                                  _context3.next = 28;
                                  return _this.processTree(node, targetDocument);
                                case 28:
                                  child = _context3.sent;
                                  data.c.push(child);
                                case 30:
                                  _context3.next = 33;
                                  break;
                                case 32:
                                  if (node.nodeType === 3) {
                                    // Text node
                                    textContent = _this.cleanUpText(node.textContent || '');
                                    if (textContent.trim()) {
                                      data.c.push({
                                        t: textContent
                                      });
                                    }
                                  }
                                case 33:
                                  if (lastIndex === i) {
                                    if (data.c && !data.c.length) {
                                      delete data.c;
                                    }
                                    resolve(data);
                                  }
                                case 34:
                                  i += 1;
                                  _context3.next = 19;
                                  break;
                                case 37:
                                case "end":
                                  return _context3.stop();
                              }
                            }, _callee3);
                          })), 0);
                        case 1:
                        case "end":
                          return _context4.stop();
                      }
                    }, _callee4);
                  }));
                  return function (_x3) {
                    return _ref.apply(this, arguments);
                  };
                }()));
              case 2:
              case "end":
                return _context5.stop();
            }
          }, _callee5);
        }));
        function processTree(_x2) {
          return _processTree.apply(this, arguments);
        }
        return processTree;
      }()
      /**
       * Processes styles for an element and returns CSS ID
       * @param {HTMLElement} el - Element to process
       * @param {Document} targetDocument - The document to get styles from
       * @returns {number|undefined} - CSS ID
       */
      )
    }, {
      key: "processStyles",
      value: function processStyles(el, targetDocument) {
        if (this.isDebugMode) {
          console.log('Processing styles for element:', el.tagName, el);
        }
        var _this$collectUniqueSt = this.collectUniqueStyles(el, targetDocument),
          styles = _this$collectUniqueSt.styles,
          sameId = _this$collectUniqueSt.sameId;
        if (this.isDebugMode) {
          console.log('Collected styles:', styles, 'Same ID:', sameId);
        }

        // No unique styles means the style is identical to the default
        var csId = 0;
        if (styles) {
          if (sameId === undefined) {
            csId = this.css.length;
            this.css.push(styles);
            if (this.isDebugMode) {
              console.log('Added new CSS rule at index:', csId, styles);
            }
          } else {
            csId = sameId;
            if (this.isDebugMode) {
              console.log('Reusing existing CSS rule at index:', csId);
            }
          }
        } else if (this.isDebugMode) {
          console.log('No styles collected for element:', el.tagName);
        }
        return csId;
      }

      /**
       * Gets all computed styles as a record object
       * @param {HTMLElement} el - Element to get styles from
       * @param {Document} targetDocument - The document to get styles from
       * @returns {Object} - Styles record
       */
    }, {
      key: "getStylesAsRecord",
      value: function getStylesAsRecord(el) {
        var targetDocument = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : document;
        try {
          var win = targetDocument.defaultView || window;
          var styleObj = win.getComputedStyle(el);
          if (!styleObj) {
            if (this.isDebugMode) {
              console.warn('getComputedStyle returned null for element:', el.tagName);
            }
            return {};
          }
          var result = {};
          for (var i = styleObj.length; i--;) {
            var nameString = styleObj[i];
            var value = styleObj.getPropertyValue(nameString);
            if (value) {
              result[nameString] = "".concat(value, ";");
            }
          }
          if (this.isDebugMode && Object.keys(result).length === 0) {
            console.warn('No computed styles found for element:', el.tagName, el);
          }
          return result;
        } catch (error) {
          if (this.isDebugMode) {
            console.error('Error getting computed styles:', error, 'for element:', el.tagName);
          }
          return {};
        }
      }

      /**
       * Collects unique styles for an element
       * @param {HTMLElement} el - Element to collect styles from
       * @param {Document} targetDocument - The document to get styles from
       * @returns {Object} - Unique styles and same ID if found
       */
    }, {
      key: "collectUniqueStyles",
      value: function collectUniqueStyles(el, targetDocument) {
        var styles = this.collectStyles(this.getStylesAsRecord(el, targetDocument), this.defaultStyles);
        var sameId;
        if (styles.length) {
          var index = this.css.indexOf(styles);
          if (index !== -1) {
            sameId = index;
          }
        }
        return {
          styles: styles,
          sameId: sameId
        };
      }

      /**
       * Collects styles as a string, optionally removing default styles
       * @param {Object} stylesObj - Styles object
       * @param {Object} [defaultStyles] - Default styles to remove
       * @returns {string} - Collected styles string (CSS properties without selector)
       */
    }, {
      key: "collectStyles",
      value: function collectStyles(stylesObj, defaultStyles) {
        var _this2 = this;
        if (defaultStyles) {
          stylesObj = this.removeDefaultStyles(stylesObj, defaultStyles);
        }
        return Object.entries(stylesObj).map(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            key = _ref4[0],
            value = _ref4[1];
          return "".concat(_this2.escapeQuotation(key), ": ").concat(_this2.escapeQuotation(value));
        }).join(' ');
      }

      /**
       * Removes default styles from styles object
       * @param {Object} stylesObj - Styles object
       * @param {Object} defaultObj - Default styles object
       * @returns {Object} - Filtered styles object
       */
    }, {
      key: "removeDefaultStyles",
      value: function removeDefaultStyles(stylesObj, defaultObj) {
        var result = {};
        for (var _i = 0, _Object$keys = Object.keys(stylesObj); _i < _Object$keys.length; _i++) {
          var k = _Object$keys[_i];
          if (stylesObj[k] !== defaultObj[k]) {
            result[k] = stylesObj[k];
          }
        }
        return result;
      }

      /**
       * Gets attributes list for an element
       * @param {HTMLElement} el - Element
       * @returns {Array} - Array of attribute pairs
       */
    }, {
      key: "getAttributesList",
      value: function getAttributesList(el) {
        var attrNames = Array.from(el.attributes);
        var result = attrNames.map(function (n) {
          return [n.nodeName, n.nodeValue || ''];
        });
        return result;
      }

      /**
       * Escapes quotation marks in text
       * @param {string} text - Text to escape
       * @returns {string} - Escaped text
       */
    }, {
      key: "escapeQuotation",
      value: function escapeQuotation(text) {
        return text.replaceAll(/"/g, '\\"');
      }
    }]);
  }();

  var ScanService = /*#__PURE__*/function () {
    function ScanService(apiService) {
      var isDebugMode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      _classCallCheck(this, ScanService);
      this.apiService = apiService;
      this.isDebugMode = isDebugMode;
      this.htmlCssCollector = new HtmlCssCollector(isDebugMode);
    }

    /**
     * Starts a quick scan and returns scan information
     * @param {Object} layout - Redux layout state
     * @param {Function} setScanProgress - Progress update function
     * @param {boolean} isRetry - Whether this is a retry attempt
     * @returns {Promise<{scanId: string, progressInterval: number}>}
     */
    return _createClass(ScanService, [{
      key: "startQuickScan",
      value: (function () {
        var _startQuickScan = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(layout, setScanProgress) {
          var accessibilityGuideline,
            pageData,
            progressInterval,
            requestBody,
            response,
            data,
            scanId,
            errorData,
            _args = arguments;
          return _regeneratorRuntime().wrap(function _callee$(_context) {
            while (1) switch (_context.prev = _context.next) {
              case 0:
                accessibilityGuideline = _args.length > 3 && _args[3] !== undefined ? _args[3] : 'WCAG21-AA';
                _context.prev = 2;
                _context.next = 5;
                return this.htmlCssCollector.collectPageContent(layout);
              case 5:
                pageData = _context.sent;
                // Start progress animation
                progressInterval = this.startProgressAnimation(setScanProgress); // Prepare API request data using the collected page data
                _context.next = 9;
                return this.prepareRequestBody(pageData, accessibilityGuideline);
              case 9:
                requestBody = _context.sent;
                _context.next = 12;
                return this.apiService.startQuickScan(requestBody);
              case 12:
                response = _context.sent;
                if (!response.ok) {
                  _context.next = 21;
                  break;
                }
                _context.next = 16;
                return response.json();
              case 16:
                data = _context.sent;
                scanId = data.id || '';
                return _context.abrupt("return", {
                  scanId: scanId,
                  progressInterval: progressInterval
                });
              case 21:
                _context.next = 23;
                return this.handleApiError(response);
              case 23:
                errorData = _context.sent;
                throw new Error(errorData.message);
              case 25:
                _context.next = 31;
                break;
              case 27:
                _context.prev = 27;
                _context.t0 = _context["catch"](2);
                debugError(this.isDebugMode, 'Error starting quick scan:', _context.t0);
                throw _context.t0;
              case 31:
              case "end":
                return _context.stop();
            }
          }, _callee, this, [[2, 27]]);
        }));
        function startQuickScan(_x, _x2) {
          return _startQuickScan.apply(this, arguments);
        }
        return startQuickScan;
      }()
      /**
       * Starts the progress animation
       * @param {Function} setScanProgress - Progress update function
       * @returns {number} - Interval ID
       */
      )
    }, {
      key: "startProgressAnimation",
      value: function startProgressAnimation(setScanProgress) {
        var progress = 0;
        return setInterval(function () {
          // Initial fast progress up to 60%
          if (progress < 60) {
            progress += 2;
          }
          // Slow down between 60-80%
          else if (progress < 80) {
            progress += 0.5;
          }
          // Very slow progress after 80%
          else if (progress < 90) {
            progress += 0.1;
          }
          // Add slight animation at the end
          else if (progress < 94) {
            var fluctuation = Math.random() * 0.3 - 0.1;
            progress += fluctuation;
            progress = Math.min(Math.max(progress, 90), 94);
          }
          setScanProgress(progress);
        }, 500);
      }

      /**
       * Prepares the request body for the API call
       * @param {Object} pageData - Page data from HtmlCssCollector {dom_tree, css, html, version, viewport}
       * @param {string} accessibilityGuideline - Accessibility guideline to use
       * @returns {Object} - Request body
       */
    }, {
      key: "prepareRequestBody",
      value: (function () {
        var _prepareRequestBody = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2(pageData, accessibilityGuideline) {
          var encodedPageData;
          return _regeneratorRuntime().wrap(function _callee2$(_context2) {
            while (1) switch (_context2.prev = _context2.next) {
              case 0:
                // Process HTML data according to Optimize API requirements
                encodedPageData = {
                  dom_tree: pageData.dom_tree,
                  css: pageData.css,
                  // pageData.css is already an array
                  version: pageData.version,
                  viewport: pageData.viewport
                };
                return _context2.abrupt("return", {
                  encoded_page: encodedPageData,
                  html: pageData.html,
                  css: pageData.css.join('\n'),
                  // Convert array to string for the html field
                  accessibility: accessibilityGuideline
                });
              case 2:
              case "end":
                return _context2.stop();
            }
          }, _callee2);
        }));
        function prepareRequestBody(_x3, _x4) {
          return _prepareRequestBody.apply(this, arguments);
        }
        return prepareRequestBody;
      }()
      /**
       * Handles API error responses
       * @param {Response} response - API response
       * @returns {Promise<{message: string}>} - Error data
       */
      )
    }, {
      key: "handleApiError",
      value: (function () {
        var _handleApiError = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee3(response) {
          var errorData, errorMessage, textResponse;
          return _regeneratorRuntime().wrap(function _callee3$(_context3) {
            while (1) switch (_context3.prev = _context3.next) {
              case 0:
                _context3.prev = 0;
                _context3.next = 3;
                return response.json();
              case 3:
                errorData = _context3.sent;
                debugError(this.isDebugMode, 'Optimize API Error (JSON):', errorData);

                // Special handling for token error
                if (response.status === 401 || errorData.message && errorData.message.includes('token') || errorData.error && errorData.error.includes('token')) {
                  errorMessage = 'Authentication failed: A valid API token must be provided';
                } else {
                  errorMessage = errorData.failure_reason || errorData.message || errorData.error_message || "Failed to start scan: ".concat(response.status, " ").concat(response.statusText);
                }
                _context3.next = 16;
                break;
              case 8:
                _context3.prev = 8;
                _context3.t0 = _context3["catch"](0);
                _context3.next = 12;
                return response.text();
              case 12:
                textResponse = _context3.sent;
                debugError(this.isDebugMode, 'Optimize API Error (Text):', textResponse);
                if (textResponse.includes('token')) {
                  errorMessage = 'Authentication failed: A valid API token must be provided';
                } else {
                  errorMessage = "Failed to start scan: ".concat(response.status, " ").concat(response.statusText);
                }
                errorData = {
                  error: textResponse
                };
              case 16:
                return _context3.abrupt("return", _objectSpread2(_objectSpread2({}, errorData), {}, {
                  message: errorMessage
                }));
              case 17:
              case "end":
                return _context3.stop();
            }
          }, _callee3, this, [[0, 8]]);
        }));
        function handleApiError(_x5) {
          return _handleApiError.apply(this, arguments);
        }
        return handleApiError;
      }())
    }]);
  }();

  var PollingService = /*#__PURE__*/function () {
    function PollingService(apiService) {
      var isDebugMode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      _classCallCheck(this, PollingService);
      this.apiService = apiService;
      this.isDebugMode = isDebugMode;
      this.maxRetries = 10; // Maximum number of polling attempts
      this.maxFailureRetries = 2; // Maximum number of retries for failed scans
      this.pollingInterval = 2000; // 2 seconds between polls
    }

    /**
     * Polls scan results until completion or failure
     * @param {string} scanId - The scan ID to poll
     * @param {number} progressInterval - Progress animation interval ID
     * @param {Function} setScanProgress - Progress update callback
     * @param {Function} setScanResults - Results update callback
     * @param {Function} setCurrentView - View update callback
     * @param {number} retryCount - Current retry attempt (internal use)
     * @param {number} failureRetryCount - Current failure retry attempt (internal use)
     */
    return _createClass(PollingService, [{
      key: "pollScanResults",
      value: (function () {
        var _pollScanResults = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(scanId, progressInterval, setScanProgress, setScanResults, setCurrentView) {
          var retryCount,
            failureRetryCount,
            data,
            status,
            _args = arguments;
          return _regeneratorRuntime().wrap(function _callee$(_context) {
            while (1) switch (_context.prev = _context.next) {
              case 0:
                retryCount = _args.length > 5 && _args[5] !== undefined ? _args[5] : 0;
                failureRetryCount = _args.length > 6 && _args[6] !== undefined ? _args[6] : 0;
                _context.prev = 2;
                if (scanId) {
                  _context.next = 5;
                  break;
                }
                throw new Error('Invalid scan ID');
              case 5:
                // Check if we've exceeded max retries
                if (retryCount >= this.maxRetries) {
                  debugError(this.isDebugMode, "Polling timeout: Maximum retries (".concat(this.maxRetries, ") exceeded after ").concat(this.maxRetries * this.pollingInterval / 1000, " seconds"));
                }

                // Check scan status - apiService.checkScanStatus returns the data directly, not a Response object
                _context.next = 8;
                return this.apiService.checkScanStatus(scanId, this.isDebugMode);
              case 8:
                data = _context.sent;
                if (data) {
                  status = data.status;
                  this.handleScanStatus(status, data, scanId, progressInterval, setScanProgress, setScanResults, setCurrentView, retryCount, failureRetryCount);
                } else {
                  // Handle case where checkScanStatus returns null - retry instead of failing immediately
                  this.retryPolling(scanId, progressInterval, setScanProgress, setScanResults, setCurrentView, retryCount, failureRetryCount, 'No data received from scan status check');
                }
                _context.next = 15;
                break;
              case 12:
                _context.prev = 12;
                _context.t0 = _context["catch"](2);
                // Check if this is a network/temporary error that should be retried
                if (this.shouldRetryError(_context.t0) && retryCount < this.maxRetries) {
                  this.retryPolling(scanId, progressInterval, setScanProgress, setScanResults, setCurrentView, retryCount, failureRetryCount, _context.t0.message);
                } else {
                  this.handlePollingException(_context.t0, progressInterval, setScanProgress, setScanResults, setCurrentView);
                }
              case 15:
              case "end":
                return _context.stop();
            }
          }, _callee, this, [[2, 12]]);
        }));
        function pollScanResults(_x, _x2, _x3, _x4, _x5) {
          return _pollScanResults.apply(this, arguments);
        }
        return pollScanResults;
      }()
      /**
       * Handles different scan status values - continues polling until 'completed' status
       * @param {string} status - Current scan status
       * @param {Object} data - Full response data
       * @param {string} scanId - Scan ID
       * @param {number} progressInterval - Progress animation interval
       * @param {Function} setScanProgress - Progress update callback
       * @param {Function} setScanResults - Results update callback
       * @param {Function} setCurrentView - View update callback
       * @param {number} retryCount - Current retry count
       * @param {number} failureRetryCount - Current failure retry count
       */
      )
    }, {
      key: "handleScanStatus",
      value: function handleScanStatus(status, data, scanId, progressInterval, setScanProgress, setScanResults, setCurrentView) {
        var _this = this;
        var retryCount = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
        var failureRetryCount = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
        // Only 'completed' status stops polling - all others continue
        var completedStatuses = ['completed'];
        var explicitFailureStatuses = ['failed', 'error', 'cancelled', 'timeout'];

        // Continue polling for scanning, processing, and any other status except completed/failed
        var shouldContinuePolling = !completedStatuses.includes(status) && !explicitFailureStatuses.includes(status) && !data.error;
        if (shouldContinuePolling) {
          // Continue polling for any non-completed status
          setTimeout(function () {
            _this.pollScanResults(scanId, progressInterval, setScanProgress, setScanResults, setCurrentView, retryCount + 1, failureRetryCount);
          }, this.pollingInterval);
        } else if (completedStatuses.includes(status)) {
          // Only stop when we get 'completed' status
          this.handleScanCompletion(data, progressInterval, setScanProgress, setScanResults, setCurrentView);
        } else {
          // Handle explicit failures with retry logic
          if (status === 'failed' && failureRetryCount < this.maxFailureRetries) {
            if (this.isDebugMode) {
              debugError(this.isDebugMode, "Scan failed (attempt ".concat(failureRetryCount + 1, "/").concat(this.maxFailureRetries, "), retrying in ").concat(this.pollingInterval, "ms..."));
            }

            // Retry the failed scan
            setTimeout(function () {
              _this.pollScanResults(scanId, progressInterval, setScanProgress, setScanResults, setCurrentView, 0, failureRetryCount + 1);
            }, this.pollingInterval);
          } else {
            // Final failure after all retries or non-retryable failure
            if (this.isDebugMode) {
              if (status === 'failed' && failureRetryCount >= this.maxFailureRetries) {
                debugError(this.isDebugMode, "Scan failed permanently after ".concat(failureRetryCount, " retries"));
              } else {
                debugError(this.isDebugMode, "Scan failed with status: ".concat(status));
              }
            }
            this.handleScanFailure(data, progressInterval, setScanProgress, setScanResults, setCurrentView);
          }
        }
      }

      /**
       * Handles successful scan completion
       */
    }, {
      key: "handleScanCompletion",
      value: function handleScanCompletion(data, progressInterval, setScanProgress, setScanResults, setCurrentView) {
        clearInterval(progressInterval);
        setScanProgress(100);
        // Use process_result if available (contains processed data from PHP), 
        // otherwise fall back to scan_result or raw data
        var resultData = data.process_result || data.scan_result || data;
        setScanResults(resultData);
        setTimeout(function () {
          setCurrentView('results');
        }, 500);
      }

      /**
       * Handles scan failure
       */
    }, {
      key: "handleScanFailure",
      value: function handleScanFailure(data, progressInterval, setScanProgress, setScanResults, setCurrentView) {
        clearInterval(progressInterval);
        setScanProgress(100);
        setScanResults({
          status: 'failed',
          error: true,
          message: data.failure_reason || data.message || data.error_message || 'Scan failed'
        });
        setTimeout(function () {
          setCurrentView('results');
        }, 500);
      }

      /**
       * Handles unknown scan status - now removed since we continue polling for any non-completed status
       */
    }, {
      key: "handleUnknownStatus",
      value: function handleUnknownStatus(status, data, scanId, progressInterval, setScanProgress, setScanResults, setCurrentView) {
        var _this2 = this;
        var retryCount = arguments.length > 7 && arguments[7] !== undefined ? arguments[7] : 0;
        var failureRetryCount = arguments.length > 8 && arguments[8] !== undefined ? arguments[8] : 0;
        // Continue polling for unknown statuses unless we've exceeded retry limit
        if (retryCount < this.maxRetries) {
          if (this.isDebugMode) {
            debugError(this.isDebugMode, "Unknown status \"".concat(status, "\", continuing to poll (attempt ").concat(retryCount + 1, "/").concat(this.maxRetries, ")..."));
          }
          setTimeout(function () {
            _this2.pollScanResults(scanId, progressInterval, setScanProgress, setScanResults, setCurrentView, retryCount + 1, failureRetryCount);
          }, this.pollingInterval);
        } else {
          // Stop polling and show results with warning after max retries
          if (this.isDebugMode) {
            debugError(this.isDebugMode, "Unknown status \"".concat(status, "\", stopping polling after ").concat(retryCount, " attempts"));
          }
          clearInterval(progressInterval);
          setScanProgress(100);
          var results = data.scan_result ? data.scan_result : _objectSpread2(_objectSpread2({}, data), {}, {
            warning: "Scan timed out with status: ".concat(status)
          });
          setScanResults(results);
          setTimeout(function () {
            setCurrentView('results');
          }, 500);
        }
      }

      /**
       * Retry polling with exponential backoff
       */
    }, {
      key: "retryPolling",
      value: function retryPolling(scanId, progressInterval, setScanProgress, setScanResults, setCurrentView, retryCount, failureRetryCount, reason) {
        var _this3 = this;
        var backoffDelay = Math.min(this.pollingInterval * Math.pow(1.2, Math.min(retryCount, 5)), 5000); // Max 5 seconds

        setTimeout(function () {
          _this3.pollScanResults(scanId, progressInterval, setScanProgress, setScanResults, setCurrentView, retryCount + 1, failureRetryCount);
        }, backoffDelay);
      }

      /**
       * Determine if an error should trigger a retry
       */
    }, {
      key: "shouldRetryError",
      value: function shouldRetryError(error) {
        // Retry on network errors, timeouts, and server errors
        var retryableErrors = ['NetworkError', 'TimeoutError', 'fetch', '5',
        // 5xx server errors
        'timeout', 'network', 'connection', 'ECONNRESET', 'ENOTFOUND'];
        var errorString = (error.message || error.toString()).toLowerCase();
        return retryableErrors.some(function (keyword) {
          return errorString.includes(keyword);
        });
      }

      /**
       * Handles polling exceptions
       */
    }, {
      key: "handlePollingException",
      value: function handlePollingException(error, progressInterval, setScanProgress, setScanResults, setCurrentView) {
        debugError(this.isDebugMode, 'Error polling scan results:', error);
        clearInterval(progressInterval);
        setScanProgress(100);

        // Handle ApiError instances with more specific error information
        var errorMessage = 'Failed to check scan status';
        var errorDetails = {};
        if (error.name === 'ApiError') {
          errorMessage = error.message;
          errorDetails = error.getErrorDetails ? error.getErrorDetails() : {};
        } else {
          errorMessage = error.message || errorMessage;
        }
        setScanResults(_objectSpread2({
          status: 'failed',
          error: true,
          message: errorMessage
        }, errorDetails));
        setTimeout(function () {
          setCurrentView('results');
        }, 500);
      }
    }]);
  }();

  // Module-level variables that persist across component mounts/unmounts
  var hasSettingsBeenFetched = false;
  var cachedSettings = null;
  var fetchPromise = null;
  var useConceptProverLogic = function useConceptProverLogic() {
    var state = useConceptProverState();
    var apiService = useApiService(state.csrfToken);

    // Initialize services
    var scanService = new ScanService(apiService, state.isDebugMode);
    var pollingService = new PollingService(apiService, state.isDebugMode);

    // Initialize custom hooks
    var _useFormHandlers = useFormHandlers(state, apiService),
      handleSubmit = _useFormHandlers.handleSubmit;
    var _useUIHandlers = useUIHandlers(state),
      toggleSection = _useUIHandlers.toggleSection,
      showIssuesForLevel = _useUIHandlers.showIssuesForLevel,
      showSeoIssuesForCategory = _useUIHandlers.showSeoIssuesForCategory;

    // Get the layout from the Redux store
    var layout = useSelector(function (state) {
      var _state$layoutModel;
      return state === null || state === void 0 || (_state$layoutModel = state.layoutModel) === null || _state$layoutModel === void 0 || (_state$layoutModel = _state$layoutModel.present) === null || _state$layoutModel === void 0 ? void 0 : _state$layoutModel.layout;
    });

    // Helper function to apply settings to state
    var applySettingsToState = function applySettingsToState(data) {
      state.setCanConfigure(!!data.can_configure);
      state.setCanScan(!!data.can_scan);

      // If user doesn't have permission to scan or configure, don't proceed further
      if (!data.can_scan && !data.can_configure) {
        state.setCurrentView('no-permission');
        return;
      }
      if (data.api_key) {
        state.setApiKey(data.api_key);
        // If we have an API key, show the quick scan view instead of initial
        state.setCurrentView('quick-scan');
      } else {
        // No API key, show initial view
        state.setCurrentView('initial');
      }
      if (data.api_url) {
        state.setApiUrl(data.api_url);
      }
      if (data.accessibility) {
        state.setAccessibilityGuideline(data.accessibility);
      }
      // Set debug mode from settings
      state.setIsDebugMode(!!data.debug_mode);

      // Set CSRF token from settings
      if (data.csrf_token) {
        state.setCsrfToken(data.csrf_token);
      }
    };

    // Fetch existing settings on component mount
    ReactOriginal.useEffect(function () {
      // If we already have cached settings, use them immediately
      if (hasSettingsBeenFetched && cachedSettings) {
        applySettingsToState(cachedSettings);
        state.setIsInitialLoading(false);
        return;
      }

      // If there's already a fetch in progress, wait for it
      if (fetchPromise) {
        fetchPromise.then(function (data) {
          applySettingsToState(data);
        })["catch"](function (error) {
          state.setCurrentView('initial');
        })["finally"](function () {
          state.setIsInitialLoading(false);
        });
        return;
      }

      // Start new fetch
      var fetchSettingsData = /*#__PURE__*/function () {
        var _ref = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
          var data;
          return _regeneratorRuntime().wrap(function _callee$(_context) {
            while (1) switch (_context.prev = _context.next) {
              case 0:
                state.setIsInitialLoading(true);
                _context.prev = 1;
                _context.next = 4;
                return apiService.fetchSettings();
              case 4:
                data = _context.sent;
                // Cache the results
                hasSettingsBeenFetched = true;
                cachedSettings = data;
                fetchPromise = null;
                applySettingsToState(data);
                return _context.abrupt("return", data);
              case 12:
                _context.prev = 12;
                _context.t0 = _context["catch"](1);
                fetchPromise = null;
                state.setCurrentView('initial');
                throw _context.t0;
              case 17:
                _context.prev = 17;
                state.setIsInitialLoading(false);
                return _context.finish(17);
              case 20:
              case "end":
                return _context.stop();
            }
          }, _callee, null, [[1, 12, 17, 20]]);
        }));
        return function fetchSettingsData() {
          return _ref.apply(this, arguments);
        };
      }();

      // Store the promise to prevent duplicate fetches
      fetchPromise = fetchSettingsData();
    }, []);
    var _startQuickScan = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        var isRetry,
          _yield$scanService$st,
          scanId,
          progressInterval,
          _args2 = arguments;
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              isRetry = _args2.length > 0 && _args2[0] !== undefined ? _args2[0] : false;
              if (!(!state.canScan && !state.canConfigure)) {
                _context2.next = 3;
                break;
              }
              return _context2.abrupt("return");
            case 3:
              _context2.prev = 3;
              state.setCurrentView('scanning');
              state.setScanProgress(0);

              // Use the scan service to start the scan
              _context2.next = 8;
              return scanService.startQuickScan(layout, state.setScanProgress, isRetry, state.accessibilityGuideline);
            case 8:
              _yield$scanService$st = _context2.sent;
              scanId = _yield$scanService$st.scanId;
              progressInterval = _yield$scanService$st.progressInterval;
              state.setScanId(scanId);

              // Use the polling service to poll for results
              pollingService.pollScanResults(scanId, progressInterval, state.setScanProgress, state.setScanResults, state.setCurrentView);
              _context2.next = 23;
              break;
            case 15:
              _context2.prev = 15;
              _context2.t0 = _context2["catch"](3);
              debugError(state.isDebugMode, 'Error in startQuickScan:', _context2.t0);

              // Auto-retry once if this isn't already a retry attempt
              if (isRetry) {
                _context2.next = 21;
                break;
              }
              setTimeout(function () {
                return _startQuickScan(true);
              }, 1000);
              return _context2.abrupt("return");
            case 21:
              // Display error in results view after retry attempt failed
              state.setScanResults({
                status: 'failed',
                error: true,
                message: _context2.t0.message || 'Failed to start quick scan'
              });
              setTimeout(function () {
                state.setCurrentView('results');
              }, 500);
            case 23:
            case "end":
              return _context2.stop();
          }
        }, _callee2, null, [[3, 15]]);
      }));
      return function startQuickScan() {
        return _ref2.apply(this, arguments);
      };
    }();
    return _objectSpread2(_objectSpread2({}, state), {}, {
      layout: layout,
      // Handlers
      handleSubmit: handleSubmit,
      startQuickScan: _startQuickScan,
      toggleSection: toggleSection,
      showIssuesForLevel: showIssuesForLevel,
      showSeoIssuesForCategory: showSeoIssuesForCategory
    });
  };

  var jsxRuntime = {exports: {}};

  var reactJsxRuntime_development = {};

  /**
   * @license React
   * react-jsx-runtime.development.js
   *
   * Copyright (c) Facebook, Inc. and its affiliates.
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE file in the root directory of this source tree.
   */

  var hasRequiredReactJsxRuntime_development;

  function requireReactJsxRuntime_development () {
  	if (hasRequiredReactJsxRuntime_development) return reactJsxRuntime_development;
  	hasRequiredReactJsxRuntime_development = 1;

  	{
  	  (function() {

  	var React = ReactOriginal__default["default"];

  	// ATTENTION
  	// When adding new symbols to this file,
  	// Please consider also adding to 'react-devtools-shared/src/backend/ReactSymbols'
  	// The Symbol used to tag the ReactElement-like types.
  	var REACT_ELEMENT_TYPE = Symbol.for('react.element');
  	var REACT_PORTAL_TYPE = Symbol.for('react.portal');
  	var REACT_FRAGMENT_TYPE = Symbol.for('react.fragment');
  	var REACT_STRICT_MODE_TYPE = Symbol.for('react.strict_mode');
  	var REACT_PROFILER_TYPE = Symbol.for('react.profiler');
  	var REACT_PROVIDER_TYPE = Symbol.for('react.provider');
  	var REACT_CONTEXT_TYPE = Symbol.for('react.context');
  	var REACT_FORWARD_REF_TYPE = Symbol.for('react.forward_ref');
  	var REACT_SUSPENSE_TYPE = Symbol.for('react.suspense');
  	var REACT_SUSPENSE_LIST_TYPE = Symbol.for('react.suspense_list');
  	var REACT_MEMO_TYPE = Symbol.for('react.memo');
  	var REACT_LAZY_TYPE = Symbol.for('react.lazy');
  	var REACT_OFFSCREEN_TYPE = Symbol.for('react.offscreen');
  	var MAYBE_ITERATOR_SYMBOL = Symbol.iterator;
  	var FAUX_ITERATOR_SYMBOL = '@@iterator';
  	function getIteratorFn(maybeIterable) {
  	  if (maybeIterable === null || typeof maybeIterable !== 'object') {
  	    return null;
  	  }

  	  var maybeIterator = MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL];

  	  if (typeof maybeIterator === 'function') {
  	    return maybeIterator;
  	  }

  	  return null;
  	}

  	var ReactSharedInternals = React.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED;

  	function error(format) {
  	  {
  	    {
  	      for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
  	        args[_key2 - 1] = arguments[_key2];
  	      }

  	      printWarning('error', format, args);
  	    }
  	  }
  	}

  	function printWarning(level, format, args) {
  	  // When changing this logic, you might want to also
  	  // update consoleWithStackDev.www.js as well.
  	  {
  	    var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;
  	    var stack = ReactDebugCurrentFrame.getStackAddendum();

  	    if (stack !== '') {
  	      format += '%s';
  	      args = args.concat([stack]);
  	    } // eslint-disable-next-line react-internal/safe-string-coercion


  	    var argsWithFormat = args.map(function (item) {
  	      return String(item);
  	    }); // Careful: RN currently depends on this prefix

  	    argsWithFormat.unshift('Warning: ' + format); // We intentionally don't use spread (or .apply) directly because it
  	    // breaks IE9: https://github.com/facebook/react/issues/13610
  	    // eslint-disable-next-line react-internal/no-production-logging

  	    Function.prototype.apply.call(console[level], console, argsWithFormat);
  	  }
  	}

  	// -----------------------------------------------------------------------------

  	var enableScopeAPI = false; // Experimental Create Event Handle API.
  	var enableCacheElement = false;
  	var enableTransitionTracing = false; // No known bugs, but needs performance testing

  	var enableLegacyHidden = false; // Enables unstable_avoidThisFallback feature in Fiber
  	// stuff. Intended to enable React core members to more easily debug scheduling
  	// issues in DEV builds.

  	var enableDebugTracing = false; // Track which Fiber(s) schedule render work.

  	var REACT_MODULE_REFERENCE;

  	{
  	  REACT_MODULE_REFERENCE = Symbol.for('react.module.reference');
  	}

  	function isValidElementType(type) {
  	  if (typeof type === 'string' || typeof type === 'function') {
  	    return true;
  	  } // Note: typeof might be other than 'symbol' or 'number' (e.g. if it's a polyfill).


  	  if (type === REACT_FRAGMENT_TYPE || type === REACT_PROFILER_TYPE || enableDebugTracing  || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || enableLegacyHidden  || type === REACT_OFFSCREEN_TYPE || enableScopeAPI  || enableCacheElement  || enableTransitionTracing ) {
  	    return true;
  	  }

  	  if (typeof type === 'object' && type !== null) {
  	    if (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || // This needs to include all possible module reference object
  	    // types supported by any Flight configuration anywhere since
  	    // we don't know which Flight build this will end up being used
  	    // with.
  	    type.$$typeof === REACT_MODULE_REFERENCE || type.getModuleId !== undefined) {
  	      return true;
  	    }
  	  }

  	  return false;
  	}

  	function getWrappedName(outerType, innerType, wrapperName) {
  	  var displayName = outerType.displayName;

  	  if (displayName) {
  	    return displayName;
  	  }

  	  var functionName = innerType.displayName || innerType.name || '';
  	  return functionName !== '' ? wrapperName + "(" + functionName + ")" : wrapperName;
  	} // Keep in sync with react-reconciler/getComponentNameFromFiber


  	function getContextName(type) {
  	  return type.displayName || 'Context';
  	} // Note that the reconciler package should generally prefer to use getComponentNameFromFiber() instead.


  	function getComponentNameFromType(type) {
  	  if (type == null) {
  	    // Host root, text node or just invalid type.
  	    return null;
  	  }

  	  {
  	    if (typeof type.tag === 'number') {
  	      error('Received an unexpected object in getComponentNameFromType(). ' + 'This is likely a bug in React. Please file an issue.');
  	    }
  	  }

  	  if (typeof type === 'function') {
  	    return type.displayName || type.name || null;
  	  }

  	  if (typeof type === 'string') {
  	    return type;
  	  }

  	  switch (type) {
  	    case REACT_FRAGMENT_TYPE:
  	      return 'Fragment';

  	    case REACT_PORTAL_TYPE:
  	      return 'Portal';

  	    case REACT_PROFILER_TYPE:
  	      return 'Profiler';

  	    case REACT_STRICT_MODE_TYPE:
  	      return 'StrictMode';

  	    case REACT_SUSPENSE_TYPE:
  	      return 'Suspense';

  	    case REACT_SUSPENSE_LIST_TYPE:
  	      return 'SuspenseList';

  	  }

  	  if (typeof type === 'object') {
  	    switch (type.$$typeof) {
  	      case REACT_CONTEXT_TYPE:
  	        var context = type;
  	        return getContextName(context) + '.Consumer';

  	      case REACT_PROVIDER_TYPE:
  	        var provider = type;
  	        return getContextName(provider._context) + '.Provider';

  	      case REACT_FORWARD_REF_TYPE:
  	        return getWrappedName(type, type.render, 'ForwardRef');

  	      case REACT_MEMO_TYPE:
  	        var outerName = type.displayName || null;

  	        if (outerName !== null) {
  	          return outerName;
  	        }

  	        return getComponentNameFromType(type.type) || 'Memo';

  	      case REACT_LAZY_TYPE:
  	        {
  	          var lazyComponent = type;
  	          var payload = lazyComponent._payload;
  	          var init = lazyComponent._init;

  	          try {
  	            return getComponentNameFromType(init(payload));
  	          } catch (x) {
  	            return null;
  	          }
  	        }

  	      // eslint-disable-next-line no-fallthrough
  	    }
  	  }

  	  return null;
  	}

  	var assign = Object.assign;

  	// Helpers to patch console.logs to avoid logging during side-effect free
  	// replaying on render function. This currently only patches the object
  	// lazily which won't cover if the log function was extracted eagerly.
  	// We could also eagerly patch the method.
  	var disabledDepth = 0;
  	var prevLog;
  	var prevInfo;
  	var prevWarn;
  	var prevError;
  	var prevGroup;
  	var prevGroupCollapsed;
  	var prevGroupEnd;

  	function disabledLog() {}

  	disabledLog.__reactDisabledLog = true;
  	function disableLogs() {
  	  {
  	    if (disabledDepth === 0) {
  	      /* eslint-disable react-internal/no-production-logging */
  	      prevLog = console.log;
  	      prevInfo = console.info;
  	      prevWarn = console.warn;
  	      prevError = console.error;
  	      prevGroup = console.group;
  	      prevGroupCollapsed = console.groupCollapsed;
  	      prevGroupEnd = console.groupEnd; // https://github.com/facebook/react/issues/19099

  	      var props = {
  	        configurable: true,
  	        enumerable: true,
  	        value: disabledLog,
  	        writable: true
  	      }; // $FlowFixMe Flow thinks console is immutable.

  	      Object.defineProperties(console, {
  	        info: props,
  	        log: props,
  	        warn: props,
  	        error: props,
  	        group: props,
  	        groupCollapsed: props,
  	        groupEnd: props
  	      });
  	      /* eslint-enable react-internal/no-production-logging */
  	    }

  	    disabledDepth++;
  	  }
  	}
  	function reenableLogs() {
  	  {
  	    disabledDepth--;

  	    if (disabledDepth === 0) {
  	      /* eslint-disable react-internal/no-production-logging */
  	      var props = {
  	        configurable: true,
  	        enumerable: true,
  	        writable: true
  	      }; // $FlowFixMe Flow thinks console is immutable.

  	      Object.defineProperties(console, {
  	        log: assign({}, props, {
  	          value: prevLog
  	        }),
  	        info: assign({}, props, {
  	          value: prevInfo
  	        }),
  	        warn: assign({}, props, {
  	          value: prevWarn
  	        }),
  	        error: assign({}, props, {
  	          value: prevError
  	        }),
  	        group: assign({}, props, {
  	          value: prevGroup
  	        }),
  	        groupCollapsed: assign({}, props, {
  	          value: prevGroupCollapsed
  	        }),
  	        groupEnd: assign({}, props, {
  	          value: prevGroupEnd
  	        })
  	      });
  	      /* eslint-enable react-internal/no-production-logging */
  	    }

  	    if (disabledDepth < 0) {
  	      error('disabledDepth fell below zero. ' + 'This is a bug in React. Please file an issue.');
  	    }
  	  }
  	}

  	var ReactCurrentDispatcher = ReactSharedInternals.ReactCurrentDispatcher;
  	var prefix;
  	function describeBuiltInComponentFrame(name, source, ownerFn) {
  	  {
  	    if (prefix === undefined) {
  	      // Extract the VM specific prefix used by each line.
  	      try {
  	        throw Error();
  	      } catch (x) {
  	        var match = x.stack.trim().match(/\n( *(at )?)/);
  	        prefix = match && match[1] || '';
  	      }
  	    } // We use the prefix to ensure our stacks line up with native stack frames.


  	    return '\n' + prefix + name;
  	  }
  	}
  	var reentry = false;
  	var componentFrameCache;

  	{
  	  var PossiblyWeakMap = typeof WeakMap === 'function' ? WeakMap : Map;
  	  componentFrameCache = new PossiblyWeakMap();
  	}

  	function describeNativeComponentFrame(fn, construct) {
  	  // If something asked for a stack inside a fake render, it should get ignored.
  	  if ( !fn || reentry) {
  	    return '';
  	  }

  	  {
  	    var frame = componentFrameCache.get(fn);

  	    if (frame !== undefined) {
  	      return frame;
  	    }
  	  }

  	  var control;
  	  reentry = true;
  	  var previousPrepareStackTrace = Error.prepareStackTrace; // $FlowFixMe It does accept undefined.

  	  Error.prepareStackTrace = undefined;
  	  var previousDispatcher;

  	  {
  	    previousDispatcher = ReactCurrentDispatcher.current; // Set the dispatcher in DEV because this might be call in the render function
  	    // for warnings.

  	    ReactCurrentDispatcher.current = null;
  	    disableLogs();
  	  }

  	  try {
  	    // This should throw.
  	    if (construct) {
  	      // Something should be setting the props in the constructor.
  	      var Fake = function () {
  	        throw Error();
  	      }; // $FlowFixMe


  	      Object.defineProperty(Fake.prototype, 'props', {
  	        set: function () {
  	          // We use a throwing setter instead of frozen or non-writable props
  	          // because that won't throw in a non-strict mode function.
  	          throw Error();
  	        }
  	      });

  	      if (typeof Reflect === 'object' && Reflect.construct) {
  	        // We construct a different control for this case to include any extra
  	        // frames added by the construct call.
  	        try {
  	          Reflect.construct(Fake, []);
  	        } catch (x) {
  	          control = x;
  	        }

  	        Reflect.construct(fn, [], Fake);
  	      } else {
  	        try {
  	          Fake.call();
  	        } catch (x) {
  	          control = x;
  	        }

  	        fn.call(Fake.prototype);
  	      }
  	    } else {
  	      try {
  	        throw Error();
  	      } catch (x) {
  	        control = x;
  	      }

  	      fn();
  	    }
  	  } catch (sample) {
  	    // This is inlined manually because closure doesn't do it for us.
  	    if (sample && control && typeof sample.stack === 'string') {
  	      // This extracts the first frame from the sample that isn't also in the control.
  	      // Skipping one frame that we assume is the frame that calls the two.
  	      var sampleLines = sample.stack.split('\n');
  	      var controlLines = control.stack.split('\n');
  	      var s = sampleLines.length - 1;
  	      var c = controlLines.length - 1;

  	      while (s >= 1 && c >= 0 && sampleLines[s] !== controlLines[c]) {
  	        // We expect at least one stack frame to be shared.
  	        // Typically this will be the root most one. However, stack frames may be
  	        // cut off due to maximum stack limits. In this case, one maybe cut off
  	        // earlier than the other. We assume that the sample is longer or the same
  	        // and there for cut off earlier. So we should find the root most frame in
  	        // the sample somewhere in the control.
  	        c--;
  	      }

  	      for (; s >= 1 && c >= 0; s--, c--) {
  	        // Next we find the first one that isn't the same which should be the
  	        // frame that called our sample function and the control.
  	        if (sampleLines[s] !== controlLines[c]) {
  	          // In V8, the first line is describing the message but other VMs don't.
  	          // If we're about to return the first line, and the control is also on the same
  	          // line, that's a pretty good indicator that our sample threw at same line as
  	          // the control. I.e. before we entered the sample frame. So we ignore this result.
  	          // This can happen if you passed a class to function component, or non-function.
  	          if (s !== 1 || c !== 1) {
  	            do {
  	              s--;
  	              c--; // We may still have similar intermediate frames from the construct call.
  	              // The next one that isn't the same should be our match though.

  	              if (c < 0 || sampleLines[s] !== controlLines[c]) {
  	                // V8 adds a "new" prefix for native classes. Let's remove it to make it prettier.
  	                var _frame = '\n' + sampleLines[s].replace(' at new ', ' at '); // If our component frame is labeled "<anonymous>"
  	                // but we have a user-provided "displayName"
  	                // splice it in to make the stack more readable.


  	                if (fn.displayName && _frame.includes('<anonymous>')) {
  	                  _frame = _frame.replace('<anonymous>', fn.displayName);
  	                }

  	                {
  	                  if (typeof fn === 'function') {
  	                    componentFrameCache.set(fn, _frame);
  	                  }
  	                } // Return the line we found.


  	                return _frame;
  	              }
  	            } while (s >= 1 && c >= 0);
  	          }

  	          break;
  	        }
  	      }
  	    }
  	  } finally {
  	    reentry = false;

  	    {
  	      ReactCurrentDispatcher.current = previousDispatcher;
  	      reenableLogs();
  	    }

  	    Error.prepareStackTrace = previousPrepareStackTrace;
  	  } // Fallback to just using the name if we couldn't make it throw.


  	  var name = fn ? fn.displayName || fn.name : '';
  	  var syntheticFrame = name ? describeBuiltInComponentFrame(name) : '';

  	  {
  	    if (typeof fn === 'function') {
  	      componentFrameCache.set(fn, syntheticFrame);
  	    }
  	  }

  	  return syntheticFrame;
  	}
  	function describeFunctionComponentFrame(fn, source, ownerFn) {
  	  {
  	    return describeNativeComponentFrame(fn, false);
  	  }
  	}

  	function shouldConstruct(Component) {
  	  var prototype = Component.prototype;
  	  return !!(prototype && prototype.isReactComponent);
  	}

  	function describeUnknownElementTypeFrameInDEV(type, source, ownerFn) {

  	  if (type == null) {
  	    return '';
  	  }

  	  if (typeof type === 'function') {
  	    {
  	      return describeNativeComponentFrame(type, shouldConstruct(type));
  	    }
  	  }

  	  if (typeof type === 'string') {
  	    return describeBuiltInComponentFrame(type);
  	  }

  	  switch (type) {
  	    case REACT_SUSPENSE_TYPE:
  	      return describeBuiltInComponentFrame('Suspense');

  	    case REACT_SUSPENSE_LIST_TYPE:
  	      return describeBuiltInComponentFrame('SuspenseList');
  	  }

  	  if (typeof type === 'object') {
  	    switch (type.$$typeof) {
  	      case REACT_FORWARD_REF_TYPE:
  	        return describeFunctionComponentFrame(type.render);

  	      case REACT_MEMO_TYPE:
  	        // Memo may contain any component type so we recursively resolve it.
  	        return describeUnknownElementTypeFrameInDEV(type.type, source, ownerFn);

  	      case REACT_LAZY_TYPE:
  	        {
  	          var lazyComponent = type;
  	          var payload = lazyComponent._payload;
  	          var init = lazyComponent._init;

  	          try {
  	            // Lazy may contain any component type so we recursively resolve it.
  	            return describeUnknownElementTypeFrameInDEV(init(payload), source, ownerFn);
  	          } catch (x) {}
  	        }
  	    }
  	  }

  	  return '';
  	}

  	var hasOwnProperty = Object.prototype.hasOwnProperty;

  	var loggedTypeFailures = {};
  	var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;

  	function setCurrentlyValidatingElement(element) {
  	  {
  	    if (element) {
  	      var owner = element._owner;
  	      var stack = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);
  	      ReactDebugCurrentFrame.setExtraStackFrame(stack);
  	    } else {
  	      ReactDebugCurrentFrame.setExtraStackFrame(null);
  	    }
  	  }
  	}

  	function checkPropTypes(typeSpecs, values, location, componentName, element) {
  	  {
  	    // $FlowFixMe This is okay but Flow doesn't know it.
  	    var has = Function.call.bind(hasOwnProperty);

  	    for (var typeSpecName in typeSpecs) {
  	      if (has(typeSpecs, typeSpecName)) {
  	        var error$1 = void 0; // Prop type validation may throw. In case they do, we don't want to
  	        // fail the render phase where it didn't fail before. So we log it.
  	        // After these have been cleaned up, we'll let them throw.

  	        try {
  	          // This is intentionally an invariant that gets caught. It's the same
  	          // behavior as without this statement except with a better message.
  	          if (typeof typeSpecs[typeSpecName] !== 'function') {
  	            // eslint-disable-next-line react-internal/prod-error-codes
  	            var err = Error((componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' + 'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.' + 'This often happens because of typos such as `PropTypes.function` instead of `PropTypes.func`.');
  	            err.name = 'Invariant Violation';
  	            throw err;
  	          }

  	          error$1 = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED');
  	        } catch (ex) {
  	          error$1 = ex;
  	        }

  	        if (error$1 && !(error$1 instanceof Error)) {
  	          setCurrentlyValidatingElement(element);

  	          error('%s: type specification of %s' + ' `%s` is invalid; the type checker ' + 'function must return `null` or an `Error` but returned a %s. ' + 'You may have forgotten to pass an argument to the type checker ' + 'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' + 'shape all require an argument).', componentName || 'React class', location, typeSpecName, typeof error$1);

  	          setCurrentlyValidatingElement(null);
  	        }

  	        if (error$1 instanceof Error && !(error$1.message in loggedTypeFailures)) {
  	          // Only monitor this failure once because there tends to be a lot of the
  	          // same error.
  	          loggedTypeFailures[error$1.message] = true;
  	          setCurrentlyValidatingElement(element);

  	          error('Failed %s type: %s', location, error$1.message);

  	          setCurrentlyValidatingElement(null);
  	        }
  	      }
  	    }
  	  }
  	}

  	var isArrayImpl = Array.isArray; // eslint-disable-next-line no-redeclare

  	function isArray(a) {
  	  return isArrayImpl(a);
  	}

  	/*
  	 * The `'' + value` pattern (used in in perf-sensitive code) throws for Symbol
  	 * and Temporal.* types. See https://github.com/facebook/react/pull/22064.
  	 *
  	 * The functions in this module will throw an easier-to-understand,
  	 * easier-to-debug exception with a clear errors message message explaining the
  	 * problem. (Instead of a confusing exception thrown inside the implementation
  	 * of the `value` object).
  	 */
  	// $FlowFixMe only called in DEV, so void return is not possible.
  	function typeName(value) {
  	  {
  	    // toStringTag is needed for namespaced types like Temporal.Instant
  	    var hasToStringTag = typeof Symbol === 'function' && Symbol.toStringTag;
  	    var type = hasToStringTag && value[Symbol.toStringTag] || value.constructor.name || 'Object';
  	    return type;
  	  }
  	} // $FlowFixMe only called in DEV, so void return is not possible.


  	function willCoercionThrow(value) {
  	  {
  	    try {
  	      testStringCoercion(value);
  	      return false;
  	    } catch (e) {
  	      return true;
  	    }
  	  }
  	}

  	function testStringCoercion(value) {
  	  // If you ended up here by following an exception call stack, here's what's
  	  // happened: you supplied an object or symbol value to React (as a prop, key,
  	  // DOM attribute, CSS property, string ref, etc.) and when React tried to
  	  // coerce it to a string using `'' + value`, an exception was thrown.
  	  //
  	  // The most common types that will cause this exception are `Symbol` instances
  	  // and Temporal objects like `Temporal.Instant`. But any object that has a
  	  // `valueOf` or `[Symbol.toPrimitive]` method that throws will also cause this
  	  // exception. (Library authors do this to prevent users from using built-in
  	  // numeric operators like `+` or comparison operators like `>=` because custom
  	  // methods are needed to perform accurate arithmetic or comparison.)
  	  //
  	  // To fix the problem, coerce this object or symbol value to a string before
  	  // passing it to React. The most reliable way is usually `String(value)`.
  	  //
  	  // To find which value is throwing, check the browser or debugger console.
  	  // Before this exception was thrown, there should be `console.error` output
  	  // that shows the type (Symbol, Temporal.PlainDate, etc.) that caused the
  	  // problem and how that type was used: key, atrribute, input value prop, etc.
  	  // In most cases, this console output also shows the component and its
  	  // ancestor components where the exception happened.
  	  //
  	  // eslint-disable-next-line react-internal/safe-string-coercion
  	  return '' + value;
  	}
  	function checkKeyStringCoercion(value) {
  	  {
  	    if (willCoercionThrow(value)) {
  	      error('The provided key is an unsupported type %s.' + ' This value must be coerced to a string before before using it here.', typeName(value));

  	      return testStringCoercion(value); // throw (to help callers find troubleshooting comments)
  	    }
  	  }
  	}

  	var ReactCurrentOwner = ReactSharedInternals.ReactCurrentOwner;
  	var RESERVED_PROPS = {
  	  key: true,
  	  ref: true,
  	  __self: true,
  	  __source: true
  	};
  	var specialPropKeyWarningShown;
  	var specialPropRefWarningShown;
  	var didWarnAboutStringRefs;

  	{
  	  didWarnAboutStringRefs = {};
  	}

  	function hasValidRef(config) {
  	  {
  	    if (hasOwnProperty.call(config, 'ref')) {
  	      var getter = Object.getOwnPropertyDescriptor(config, 'ref').get;

  	      if (getter && getter.isReactWarning) {
  	        return false;
  	      }
  	    }
  	  }

  	  return config.ref !== undefined;
  	}

  	function hasValidKey(config) {
  	  {
  	    if (hasOwnProperty.call(config, 'key')) {
  	      var getter = Object.getOwnPropertyDescriptor(config, 'key').get;

  	      if (getter && getter.isReactWarning) {
  	        return false;
  	      }
  	    }
  	  }

  	  return config.key !== undefined;
  	}

  	function warnIfStringRefCannotBeAutoConverted(config, self) {
  	  {
  	    if (typeof config.ref === 'string' && ReactCurrentOwner.current && self && ReactCurrentOwner.current.stateNode !== self) {
  	      var componentName = getComponentNameFromType(ReactCurrentOwner.current.type);

  	      if (!didWarnAboutStringRefs[componentName]) {
  	        error('Component "%s" contains the string ref "%s". ' + 'Support for string refs will be removed in a future major release. ' + 'This case cannot be automatically converted to an arrow function. ' + 'We ask you to manually fix this case by using useRef() or createRef() instead. ' + 'Learn more about using refs safely here: ' + 'https://reactjs.org/link/strict-mode-string-ref', getComponentNameFromType(ReactCurrentOwner.current.type), config.ref);

  	        didWarnAboutStringRefs[componentName] = true;
  	      }
  	    }
  	  }
  	}

  	function defineKeyPropWarningGetter(props, displayName) {
  	  {
  	    var warnAboutAccessingKey = function () {
  	      if (!specialPropKeyWarningShown) {
  	        specialPropKeyWarningShown = true;

  	        error('%s: `key` is not a prop. Trying to access it will result ' + 'in `undefined` being returned. If you need to access the same ' + 'value within the child component, you should pass it as a different ' + 'prop. (https://reactjs.org/link/special-props)', displayName);
  	      }
  	    };

  	    warnAboutAccessingKey.isReactWarning = true;
  	    Object.defineProperty(props, 'key', {
  	      get: warnAboutAccessingKey,
  	      configurable: true
  	    });
  	  }
  	}

  	function defineRefPropWarningGetter(props, displayName) {
  	  {
  	    var warnAboutAccessingRef = function () {
  	      if (!specialPropRefWarningShown) {
  	        specialPropRefWarningShown = true;

  	        error('%s: `ref` is not a prop. Trying to access it will result ' + 'in `undefined` being returned. If you need to access the same ' + 'value within the child component, you should pass it as a different ' + 'prop. (https://reactjs.org/link/special-props)', displayName);
  	      }
  	    };

  	    warnAboutAccessingRef.isReactWarning = true;
  	    Object.defineProperty(props, 'ref', {
  	      get: warnAboutAccessingRef,
  	      configurable: true
  	    });
  	  }
  	}
  	/**
  	 * Factory method to create a new React element. This no longer adheres to
  	 * the class pattern, so do not use new to call it. Also, instanceof check
  	 * will not work. Instead test $$typeof field against Symbol.for('react.element') to check
  	 * if something is a React Element.
  	 *
  	 * @param {*} type
  	 * @param {*} props
  	 * @param {*} key
  	 * @param {string|object} ref
  	 * @param {*} owner
  	 * @param {*} self A *temporary* helper to detect places where `this` is
  	 * different from the `owner` when React.createElement is called, so that we
  	 * can warn. We want to get rid of owner and replace string `ref`s with arrow
  	 * functions, and as long as `this` and owner are the same, there will be no
  	 * change in behavior.
  	 * @param {*} source An annotation object (added by a transpiler or otherwise)
  	 * indicating filename, line number, and/or other information.
  	 * @internal
  	 */


  	var ReactElement = function (type, key, ref, self, source, owner, props) {
  	  var element = {
  	    // This tag allows us to uniquely identify this as a React Element
  	    $$typeof: REACT_ELEMENT_TYPE,
  	    // Built-in properties that belong on the element
  	    type: type,
  	    key: key,
  	    ref: ref,
  	    props: props,
  	    // Record the component responsible for creating this element.
  	    _owner: owner
  	  };

  	  {
  	    // The validation flag is currently mutative. We put it on
  	    // an external backing store so that we can freeze the whole object.
  	    // This can be replaced with a WeakMap once they are implemented in
  	    // commonly used development environments.
  	    element._store = {}; // To make comparing ReactElements easier for testing purposes, we make
  	    // the validation flag non-enumerable (where possible, which should
  	    // include every environment we run tests in), so the test framework
  	    // ignores it.

  	    Object.defineProperty(element._store, 'validated', {
  	      configurable: false,
  	      enumerable: false,
  	      writable: true,
  	      value: false
  	    }); // self and source are DEV only properties.

  	    Object.defineProperty(element, '_self', {
  	      configurable: false,
  	      enumerable: false,
  	      writable: false,
  	      value: self
  	    }); // Two elements created in two different places should be considered
  	    // equal for testing purposes and therefore we hide it from enumeration.

  	    Object.defineProperty(element, '_source', {
  	      configurable: false,
  	      enumerable: false,
  	      writable: false,
  	      value: source
  	    });

  	    if (Object.freeze) {
  	      Object.freeze(element.props);
  	      Object.freeze(element);
  	    }
  	  }

  	  return element;
  	};
  	/**
  	 * https://github.com/reactjs/rfcs/pull/107
  	 * @param {*} type
  	 * @param {object} props
  	 * @param {string} key
  	 */

  	function jsxDEV(type, config, maybeKey, source, self) {
  	  {
  	    var propName; // Reserved names are extracted

  	    var props = {};
  	    var key = null;
  	    var ref = null; // Currently, key can be spread in as a prop. This causes a potential
  	    // issue if key is also explicitly declared (ie. <div {...props} key="Hi" />
  	    // or <div key="Hi" {...props} /> ). We want to deprecate key spread,
  	    // but as an intermediary step, we will use jsxDEV for everything except
  	    // <div {...props} key="Hi" />, because we aren't currently able to tell if
  	    // key is explicitly declared to be undefined or not.

  	    if (maybeKey !== undefined) {
  	      {
  	        checkKeyStringCoercion(maybeKey);
  	      }

  	      key = '' + maybeKey;
  	    }

  	    if (hasValidKey(config)) {
  	      {
  	        checkKeyStringCoercion(config.key);
  	      }

  	      key = '' + config.key;
  	    }

  	    if (hasValidRef(config)) {
  	      ref = config.ref;
  	      warnIfStringRefCannotBeAutoConverted(config, self);
  	    } // Remaining properties are added to a new props object


  	    for (propName in config) {
  	      if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {
  	        props[propName] = config[propName];
  	      }
  	    } // Resolve default props


  	    if (type && type.defaultProps) {
  	      var defaultProps = type.defaultProps;

  	      for (propName in defaultProps) {
  	        if (props[propName] === undefined) {
  	          props[propName] = defaultProps[propName];
  	        }
  	      }
  	    }

  	    if (key || ref) {
  	      var displayName = typeof type === 'function' ? type.displayName || type.name || 'Unknown' : type;

  	      if (key) {
  	        defineKeyPropWarningGetter(props, displayName);
  	      }

  	      if (ref) {
  	        defineRefPropWarningGetter(props, displayName);
  	      }
  	    }

  	    return ReactElement(type, key, ref, self, source, ReactCurrentOwner.current, props);
  	  }
  	}

  	var ReactCurrentOwner$1 = ReactSharedInternals.ReactCurrentOwner;
  	var ReactDebugCurrentFrame$1 = ReactSharedInternals.ReactDebugCurrentFrame;

  	function setCurrentlyValidatingElement$1(element) {
  	  {
  	    if (element) {
  	      var owner = element._owner;
  	      var stack = describeUnknownElementTypeFrameInDEV(element.type, element._source, owner ? owner.type : null);
  	      ReactDebugCurrentFrame$1.setExtraStackFrame(stack);
  	    } else {
  	      ReactDebugCurrentFrame$1.setExtraStackFrame(null);
  	    }
  	  }
  	}

  	var propTypesMisspellWarningShown;

  	{
  	  propTypesMisspellWarningShown = false;
  	}
  	/**
  	 * Verifies the object is a ReactElement.
  	 * See https://reactjs.org/docs/react-api.html#isvalidelement
  	 * @param {?object} object
  	 * @return {boolean} True if `object` is a ReactElement.
  	 * @final
  	 */


  	function isValidElement(object) {
  	  {
  	    return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
  	  }
  	}

  	function getDeclarationErrorAddendum() {
  	  {
  	    if (ReactCurrentOwner$1.current) {
  	      var name = getComponentNameFromType(ReactCurrentOwner$1.current.type);

  	      if (name) {
  	        return '\n\nCheck the render method of `' + name + '`.';
  	      }
  	    }

  	    return '';
  	  }
  	}

  	function getSourceInfoErrorAddendum(source) {
  	  {
  	    if (source !== undefined) {
  	      var fileName = source.fileName.replace(/^.*[\\\/]/, '');
  	      var lineNumber = source.lineNumber;
  	      return '\n\nCheck your code at ' + fileName + ':' + lineNumber + '.';
  	    }

  	    return '';
  	  }
  	}
  	/**
  	 * Warn if there's no key explicitly set on dynamic arrays of children or
  	 * object keys are not valid. This allows us to keep track of children between
  	 * updates.
  	 */


  	var ownerHasKeyUseWarning = {};

  	function getCurrentComponentErrorInfo(parentType) {
  	  {
  	    var info = getDeclarationErrorAddendum();

  	    if (!info) {
  	      var parentName = typeof parentType === 'string' ? parentType : parentType.displayName || parentType.name;

  	      if (parentName) {
  	        info = "\n\nCheck the top-level render call using <" + parentName + ">.";
  	      }
  	    }

  	    return info;
  	  }
  	}
  	/**
  	 * Warn if the element doesn't have an explicit key assigned to it.
  	 * This element is in an array. The array could grow and shrink or be
  	 * reordered. All children that haven't already been validated are required to
  	 * have a "key" property assigned to it. Error statuses are cached so a warning
  	 * will only be shown once.
  	 *
  	 * @internal
  	 * @param {ReactElement} element Element that requires a key.
  	 * @param {*} parentType element's parent's type.
  	 */


  	function validateExplicitKey(element, parentType) {
  	  {
  	    if (!element._store || element._store.validated || element.key != null) {
  	      return;
  	    }

  	    element._store.validated = true;
  	    var currentComponentErrorInfo = getCurrentComponentErrorInfo(parentType);

  	    if (ownerHasKeyUseWarning[currentComponentErrorInfo]) {
  	      return;
  	    }

  	    ownerHasKeyUseWarning[currentComponentErrorInfo] = true; // Usually the current owner is the offender, but if it accepts children as a
  	    // property, it may be the creator of the child that's responsible for
  	    // assigning it a key.

  	    var childOwner = '';

  	    if (element && element._owner && element._owner !== ReactCurrentOwner$1.current) {
  	      // Give the component that originally created this child.
  	      childOwner = " It was passed a child from " + getComponentNameFromType(element._owner.type) + ".";
  	    }

  	    setCurrentlyValidatingElement$1(element);

  	    error('Each child in a list should have a unique "key" prop.' + '%s%s See https://reactjs.org/link/warning-keys for more information.', currentComponentErrorInfo, childOwner);

  	    setCurrentlyValidatingElement$1(null);
  	  }
  	}
  	/**
  	 * Ensure that every element either is passed in a static location, in an
  	 * array with an explicit keys property defined, or in an object literal
  	 * with valid key property.
  	 *
  	 * @internal
  	 * @param {ReactNode} node Statically passed child of any type.
  	 * @param {*} parentType node's parent's type.
  	 */


  	function validateChildKeys(node, parentType) {
  	  {
  	    if (typeof node !== 'object') {
  	      return;
  	    }

  	    if (isArray(node)) {
  	      for (var i = 0; i < node.length; i++) {
  	        var child = node[i];

  	        if (isValidElement(child)) {
  	          validateExplicitKey(child, parentType);
  	        }
  	      }
  	    } else if (isValidElement(node)) {
  	      // This element was passed in a valid location.
  	      if (node._store) {
  	        node._store.validated = true;
  	      }
  	    } else if (node) {
  	      var iteratorFn = getIteratorFn(node);

  	      if (typeof iteratorFn === 'function') {
  	        // Entry iterators used to provide implicit keys,
  	        // but now we print a separate warning for them later.
  	        if (iteratorFn !== node.entries) {
  	          var iterator = iteratorFn.call(node);
  	          var step;

  	          while (!(step = iterator.next()).done) {
  	            if (isValidElement(step.value)) {
  	              validateExplicitKey(step.value, parentType);
  	            }
  	          }
  	        }
  	      }
  	    }
  	  }
  	}
  	/**
  	 * Given an element, validate that its props follow the propTypes definition,
  	 * provided by the type.
  	 *
  	 * @param {ReactElement} element
  	 */


  	function validatePropTypes(element) {
  	  {
  	    var type = element.type;

  	    if (type === null || type === undefined || typeof type === 'string') {
  	      return;
  	    }

  	    var propTypes;

  	    if (typeof type === 'function') {
  	      propTypes = type.propTypes;
  	    } else if (typeof type === 'object' && (type.$$typeof === REACT_FORWARD_REF_TYPE || // Note: Memo only checks outer props here.
  	    // Inner props are checked in the reconciler.
  	    type.$$typeof === REACT_MEMO_TYPE)) {
  	      propTypes = type.propTypes;
  	    } else {
  	      return;
  	    }

  	    if (propTypes) {
  	      // Intentionally inside to avoid triggering lazy initializers:
  	      var name = getComponentNameFromType(type);
  	      checkPropTypes(propTypes, element.props, 'prop', name, element);
  	    } else if (type.PropTypes !== undefined && !propTypesMisspellWarningShown) {
  	      propTypesMisspellWarningShown = true; // Intentionally inside to avoid triggering lazy initializers:

  	      var _name = getComponentNameFromType(type);

  	      error('Component %s declared `PropTypes` instead of `propTypes`. Did you misspell the property assignment?', _name || 'Unknown');
  	    }

  	    if (typeof type.getDefaultProps === 'function' && !type.getDefaultProps.isReactClassApproved) {
  	      error('getDefaultProps is only used on classic React.createClass ' + 'definitions. Use a static property named `defaultProps` instead.');
  	    }
  	  }
  	}
  	/**
  	 * Given a fragment, validate that it can only be provided with fragment props
  	 * @param {ReactElement} fragment
  	 */


  	function validateFragmentProps(fragment) {
  	  {
  	    var keys = Object.keys(fragment.props);

  	    for (var i = 0; i < keys.length; i++) {
  	      var key = keys[i];

  	      if (key !== 'children' && key !== 'key') {
  	        setCurrentlyValidatingElement$1(fragment);

  	        error('Invalid prop `%s` supplied to `React.Fragment`. ' + 'React.Fragment can only have `key` and `children` props.', key);

  	        setCurrentlyValidatingElement$1(null);
  	        break;
  	      }
  	    }

  	    if (fragment.ref !== null) {
  	      setCurrentlyValidatingElement$1(fragment);

  	      error('Invalid attribute `ref` supplied to `React.Fragment`.');

  	      setCurrentlyValidatingElement$1(null);
  	    }
  	  }
  	}

  	var didWarnAboutKeySpread = {};
  	function jsxWithValidation(type, props, key, isStaticChildren, source, self) {
  	  {
  	    var validType = isValidElementType(type); // We warn in this case but don't throw. We expect the element creation to
  	    // succeed and there will likely be errors in render.

  	    if (!validType) {
  	      var info = '';

  	      if (type === undefined || typeof type === 'object' && type !== null && Object.keys(type).length === 0) {
  	        info += ' You likely forgot to export your component from the file ' + "it's defined in, or you might have mixed up default and named imports.";
  	      }

  	      var sourceInfo = getSourceInfoErrorAddendum(source);

  	      if (sourceInfo) {
  	        info += sourceInfo;
  	      } else {
  	        info += getDeclarationErrorAddendum();
  	      }

  	      var typeString;

  	      if (type === null) {
  	        typeString = 'null';
  	      } else if (isArray(type)) {
  	        typeString = 'array';
  	      } else if (type !== undefined && type.$$typeof === REACT_ELEMENT_TYPE) {
  	        typeString = "<" + (getComponentNameFromType(type.type) || 'Unknown') + " />";
  	        info = ' Did you accidentally export a JSX literal instead of a component?';
  	      } else {
  	        typeString = typeof type;
  	      }

  	      error('React.jsx: type is invalid -- expected a string (for ' + 'built-in components) or a class/function (for composite ' + 'components) but got: %s.%s', typeString, info);
  	    }

  	    var element = jsxDEV(type, props, key, source, self); // The result can be nullish if a mock or a custom function is used.
  	    // TODO: Drop this when these are no longer allowed as the type argument.

  	    if (element == null) {
  	      return element;
  	    } // Skip key warning if the type isn't valid since our key validation logic
  	    // doesn't expect a non-string/function type and can throw confusing errors.
  	    // We don't want exception behavior to differ between dev and prod.
  	    // (Rendering will throw with a helpful message and as soon as the type is
  	    // fixed, the key warnings will appear.)


  	    if (validType) {
  	      var children = props.children;

  	      if (children !== undefined) {
  	        if (isStaticChildren) {
  	          if (isArray(children)) {
  	            for (var i = 0; i < children.length; i++) {
  	              validateChildKeys(children[i], type);
  	            }

  	            if (Object.freeze) {
  	              Object.freeze(children);
  	            }
  	          } else {
  	            error('React.jsx: Static children should always be an array. ' + 'You are likely explicitly calling React.jsxs or React.jsxDEV. ' + 'Use the Babel transform instead.');
  	          }
  	        } else {
  	          validateChildKeys(children, type);
  	        }
  	      }
  	    }

  	    {
  	      if (hasOwnProperty.call(props, 'key')) {
  	        var componentName = getComponentNameFromType(type);
  	        var keys = Object.keys(props).filter(function (k) {
  	          return k !== 'key';
  	        });
  	        var beforeExample = keys.length > 0 ? '{key: someKey, ' + keys.join(': ..., ') + ': ...}' : '{key: someKey}';

  	        if (!didWarnAboutKeySpread[componentName + beforeExample]) {
  	          var afterExample = keys.length > 0 ? '{' + keys.join(': ..., ') + ': ...}' : '{}';

  	          error('A props object containing a "key" prop is being spread into JSX:\n' + '  let props = %s;\n' + '  <%s {...props} />\n' + 'React keys must be passed directly to JSX without using spread:\n' + '  let props = %s;\n' + '  <%s key={someKey} {...props} />', beforeExample, componentName, afterExample, componentName);

  	          didWarnAboutKeySpread[componentName + beforeExample] = true;
  	        }
  	      }
  	    }

  	    if (type === REACT_FRAGMENT_TYPE) {
  	      validateFragmentProps(element);
  	    } else {
  	      validatePropTypes(element);
  	    }

  	    return element;
  	  }
  	} // These two functions exist to still get child warnings in dev
  	// even with the prod transform. This means that jsxDEV is purely
  	// opt-in behavior for better messages but that we won't stop
  	// giving you warnings if you use production apis.

  	function jsxWithValidationStatic(type, props, key) {
  	  {
  	    return jsxWithValidation(type, props, key, true);
  	  }
  	}
  	function jsxWithValidationDynamic(type, props, key) {
  	  {
  	    return jsxWithValidation(type, props, key, false);
  	  }
  	}

  	var jsx =  jsxWithValidationDynamic ; // we may want to special case jsxs internally to take advantage of static children.
  	// for now we can ship identical prod functions

  	var jsxs =  jsxWithValidationStatic ;

  	reactJsxRuntime_development.Fragment = REACT_FRAGMENT_TYPE;
  	reactJsxRuntime_development.jsx = jsx;
  	reactJsxRuntime_development.jsxs = jsxs;
  	  })();
  	}
  	return reactJsxRuntime_development;
  }

  var hasRequiredJsxRuntime;

  function requireJsxRuntime () {
  	if (hasRequiredJsxRuntime) return jsxRuntime.exports;
  	hasRequiredJsxRuntime = 1;

  	{
  	  jsxRuntime.exports = requireReactJsxRuntime_development();
  	}
  	return jsxRuntime.exports;
  }

  var jsxRuntimeExports = requireJsxRuntime();

  var LoadingView = function LoadingView() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("div", {
      className: "ao-container",
      children: /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-inner-container",
        children: [/*#__PURE__*/jsxRuntimeExports.jsx("div", {
          className: "ao-spinner"
        }), /*#__PURE__*/jsxRuntimeExports.jsx("div", {
          style: {
            fontWeight: '500',
            color: 'var(--ao-gray-800)',
            fontSize: '16px'
          },
          children: "Loading Acquia Optimize..."
        })]
      })
    });
  };

  // SVG components
  var ExternalLinkIcon = function ExternalLinkIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
      width: "14",
      height: "14",
      viewBox: "0 0 24 24",
      fill: "currentColor",
      style: {
        marginLeft: '4px'
      },
      children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M18 13v6a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V8a2 2 0 0 1 2-2h6v2H5v11h11v-6h2zM13 3v2h4.586l-7.793 7.793 1.414 1.414L19 6.414V11h2V3h-8z"
      })
    });
  };

  // No permission icon component
  var NoPermissionIcon = function NoPermissionIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsxs("svg", {
      style: {
        width: '48px',
        height: '48px',
        marginBottom: '15px',
        color: 'var(--ao-red)'
      },
      viewBox: "0 0 24 24",
      fill: "currentColor",
      children: [/*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M12 4c-4.4 0-8 3.6-8 8s3.6 8 8 8 8-3.6 8-8-3.6-8-8-8zm0 14c-3.3 0-6-2.7-6-6s2.7-6 6-6 6 2.7 6 6-2.7 6-6 6z"
      }), /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M11 7h2v7h-2zm0 8h2v2h-2z"
      })]
    });
  };

  // Wheel icon component
  var WheelIcon = function WheelIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsxs("svg", {
      width: "14",
      height: "14",
      viewBox: "0 0 24 24",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg",
      style: {
        marginRight: '5px'
      },
      children: [/*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M12.22 2h-.44a2 2 0 0 0-2 2v.18a2 2 0 0 1-1 1.73l-.43.25a2 2 0 0 1-2 0l-.15-.08a2 2 0 0 0-2.73.73l-.22.38a2 2 0 0 0 .73 2.73l.15.1a2 2 0 0 1 1 1.72v.51a2 2 0 0 1-1 1.74l-.15.09a2 2 0 0 0-.73 2.73l.22.38a2 2 0 0 0 2.73.73l.15-.08a2 2 0 0 1 2 0l.43.25a2 2 0 0 1 1 1.73V20a2 2 0 0 0 2 2h.44a2 2 0 0 0 2-2v-.18a2 2 0 0 1 1-1.73l.43-.25a2 2 0 0 1 2 0l.15.08a2 2 0 0 0 2.73-.73l.22-.39a2 2 0 0 0-.73-2.73l-.15-.08a2 2 0 0 1-1-1.74v-.5a2 2 0 0 1 1-1.74l.15-.09a2 2 0 0 0 .73-2.73l-.22-.38a2 2 0 0 0-2.73-.73l-.15.08a2 2 0 0 1-2 0l-.43-.25a2 2 0 0 1-1-1.73V4a2 2 0 0 0-2-2z",
        stroke: "currentColor",
        strokeWidth: "2",
        strokeLinecap: "round",
        strokeLinejoin: "round"
      }), /*#__PURE__*/jsxRuntimeExports.jsx("circle", {
        cx: "12",
        cy: "12",
        r: "3",
        stroke: "currentColor",
        strokeWidth: "2",
        strokeLinecap: "round",
        strokeLinejoin: "round"
      })]
    });
  };

  // Retry icon component
  var RetryIcon = function RetryIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
      width: "16",
      height: "16",
      viewBox: "0 0 24 24",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg",
      style: {
        marginRight: '8px'
      },
      children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M17.65 6.35C16.2 4.9 14.21 4 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08c-.82 2.33-3.04 4-5.65 4-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z",
        fill: "white"
      })
    });
  };
  var NoIssueIcon = function NoIssueIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
      className: "ao-results-icon",
      viewBox: "0 0 24 24",
      fill: "currentColor",
      children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-2-13.5l-2.5 2.5 6 6 6-6-2.5-2.5-3.5 3.5-3.5-3.5z"
      })
    });
  };
  var WarningIcon = function WarningIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
      className: "ao-results-icon",
      viewBox: "0 0 24 24",
      fill: "currentColor",
      children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-1-13h2v6h-2zm0 8h2v2h-2z"
      })
    });
  };

  // Accessibility icon component
  var AccessibilityIcon = function AccessibilityIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
      className: "ao-category-icon",
      viewBox: "0 0 24 24",
      fill: "currentColor",
      children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M12 5C13.6569 5 15 6.34315 15 8C15 9.65685 13.6569 11 12 11C10.3431 11 9 9.65685 9 8C9 6.34315 10.3431 5 12 5ZM12 12C14.7614 12 17 9.76142 17 7C17 4.23858 14.7614 2 12 2C9.23858 2 7 4.23858 7 7C7 9.76142 9.23858 12 12 12ZM8.5 14C5.46243 14 3 16.4624 3 19.5V21C3 21.5523 3.44772 22 4 22H20C20.5523 22 21 21.5523 21 21V19.5C21 16.4624 18.5376 14 15.5 14H8.5Z"
      })
    });
  };

  // Readability icon component
  var ReadabilityIcon = function ReadabilityIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
      className: "ao-category-icon",
      viewBox: "0 0 24 24",
      fill: "currentColor",
      children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M3 17V5C3 3.9 3.9 3 5 3H19C20.1 3 21 3.9 21 5V17C21 18.1 20.1 19 19 19H5C3.9 19 3 18.1 3 17ZM5 17H19V5H5V17ZM7 7H17V9H7V7ZM7 11H17V13H7V11Z"
      })
    });
  };

  // Data privacy icon component
  var DataPrivacyIcon = function DataPrivacyIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
      style: {
        width: '24px',
        height: '24px',
        marginRight: '12px',
        color: '#0078ff'
      },
      viewBox: "0 0 24 24",
      fill: "currentColor",
      children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M12 1L3 5V11C3 16.55 6.84 21.74 12 23C17.16 21.74 21 16.55 21 11V5L12 1ZM19 11C19 15.5 16.2 19.69 12 21.5C7.8 19.69 5 15.5 5 11V6.3L12 3.19L19 6.3V11ZM12 7C10.34 7 9 8.34 9 10C9 11.31 9.83 12.42 11 12.83V16H13V12.83C14.17 12.42 15 11.31 15 10C15 8.34 13.66 7 12 7ZM12 11C11.45 11 11 10.55 11 10C11 9.45 11.45 9 12 9C12.55 9 13 9.45 13 10C13 10.55 12.55 11 12 11Z"
      })
    });
  };

  // SEO icon component
  var SeoIcon = function SeoIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
      style: {
        width: '24px',
        height: '24px',
        marginRight: '12px',
        color: '#0078ff'
      },
      viewBox: "0 0 24 24",
      fill: "currentColor",
      children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M3 13H5V11H3V13ZM3 17H5V15H3V17ZM3 9H5V7H3V9ZM7 13H21V11H7V13ZM7 17H21V15H7V17ZM7 7V9H21V7H7Z"
      })
    });
  };
  var GenericCheckIcon = function GenericCheckIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
      style: {
        width: '18px',
        height: '18px',
        marginRight: '6px',
        color: '#00cc00'
      },
      viewBox: "0 0 24 24",
      fill: "currentColor",
      children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-2-5.5l6-6 1.5 1.5-7.5 7.5L6 14l1.5-1.5 2.5 2.5z"
      })
    });
  };
  var GenericWarningIcon = function GenericWarningIcon() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
      style: {
        width: '18px',
        height: '18px',
        marginRight: '6px',
        color: '#cc0000'
      },
      viewBox: "0 0 24 24",
      fill: "currentColor",
      children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
        d: "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm-1-13h2v6h-2zm0 8h2v2h-2z"
      })
    });
  };

  // Acquia Optimize logo component
  var AcquiaOptimizeLogo = function AcquiaOptimizeLogo(_ref) {
    var _ref$OptimizeLogo = _ref.OptimizeLogo,
      OptimizeLogo = _ref$OptimizeLogo === void 0 ? "" : _ref$OptimizeLogo,
      _ref$alt = _ref.alt,
      alt = _ref$alt === void 0 ? "Acquia Optimize logo" : _ref$alt,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? "ao-logo" : _ref$className;
    return /*#__PURE__*/jsxRuntimeExports.jsx("img", {
      src: OptimizeLogo,
      alt: alt,
      className: className
    });
  };

  var Footer = function Footer(_ref) {
    var _drupalSettings$xbExt, _drupalSettings$xbExt2;
    var _ref$AcquiaDocs = _ref.AcquiaDocs,
      AcquiaDocs = _ref$AcquiaDocs === void 0 ? false : _ref$AcquiaDocs;
    var _window = window,
      drupalSettings = _window.drupalSettings;
    var accountUrl = (drupalSettings === null || drupalSettings === void 0 || (_drupalSettings$xbExt = drupalSettings.xbExtension) === null || _drupalSettings$xbExt === void 0 || (_drupalSettings$xbExt = _drupalSettings$xbExt.acquiaOptimize) === null || _drupalSettings$xbExt === void 0 ? void 0 : _drupalSettings$xbExt.accountUrl) || 'https://new.monsido.com';
    var accountText = (drupalSettings === null || drupalSettings === void 0 || (_drupalSettings$xbExt2 = drupalSettings.xbExtension) === null || _drupalSettings$xbExt2 === void 0 || (_drupalSettings$xbExt2 = _drupalSettings$xbExt2.acquiaOptimize) === null || _drupalSettings$xbExt2 === void 0 ? void 0 : _drupalSettings$xbExt2.accountText) || 'Go to your Optimize account';
    return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
      className: "ao-footer",
      children: [AcquiaDocs && /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-footer-text",
        children: ["Results are not synchronized to your Acquia Optimize account.", /*#__PURE__*/jsxRuntimeExports.jsx("br", {}), "To learn more visit ", /*#__PURE__*/jsxRuntimeExports.jsxs("a", {
          href: "https://docs.acquia.com/acquia-optimize",
          target: "_blank",
          rel: "noopener noreferrer",
          className: "ao-link",
          children: ["Acquia Docs ", /*#__PURE__*/jsxRuntimeExports.jsx(ExternalLinkIcon, {})]
        })]
      }), /*#__PURE__*/jsxRuntimeExports.jsxs("a", {
        href: accountUrl,
        target: "_blank",
        rel: "noopener noreferrer",
        className: "ao-account-button",
        children: [accountText, " ", /*#__PURE__*/jsxRuntimeExports.jsx(ExternalLinkIcon, {})]
      })]
    });
  };

  var _getDrupalSettings$4 = getDrupalSettings(),
    imgSrc$4 = _getDrupalSettings$4.imgSrc;
  var NoPermissionView = function NoPermissionView() {
    return /*#__PURE__*/jsxRuntimeExports.jsx("div", {
      className: "ao-container",
      children: /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-inner-container",
        children: [/*#__PURE__*/jsxRuntimeExports.jsx(AcquiaOptimizeLogo, {
          OptimizeLogo: "".concat(imgSrc$4)
        }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-message ao-message--error",
          style: {
            backgroundColor: 'var(--ao-light-red)',
            borderRadius: '8px',
            padding: '25px',
            textAlign: 'center',
            width: '100%',
            boxSizing: 'border-box'
          },
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(NoPermissionIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("h3", {
            style: {
              margin: '0 0 10px 0',
              color: 'var(--ao-gray-800)'
            },
            children: "Permission Denied"
          }), /*#__PURE__*/jsxRuntimeExports.jsx("p", {
            style: {
              color: 'var(--ao-gray-600)',
              margin: '0 0 15px 0'
            },
            children: "You don't have permission to use Acquia Optimize. You need either the \"scan acquia optimize\" or \"administer acquia optimize\" permission to access this feature."
          })]
        }), /*#__PURE__*/jsxRuntimeExports.jsx(Footer, {})]
      })
    });
  };

  var _getDrupalSettings$3 = getDrupalSettings(),
    imgSrc$3 = _getDrupalSettings$3.imgSrc;
  var QuickScanView = function QuickScanView(_ref) {
    var helperText = _ref.helperText,
      startQuickScan = _ref.startQuickScan,
      canScan = _ref.canScan,
      canConfigure = _ref.canConfigure;
    return /*#__PURE__*/jsxRuntimeExports.jsx("div", {
      className: "ao-container",
      children: /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-inner-container",
        children: [/*#__PURE__*/jsxRuntimeExports.jsx(AcquiaOptimizeLogo, {
          OptimizeLogo: "".concat(imgSrc$3)
        }), /*#__PURE__*/jsxRuntimeExports.jsx("h2", {
          className: "ao-heading",
          children: "Quick Scan"
        }), /*#__PURE__*/jsxRuntimeExports.jsx("p", {
          className: "ao-subheading",
          children: "Receive quick feedback on issues found within this page."
        }), helperText && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
          className: "ao-message ".concat(helperText.includes('Error') ? 'ao-message--error' : 'ao-message--success'),
          children: helperText
        }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          style: {
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
            gap: '15px',
            width: '100%'
          },
          children: [/*#__PURE__*/jsxRuntimeExports.jsxs("button", {
            onClick: startQuickScan,
            disabled: !canScan && !canConfigure,
            className: "ao-button ao-button--icon",
            children: [/*#__PURE__*/jsxRuntimeExports.jsx("span", {
              style: {
                marginRight: '8px',
                fontSize: '18px'
              },
              children: "\u26A1"
            }), "Start Quick Scan", !canScan && !canConfigure && /*#__PURE__*/jsxRuntimeExports.jsx("span", {
              style: {
                marginLeft: '8px',
                fontSize: '12px'
              },
              children: "(Permission required)"
            })]
          }), canConfigure && /*#__PURE__*/jsxRuntimeExports.jsxs("a", {
            href: "/admin/config/content/acquia-optimize",
            target: "_blank",
            rel: "noopener noreferrer",
            className: "ao-link",
            style: {
              color: 'var(--ao-gray-500)',
              fontSize: '14px'
            },
            children: [/*#__PURE__*/jsxRuntimeExports.jsx(WheelIcon, {}), "Configure API Settings"]
          })]
        }), /*#__PURE__*/jsxRuntimeExports.jsx(Footer, {
          AcquiaDocs: true
        })]
      })
    });
  };

  var _getDrupalSettings$2 = getDrupalSettings(),
    imgSrc$2 = _getDrupalSettings$2.imgSrc;
  // Remove filename to get just the directory path
  var imgPath = imgSrc$2.replace(/\/[^\/]*$/, '');
  var ScanningView = function ScanningView(_ref) {
    var scanProgress = _ref.scanProgress;
    return /*#__PURE__*/jsxRuntimeExports.jsx("div", {
      className: "ao-container",
      children: /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-inner-container",
        children: [/*#__PURE__*/jsxRuntimeExports.jsx(AcquiaOptimizeLogo, {
          OptimizeLogo: "".concat(imgPath, "/start-scan.svg"),
          alt: "Acquia Optimize Scan",
          className: "ao-scan"
        }), /*#__PURE__*/jsxRuntimeExports.jsx("h2", {
          className: "ao-heading",
          children: "Quick Scan in progress..."
        }), /*#__PURE__*/jsxRuntimeExports.jsx("div", {
          className: "ao-progress-container",
          children: /*#__PURE__*/jsxRuntimeExports.jsx("div", {
            className: "ao-progress-bar",
            style: {
              width: "".concat(scanProgress, "%")
            }
          })
        }), /*#__PURE__*/jsxRuntimeExports.jsx(Footer, {
          AcquiaDocs: true
        })]
      })
    });
  };

  var _excluded$1 = ["style"];
  /**
   * Button component with consistent styling for the Acquia Optimize extension
   */
  var Button = function Button(props) {
    var baseStyles = {
      display: 'inline-flex',
      alignItems: 'center',
      justifyContent: 'center',
      backgroundColor: 'var(--ao-primary-blue, #0078ff)',
      color: 'white',
      border: 'none',
      borderRadius: '4px',
      padding: '10px 20px',
      fontSize: '15px',
      fontWeight: '600',
      cursor: 'pointer',
      transition: 'background-color 0.2s ease',
      fontFamily: '"SF Pro", system-ui, -apple-system, BlinkMacSystemFont, sans-serif'
    };

    // Combine provided style props with base styles
    var combinedStyles = _objectSpread2(_objectSpread2({}, baseStyles), props.style || {});

    // Remove style prop to avoid passing it twice
    props.style;
      var otherProps = _objectWithoutProperties(props, _excluded$1);
    return /*#__PURE__*/jsxRuntimeExports.jsx("button", _objectSpread2(_objectSpread2({
      style: combinedStyles
    }, otherProps), {}, {
      children: props.children
    }));
  };

  var ResultsHeader = function ResultsHeader(_ref) {
    var totalIssues = _ref.totalIssues,
      scanDate = _ref.scanDate,
      startQuickScan = _ref.startQuickScan,
      canScan = _ref.canScan,
      canConfigure = _ref.canConfigure;
    // Use processed scan date if available, otherwise format current date
    var displayDate = scanDate || formatScanDate();
    return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
      className: "ao-results-card",
      children: [totalIssues > 0 ? /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-results-header ao-results-header--error",
        children: [/*#__PURE__*/jsxRuntimeExports.jsx(WarningIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsxs("h2", {
          className: "ao-results-title",
          children: [totalIssues, " issues total detected"]
        })]
      }) : /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-results-header ao-results-header--success",
        children: [/*#__PURE__*/jsxRuntimeExports.jsx(NoIssueIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("h2", {
          className: "ao-results-title",
          children: "No issues detected"
        })]
      }), /*#__PURE__*/jsxRuntimeExports.jsx("p", {
        className: "ao-results-subtitle",
        children: "Quick Scan is complete"
      }), /*#__PURE__*/jsxRuntimeExports.jsxs("p", {
        className: "ao-results-date",
        children: ["Scanned date: ", displayDate]
      }), /*#__PURE__*/jsxRuntimeExports.jsx("div", {
        className: "ao-rescan-button",
        children: /*#__PURE__*/jsxRuntimeExports.jsxs(Button, {
          onClick: startQuickScan,
          disabled: !canScan && !canConfigure,
          className: "ao-button ao-button--icon",
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(RetryIcon, {}), "Re-scan page"]
        })
      })]
    });
  };

  var ReadabilitySection = function ReadabilitySection(_ref) {
    var readabilityData = _ref.readabilityData,
      toggleSection = _ref.toggleSection,
      expandedSections = _ref.expandedSections;
    return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
      className: "ao-category-section",
      children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-category-header",
        onClick: function onClick() {
          return toggleSection('readability');
        },
        children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-category-title",
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(ReadabilityIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("h3", {
            className: "ao-category-name",
            children: "Readability"
          })]
        }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-category-count",
          children: [/*#__PURE__*/jsxRuntimeExports.jsx("span", {
            style: {
              fontSize: '24px',
              fontWeight: 'bold',
              color: readabilityData.score_color
            },
            children: readabilityData.score_display
          }), /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
            className: "ao-category-arrow ".concat(expandedSections.readability ? 'ao-category-arrow--expanded' : ''),
            viewBox: "0 0 24 24",
            fill: "#333",
            children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
              d: "M7 10L12 15L17 10H7Z"
            })
          })]
        })]
      }), expandedSections.readability && /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-category-content",
        children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-readability-info",
          children: [/*#__PURE__*/jsxRuntimeExports.jsxs("strong", {
            className: "ao-readability-grade",
            children: [readabilityData.grade_level, ":"]
          }), /*#__PURE__*/jsxRuntimeExports.jsx("span", {
            className: "ao-readability-description",
            children: readabilityData.description
          })]
        }), /*#__PURE__*/jsxRuntimeExports.jsx("p", {
          className: "ao-readability-explanation",
          children: "Readability refers to how easily a reader can understand written text. LIX is a readability index that measures how easy or difficult a text is to read."
        }), /*#__PURE__*/jsxRuntimeExports.jsx("p", {
          className: "ao-readability-explanation",
          children: "It analyzes sentence length and word length to assign a score, helping you gauge the reading level required to understand a web page. LIX is widely used to assess and compare the readability of texts in different languages."
        })]
      })]
    });
  };

  var DataPrivacySection = function DataPrivacySection(_ref) {
    var expandedSections = _ref.expandedSections,
      toggleSection = _ref.toggleSection,
      dataPrivacyIssues = _ref.dataPrivacyIssues;
    var dataPrivacyCount = (dataPrivacyIssues === null || dataPrivacyIssues === void 0 ? void 0 : dataPrivacyIssues.length) || 0;
    return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
      className: "ao-category-section",
      children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-category-header",
        onClick: function onClick() {
          return toggleSection('dataPrivacy');
        },
        children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-category-title",
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(DataPrivacyIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("h3", {
            className: "ao-category-name",
            children: "Data Privacy"
          })]
        }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-category-count",
          children: [dataPrivacyCount > 0 ? /*#__PURE__*/jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, {
            children: [/*#__PURE__*/jsxRuntimeExports.jsx(GenericWarningIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("span", {
              className: "ao-count-number ao-count-number--error",
              children: dataPrivacyCount
            })]
          }) : /*#__PURE__*/jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, {
            children: [/*#__PURE__*/jsxRuntimeExports.jsx(GenericCheckIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("span", {
              className: "ao-count-number ao-count-number--success",
              children: "0"
            })]
          }), /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
            className: "ao-category-arrow ".concat(expandedSections.dataPrivacy ? 'ao-category-arrow--expanded' : ''),
            viewBox: "0 0 24 24",
            fill: "#333",
            children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
              d: "M7 10L12 15L17 10H7Z"
            })
          })]
        })]
      }), expandedSections.dataPrivacy && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
        className: "ao-data-privacy-content",
        children: dataPrivacyIssues && dataPrivacyIssues.length > 0 ? /*#__PURE__*/jsxRuntimeExports.jsx("div", {
          className: "ao-issues-container",
          children: dataPrivacyIssues.map(function (issue, index) {
            return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
              className: "ao-issue",
              children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                className: "ao-issue-header",
                children: [/*#__PURE__*/jsxRuntimeExports.jsx("div", {
                  className: "ao-issue-title",
                  children: issue.name || "Data Privacy Issue ".concat(index + 1)
                }), issue.priority && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
                  className: "ao-seo-issue-badge ao-seo-issue-badge--".concat(issue.priority.toLowerCase()),
                  children: issue.priority
                })]
              }), issue.content && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
                className: "ao-issue-content",
                children: /*#__PURE__*/jsxRuntimeExports.jsx("div", {
                  dangerouslySetInnerHTML: {
                    __html: issue.content
                  }
                })
              })]
            }, index);
          })
        }) : /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-data-privacy-content",
          children: [/*#__PURE__*/jsxRuntimeExports.jsx("p", {
            className: "ao-issue-content",
            children: "No data privacy issues were detected on this page. The scan checks for:"
          }), /*#__PURE__*/jsxRuntimeExports.jsxs("ul", {
            className: "ao-data-privacy-list",
            children: [/*#__PURE__*/jsxRuntimeExports.jsx("li", {
              children: "Insecure form submissions"
            }), /*#__PURE__*/jsxRuntimeExports.jsx("li", {
              children: "Missing privacy policies"
            }), /*#__PURE__*/jsxRuntimeExports.jsx("li", {
              children: "Potentially unsafe third-party scripts"
            }), /*#__PURE__*/jsxRuntimeExports.jsx("li", {
              children: "Data collection without consent"
            })]
          })]
        })
      })]
    });
  };

  var AccessibilitySection = function AccessibilitySection(_ref) {
    var accessibilityIssues = _ref.accessibilityIssues,
      accessibilityCount = _ref.accessibilityCount,
      toggleSection = _ref.toggleSection,
      expandedSections = _ref.expandedSections,
      detailedIssues = _ref.detailedIssues,
      showIssuesForLevel = _ref.showIssuesForLevel;
    return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
      className: "ao-category-section",
      children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-category-header",
        onClick: function onClick() {
          return toggleSection('accessibility');
        },
        children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-category-title",
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(AccessibilityIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("h3", {
            className: "ao-category-name",
            children: "Accessibility"
          })]
        }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-category-count",
          children: [accessibilityCount > 0 ? /*#__PURE__*/jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, {
            children: [/*#__PURE__*/jsxRuntimeExports.jsx(GenericWarningIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("span", {
              className: "ao-count-number ao-count-number--error",
              children: accessibilityCount
            })]
          }) : /*#__PURE__*/jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, {
            children: [/*#__PURE__*/jsxRuntimeExports.jsx(GenericCheckIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("span", {
              className: "ao-count-number ao-count-number--success",
              children: "0"
            })]
          }), /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
            className: "ao-category-arrow ".concat(expandedSections.accessibility ? 'ao-category-arrow--expanded' : ''),
            viewBox: "0 0 24 24",
            fill: "#333",
            children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
              d: "M7 10L12 15L17 10H7Z"
            })
          })]
        })]
      }), expandedSections.accessibility && accessibilityIssues.length > 0 && /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-category-content",
        children: [['A', 'AA', 'AAA'].map(function (level) {
          var levelIssues = accessibilityIssues.filter(function (issue) {
            return issue.level === level;
          });
          if (levelIssues.length === 0) return null;
          return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
            className: "ao-subcategory",
            onClick: function onClick(e) {
              return showIssuesForLevel(level, e);
            },
            children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
              className: "ao-subcategory-label",
              children: [/*#__PURE__*/jsxRuntimeExports.jsx("div", {
                className: "ao-subcategory-badge ao-subcategory-badge--".concat(level.toLowerCase()),
                children: level
              }), /*#__PURE__*/jsxRuntimeExports.jsxs("span", {
                className: "ao-subcategory-text",
                children: ["Failing ", level, " checks"]
              })]
            }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
              className: "ao-subcategory-count",
              children: [/*#__PURE__*/jsxRuntimeExports.jsxs("span", {
                className: "ao-subcategory-count-text",
                children: ["View ", levelIssues.length, " issues"]
              }), /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
                className: "ao-subcategory-arrow ".concat(detailedIssues[level] ? 'ao-subcategory-arrow--expanded' : ''),
                viewBox: "0 0 24 24",
                fill: "currentColor",
                children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
                  d: "M14 5l7 7-7 7V5z"
                })
              })]
            })]
          }, level);
        }), ['A', 'AA', 'AAA'].map(function (level) {
          var levelIssues = accessibilityIssues.filter(function (issue) {
            return issue.level === level;
          });
          if (levelIssues.length === 0 || !detailedIssues[level]) return null;
          return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
            className: "ao-issues-container",
            children: [/*#__PURE__*/jsxRuntimeExports.jsxs("h4", {
              className: "ao-issues-heading",
              children: ["Level ", level, " Issues"]
            }), levelIssues.map(function (issue, index) {
              return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                className: "ao-issue",
                children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                  className: "ao-issue-header",
                  children: [/*#__PURE__*/jsxRuntimeExports.jsx(GenericWarningIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("div", {
                    className: "ao-issue-title",
                    children: issue.friendly_name || issue.name
                  })]
                }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                  className: "ao-issue-content",
                  children: [issue.description && issue.description !== 'N/A' && /*#__PURE__*/jsxRuntimeExports.jsx("p", {
                    className: "ao-issue-description",
                    children: issue.description
                  }), issue.error_source_code && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
                    className: "ao-issue-code",
                    children: issue.error_source_code
                  }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                    className: "ao-issue-meta",
                    children: [/*#__PURE__*/jsxRuntimeExports.jsx("span", {
                      className: "ao-issue-meta-label",
                      children: "Impact:"
                    }), " ", issue.impact || 'Unknown', issue.tags && issue.tags.length > 0 && /*#__PURE__*/jsxRuntimeExports.jsxs("span", {
                      style: {
                        marginLeft: '15px'
                      },
                      children: [/*#__PURE__*/jsxRuntimeExports.jsx("span", {
                        className: "ao-issue-meta-label",
                        children: "Affects:"
                      }), " ", issue.tags.join(', ')]
                    })]
                  })]
                })]
              }, index);
            })]
          }, "".concat(level, "-details"));
        })]
      })]
    });
  };

  var SEOSection = function SEOSection(_ref) {
    var seoIssues = _ref.seoIssues,
      seoCount = _ref.seoCount,
      toggleSection = _ref.toggleSection,
      expandedSections = _ref.expandedSections,
      detailedIssues = _ref.detailedIssues,
      showSeoIssuesForCategory = _ref.showSeoIssuesForCategory;
    if (!seoIssues || seoIssues.length === 0) {
      return null;
    }
    return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
      className: "ao-category-section",
      children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-category-header",
        onClick: function onClick() {
          return toggleSection('seo');
        },
        children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-category-title",
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(SeoIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("h3", {
            className: "ao-category-name",
            children: "SEO"
          })]
        }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-category-count",
          children: [seoCount > 0 ? /*#__PURE__*/jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, {
            children: [/*#__PURE__*/jsxRuntimeExports.jsx(GenericWarningIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("span", {
              className: "ao-count-number ao-count-number--error",
              children: seoCount
            })]
          }) : /*#__PURE__*/jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, {
            children: [/*#__PURE__*/jsxRuntimeExports.jsx(GenericCheckIcon, {}), /*#__PURE__*/jsxRuntimeExports.jsx("span", {
              className: "ao-count-number ao-count-number--success",
              children: "0"
            })]
          }), /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
            className: "ao-category-arrow ".concat(expandedSections.seo ? 'ao-category-arrow--expanded' : ''),
            viewBox: "0 0 24 24",
            fill: "#333",
            children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
              d: "M7 10L12 15L17 10H7Z"
            })
          })]
        })]
      }), expandedSections.seo && seoIssues.length > 0 && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
        className: "ao-category-content",
        children: /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          style: {
            padding: '10px 0',
            width: '100%'
          },
          children: [/*#__PURE__*/jsxRuntimeExports.jsx("div", {
            style: {
              fontSize: '15px',
              fontWeight: '500',
              marginBottom: '8px',
              color: '#333'
            },
            children: "SEO Opportunities"
          }), /*#__PURE__*/jsxRuntimeExports.jsx("div", {
            style: {
              marginTop: '12px',
              width: '100%'
            },
            children: function () {
              // Group issues by the processed category field
              var categorizedIssues = {
                high: [],
                medium: [],
                low: [],
                technical: []
              };

              // Count issues in each category using the processed category field
              seoIssues.forEach(function (issue) {
                var category = issue.category || 'low'; // Use processed category
                categorizedIssues[category].push(issue);
              });

              // Define icons and labels for each category
              var categoryConfig = {
                high: {
                  label: 'High impact SEO Opportunities',
                  icon: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
                    d: "M16 6l2.29 2.29-4.88 4.88-4-4L2 16.59 3.41 18l6-6 4 4 6.3-6.29L22 12V6h-6z"
                  })
                },
                medium: {
                  label: 'Medium impact SEO Opportunities',
                  icon: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
                    d: "M16 6l2.29 2.29-4.88 4.88-4-4L2 16.59 3.41 18l6-6 4 4 6.3-6.29L22 12V6h-6z"
                  })
                },
                low: {
                  label: 'Low impact SEO Opportunities',
                  icon: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
                    d: "M6 16l-1.41-1.41 4.59-4.59 4 4L20 7.13l1.4 1.41L13.4 16z"
                  })
                },
                technical: {
                  label: 'Technical SEO Opportunities',
                  icon: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
                    d: "M15.5 1h-8C6.12 1 5 2.12 5 3.5v17C5 21.88 6.12 23 7.5 23h8c1.38 0 2.5-1.12 2.5-2.5v-17C18 2.12 16.88 1 15.5 1zm-4 21c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5-4H7V4h9v14z"
                  })
                }
              };

              // Use our comprehensive SEO issues mapping

              return /*#__PURE__*/jsxRuntimeExports.jsx(jsxRuntimeExports.Fragment, {
                children: Object.keys(categorizedIssues).map(function (category) {
                  return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                    children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                      className: "ao-seo-category",
                      onClick: categorizedIssues[category].length > 0 ? function (e) {
                        return showSeoIssuesForCategory(category, e);
                      } : undefined,
                      children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                        className: "ao-seo-category-label",
                        children: [/*#__PURE__*/jsxRuntimeExports.jsx("svg", {
                          className: "ao-seo-category-icon",
                          viewBox: "0 0 24 24",
                          fill: "currentColor",
                          children: categoryConfig[category].icon
                        }), categoryConfig[category].label]
                      }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                        style: {
                          display: 'flex',
                          alignItems: 'center',
                          pointerEvents: 'none'
                        },
                        children: [/*#__PURE__*/jsxRuntimeExports.jsx("span", {
                          children: categorizedIssues[category].length
                        }), categorizedIssues[category].length > 0 && /*#__PURE__*/jsxRuntimeExports.jsx("svg", {
                          style: {
                            width: '18px',
                            height: '18px',
                            marginLeft: '6px',
                            transform: detailedIssues[category] ? 'rotate(90deg)' : 'none',
                            transition: 'transform 0.3s ease'
                          },
                          viewBox: "0 0 24 24",
                          fill: "#333",
                          children: /*#__PURE__*/jsxRuntimeExports.jsx("path", {
                            d: "M14 5l7 7-7 7V5z"
                          })
                        })]
                      })]
                    }), detailedIssues[category] && categorizedIssues[category].length > 0 && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
                      className: "ao-issues-container",
                      children: categorizedIssues[category].map(function (issue, index) {
                        return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                          className: "ao-issue",
                          children: [/*#__PURE__*/jsxRuntimeExports.jsx("div", {
                            className: "ao-issue-header",
                            children: /*#__PURE__*/jsxRuntimeExports.jsx("div", {
                              className: "ao-seo-issue-badge ao-seo-issue-badge--".concat(category),
                              children: category.charAt(0).toUpperCase() + category.slice(1)
                            })
                          }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
                            className: "ao-issue-content",
                            children: [/*#__PURE__*/jsxRuntimeExports.jsx("div", {
                              className: "ao-issue-title",
                              children: issue.friendly_name || issue.name
                            }), /*#__PURE__*/jsxRuntimeExports.jsx("div", {
                              className: "ao-issue-description",
                              children: issue.description || 'Addressing this issue will improve your search engine ranking.'
                            })]
                          })]
                        }, index);
                      })
                    })]
                  }, category);
                })
              });
            }()
          })]
        })
      })]
    });
  };

  var ResultsView = function ResultsView(_ref) {
    var scanResults = _ref.scanResults,
      startQuickScan = _ref.startQuickScan,
      canScan = _ref.canScan,
      canConfigure = _ref.canConfigure,
      expandedSections = _ref.expandedSections,
      toggleSection = _ref.toggleSection,
      detailedIssues = _ref.detailedIssues,
      showIssuesForLevel = _ref.showIssuesForLevel,
      showSeoIssuesForCategory = _ref.showSeoIssuesForCategory,
      apiError = _ref.apiError;
    // Enhanced error rendering with API service error handling
    var renderApiError = function renderApiError(error) {
      var _getDrupalSettings = getDrupalSettings(),
        imgSrc = _getDrupalSettings.imgSrc;
      var imgPath = imgSrc.replace(/\/[^\/]*$/, '');
      var errorMessage = 'An error occurred during the scan.';
      var statusCode = null;
      var isRetryable = false;
      var showSettingsLink = false;

      // Handle different error types
      if (error instanceof ApiError) {
        errorMessage = error.message;
        statusCode = error.statusCode;
        isRetryable = error.isRetryable;

        // Show settings link for authentication errors
        showSettingsLink = statusCode === 401 || statusCode === 403;
      } else if (_typeof(error) === 'object' && error !== null) {
        // Handle scan result error objects
        errorMessage = error.failure_reason || error.message || error.error_message || error.error || errorMessage;

        // Extract status code if available
        if (error.status_code || error.statusCode) {
          statusCode = error.status_code || error.statusCode;
          errorMessage = getErrorMessage(statusCode, errorMessage);
          isRetryable = isRetryableError(statusCode);
          showSettingsLink = statusCode === 401 || statusCode === 403;
        }

        // Special handling for token/authentication errors
        if (errorMessage.includes('token must be passed') || errorMessage.includes('Authentication failed')) {
          statusCode = 401;
          errorMessage = getErrorMessage(401);
          showSettingsLink = true;
          isRetryable = false;
        }
      } else if (typeof error === 'string') {
        errorMessage = error;
      }

      // Special UI for authentication errors
      if (showSettingsLink) {
        return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          style: {
            padding: '20px',
            textAlign: 'center',
            backgroundColor: '#ffeeee',
            borderRadius: '8px',
            color: '#cc0000',
            border: '1px solid #ffcccc'
          },
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(AcquiaOptimizeLogo, {
            OptimizeLogo: "".concat(imgPath, "/error.svg"),
            alt: "Authentication Error",
            className: "ao-scan"
          }), /*#__PURE__*/jsxRuntimeExports.jsx("h3", {
            style: {
              margin: '15px 0 10px 0',
              color: '#cc0000'
            },
            children: "Authentication Failed"
          }), /*#__PURE__*/jsxRuntimeExports.jsx("p", {
            style: {
              margin: '10px 0'
            },
            children: errorMessage
          }), statusCode && /*#__PURE__*/jsxRuntimeExports.jsxs("p", {
            style: {
              fontSize: '0.9em',
              color: '#666',
              margin: '5px 0'
            },
            children: ["Error Code: ", statusCode]
          }), /*#__PURE__*/jsxRuntimeExports.jsx("p", {
            style: {
              marginTop: '15px'
            },
            children: /*#__PURE__*/jsxRuntimeExports.jsx("a", {
              href: "/admin/config/content/acquia-optimize",
              target: "_blank",
              rel: "noopener noreferrer",
              style: {
                color: '#0078ff',
                textDecoration: 'none',
                fontWeight: '500',
                padding: '8px 16px',
                border: '1px solid #0078ff',
                borderRadius: '4px',
                display: 'inline-block'
              },
              children: "Go to Settings Page"
            })
          })]
        });
      }

      // General error display
      return /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-message ao-message--error",
        style: {
          margin: '20px 0',
          padding: '20px',
          display: 'flex',
          flexDirection: 'column',
          alignItems: 'center',
          gap: '15px',
          width: '100%',
          border: '1px solid #ffcccc',
          borderRadius: '8px'
        },
        children: [/*#__PURE__*/jsxRuntimeExports.jsx(AcquiaOptimizeLogo, {
          OptimizeLogo: "".concat(imgPath, "/error.svg"),
          alt: "Scan Error",
          className: "ao-scan"
        }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          style: {
            textAlign: 'center'
          },
          children: [/*#__PURE__*/jsxRuntimeExports.jsx("h3", {
            style: {
              margin: '0 0 10px 0',
              color: '#cc0000'
            },
            children: isRetryable ? 'Temporary Error' : 'Scan Failed'
          }), /*#__PURE__*/jsxRuntimeExports.jsx("p", {
            style: {
              margin: '10px 0',
              fontSize: '16px'
            },
            children: errorMessage
          }), statusCode && /*#__PURE__*/jsxRuntimeExports.jsxs("p", {
            style: {
              fontSize: '0.9em',
              color: '#666',
              margin: '5px 0'
            },
            children: ["Error Code: ", statusCode]
          }), isRetryable && /*#__PURE__*/jsxRuntimeExports.jsx("p", {
            style: {
              fontSize: '0.9em',
              color: '#666',
              margin: '10px 0'
            },
            children: "This appears to be a temporary issue. Please try again."
          })]
        }), (canScan || canConfigure) && /*#__PURE__*/jsxRuntimeExports.jsxs(Button, {
          onClick: startQuickScan,
          disabled: !canScan && !canConfigure,
          className: "ao-button ao-button--icon",
          style: {
            backgroundColor: isRetryable ? '#28a745' : '#6c757d',
            borderColor: isRetryable ? '#28a745' : '#6c757d'
          },
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(RetryIcon, {}), isRetryable ? 'Try Again' : 'Retry Scan']
        })]
      });
    };

    // Parse and display scan results based on the provided screenshots
    var renderResults = function renderResults() {
      // Handle API errors from parent component (e.g., scan status check errors)
      if (apiError) {
        return renderApiError(apiError);
      }
      if (!scanResults) {
        return /*#__PURE__*/jsxRuntimeExports.jsx("div", {
          style: {
            padding: '20px',
            textAlign: 'center'
          },
          children: "No results to display."
        });
      }

      // Handle failed scans with enhanced error handling
      if (scanResults.status === 'failed' || scanResults.error) {
        return renderApiError(scanResults);
      }

      // Process accessibility issues
      var accessibilityIssues = scanResults.accessibility_errors || [];
      var accessibilityCount = accessibilityIssues.length;

      // Process SEO issues
      var seoIssues = scanResults.seo_issues || [];
      var seoCount = seoIssues.length;

      // Process data privacy issues
      var dataPrivacyIssues = scanResults.data_protection_violations || [];

      // Determine total issues count
      var totalIssues = accessibilityCount + seoCount + dataPrivacyIssues.length;

      // Scan result overall summary
      return /*#__PURE__*/jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, {
        children: [/*#__PURE__*/jsxRuntimeExports.jsx(ResultsHeader, {
          totalIssues: totalIssues,
          startQuickScan: startQuickScan,
          canScan: canScan,
          canConfigure: canConfigure
        }), /*#__PURE__*/jsxRuntimeExports.jsx(AccessibilitySection, {
          accessibilityIssues: accessibilityIssues,
          accessibilityCount: accessibilityCount,
          toggleSection: toggleSection,
          expandedSections: expandedSections,
          detailedIssues: detailedIssues,
          showIssuesForLevel: showIssuesForLevel
        }), /*#__PURE__*/jsxRuntimeExports.jsx(ReadabilitySection, {
          readabilityData: scanResults.readability_data,
          toggleSection: toggleSection,
          expandedSections: expandedSections
        }), /*#__PURE__*/jsxRuntimeExports.jsx(SEOSection, {
          seoIssues: seoIssues,
          seoCount: seoCount,
          toggleSection: toggleSection,
          expandedSections: expandedSections,
          detailedIssues: detailedIssues,
          showSeoIssuesForCategory: showSeoIssuesForCategory
        }), /*#__PURE__*/jsxRuntimeExports.jsx(DataPrivacySection, {
          expandedSections: expandedSections,
          toggleSection: toggleSection,
          dataPrivacyIssues: dataPrivacyIssues
        })]
      });
    };
    return /*#__PURE__*/jsxRuntimeExports.jsx("div", {
      className: "ao-container",
      children: /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-results-container",
        children: [renderResults(), /*#__PURE__*/jsxRuntimeExports.jsx(Footer, {
          AcquiaDocs: true
        })]
      })
    });
  };

  var _getDrupalSettings$1 = getDrupalSettings(),
    imgSrc$1 = _getDrupalSettings$1.imgSrc;
  var InitialView = function InitialView(_ref) {
    var _window;
    var canConfigure = _ref.canConfigure,
      setShowApiKeyForm = _ref.setShowApiKeyForm;
    // Debug mode can be set based on environment or settings
    ((_window = window) === null || _window === void 0 || (_window = _window.drupalSettings) === null || _window === void 0 || (_window = _window.xbExtension) === null || _window === void 0 || (_window = _window.acquiaOptimize) === null || _window === void 0 ? void 0 : _window.debug);

    // User does not have permission to configure
    if (!canConfigure) {
      return /*#__PURE__*/jsxRuntimeExports.jsx("div", {
        className: "ao-container",
        children: /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          className: "ao-inner-container",
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(AcquiaOptimizeLogo, {
            OptimizeLogo: "".concat(imgSrc$1)
          }), /*#__PURE__*/jsxRuntimeExports.jsx("h2", {
            className: "ao-heading",
            children: "Acquia Optimize"
          }), /*#__PURE__*/jsxRuntimeExports.jsx("div", {
            className: "ao-message ao-message--error",
            children: "You do not have permission to configure API settings."
          }), /*#__PURE__*/jsxRuntimeExports.jsx("div", {
            style: {
              display: 'flex',
              flexDirection: 'column',
              justifyContent: 'center',
              alignItems: 'center',
              gap: '16px',
              width: '100%',
              marginTop: '15px'
            },
            children: /*#__PURE__*/jsxRuntimeExports.jsx(Button, {
              style: {
                backgroundColor: 'white',
                color: 'var(--ao-primary-blue)',
                border: '2px solid var(--ao-primary-blue)',
                maxWidth: '400px',
                width: '100%'
              },
              onClick: function onClick() {
                // Handle registration for free scan
                window.open('https://docs.acquia.com/acquia-optimize', '_blank');
              },
              children: "Learn more about Acquia Optimize"
            })
          })]
        })
      });
    }

    // User has permission to add API key
    return /*#__PURE__*/jsxRuntimeExports.jsx("div", {
      className: "ao-container",
      children: /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
        className: "ao-inner-container",
        style: {
          maxWidth: '400px'
        },
        children: [/*#__PURE__*/jsxRuntimeExports.jsx(Button, {
          onClick: function onClick() {
            return setShowApiKeyForm(true);
          },
          children: /*#__PURE__*/jsxRuntimeExports.jsx("span", {
            style: {
              fontSize: '14px'
            },
            children: "\u26A1 Enter API Key"
          })
        }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
          style: {
            display: 'flex',
            flexDirection: 'column',
            justifyContent: 'center',
            alignItems: 'center',
            gap: '16px',
            width: '100%',
            marginTop: '15px'
          },
          children: [/*#__PURE__*/jsxRuntimeExports.jsx(Button, {
            style: {
              backgroundColor: 'white',
              color: 'var(--ao-dark-blue)',
              border: '1px solid rgba(0, 132, 230, 0.63)',
              fontSize: '14px'
            },
            onClick: function onClick() {
              window.open('https://docs.acquia.com/acquia-optimize', '_blank');
            },
            children: "Register for a free scan"
          }), /*#__PURE__*/jsxRuntimeExports.jsx(Footer, {})]
        })]
      })
    });
  };

  var _excluded = ["api_key", "general"],
    _excluded2 = ["api_url", "general"];
  var ApiKeyFormView = function ApiKeyFormView(_ref) {
    var apiKey = _ref.apiKey,
      setApiKey = _ref.setApiKey,
      apiUrl = _ref.apiUrl,
      setApiUrl = _ref.setApiUrl,
      accessibilityGuideline = _ref.accessibilityGuideline,
      setAccessibilityGuideline = _ref.setAccessibilityGuideline,
      handleSubmit = _ref.handleSubmit,
      isLoading = _ref.isLoading,
      setShowApiKeyForm = _ref.setShowApiKeyForm,
      helperText = _ref.helperText,
      canConfigure = _ref.canConfigure;
    var _useState = ReactOriginal.useState({}),
      _useState2 = _slicedToArray(_useState, 2),
      errors = _useState2[0],
      setErrors = _useState2[1];
    var _useState3 = ReactOriginal.useState({}),
      _useState4 = _slicedToArray(_useState3, 2),
      touched = _useState4[0],
      setTouched = _useState4[1];
    var _useState5 = ReactOriginal.useState({}),
      _useState6 = _slicedToArray(_useState5, 2),
      apiErrors = _useState6[0],
      setApiErrors = _useState6[1];
    var _useState7 = ReactOriginal.useState(false),
      _useState8 = _slicedToArray(_useState7, 2),
      isSubmitting = _useState8[0],
      setIsSubmitting = _useState8[1];
    var _useState9 = ReactOriginal.useState(false),
      _useState10 = _slicedToArray(_useState9, 2),
      isValidatingConnection = _useState10[0],
      setIsValidatingConnection = _useState10[1];

    // Initialize API service
    var _useApiService = useApiService(),
      validateApiConnection = _useApiService.validateApiConnection;

    // Validation functions
    var validateApiKey = function validateApiKey(value) {
      if (!value || !value.trim()) {
        return 'API key is required';
      }
      if (value.length < 20) {
        return 'API Key appears to be too short. Please check your API key.';
      }

      // Check for suspicious characters that might indicate copy-paste errors
      if (/[<>"'\s]/.test(value)) {
        return 'API Key contains invalid characters. Please ensure you copied the key correctly.';
      }
      return null;
    };
    var validateApiUrl = function validateApiUrl(value) {
      if (!value || !value.trim()) {
        return 'API URL is required';
      }

      // Basic URL validation
      try {
        var url = new URL(value);
        if (!['http:', 'https:'].includes(url.protocol)) {
          return 'API URL must use HTTP or HTTPS protocol';
        }
      } catch (_unused) {
        return 'Please enter a valid URL (e.g., https://api.example.com/v1)';
      }
      return null;
    };

    // Field change handlers with validation
    var handleApiKeyChange = function handleApiKeyChange(e) {
      var value = e.target.value;
      setApiKey(value);

      // Clear both validation and API errors when user starts typing
      if (apiErrors.api_key || apiErrors.general) {
        setApiErrors(function (prev) {
          prev.api_key;
            prev.general;
            var rest = _objectWithoutProperties(prev, _excluded);
          return rest;
        });
      }

      // Also clear validation errors for this field
      if (errors.api_key) {
        setErrors(function (prev) {
          return _objectSpread2(_objectSpread2({}, prev), {}, {
            api_key: null
          });
        });
      }
      if (touched.api_key) {
        var error = validateApiKey(value);
        setErrors(function (prev) {
          return _objectSpread2(_objectSpread2({}, prev), {}, {
            api_key: error
          });
        });
      }
    };
    var handleApiUrlChange = function handleApiUrlChange(e) {
      var value = e.target.value;
      setApiUrl(value);

      // Clear both validation and API errors when user starts typing
      if (apiErrors.api_url || apiErrors.general) {
        setApiErrors(function (prev) {
          prev.api_url;
            prev.general;
            var rest = _objectWithoutProperties(prev, _excluded2);
          return rest;
        });
      }

      // Also clear validation errors for this field
      if (errors.api_url) {
        setErrors(function (prev) {
          return _objectSpread2(_objectSpread2({}, prev), {}, {
            api_url: null
          });
        });
      }
      if (touched.api_url) {
        var error = validateApiUrl(value);
        setErrors(function (prev) {
          return _objectSpread2(_objectSpread2({}, prev), {}, {
            api_url: error
          });
        });
      }
    };

    // Field blur handlers
    var handleFieldBlur = function handleFieldBlur(fieldName, value) {
      setTouched(function (prev) {
        return _objectSpread2(_objectSpread2({}, prev), {}, _defineProperty({}, fieldName, true));
      });
      var error = null;
      if (fieldName === 'api_key') {
        error = validateApiKey(value);
      } else if (fieldName === 'api_url') {
        error = validateApiUrl(value);
      }
      setErrors(function (prev) {
        return _objectSpread2(_objectSpread2({}, prev), {}, _defineProperty({}, fieldName, error));
      });
    };

    // Helper function to get the combined error for a field
    var getFieldError = function getFieldError(fieldName) {
      return errors[fieldName] || apiErrors[fieldName] || null;
    };

    // Helper function to check if field has any error
    var hasFieldError = function hasFieldError(fieldName) {
      return !!(errors[fieldName] || apiErrors[fieldName]);
    };

    // Helper function to check if form can be submitted
    var isFormValid = function isFormValid() {
      var hasValidationErrors = Object.values(errors).some(function (error) {
        return error !== null;
      });
      var hasApiErrors = Object.values(apiErrors).some(function (error) {
        return error !== null;
      });
      var isValid = !hasValidationErrors && !hasApiErrors && !isSubmitting && !isValidatingConnection;
      return isValid;
    };

    // Helper function to clear all errors
    var clearAllErrors = function clearAllErrors() {
      setErrors({});
      setApiErrors({});
    };
    var handleFormSubmit = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator(/*#__PURE__*/_regeneratorRuntime().mark(function _callee(e) {
        var apiKeyError, apiUrlError, newErrors, hasValidationErrors, firstErrorField, element, connectionResult, connectionErrors, _firstErrorField, _element, fieldErrors, _firstErrorField2, _element2, errorMessage, targetField, _element3, _errorMessage, _targetField, msg, _element4, _fieldErrors, _firstErrorField3, _element5;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              e.preventDefault();

              // Prevent double submission
              if (!(isSubmitting || isValidatingConnection)) {
                _context.next = 3;
                break;
              }
              return _context.abrupt("return");
            case 3:
              // Clear all previous errors at the start
              clearAllErrors();
              setIsSubmitting(true);
              _context.prev = 5;
              // Validate all fields first
              apiKeyError = validateApiKey(apiKey);
              apiUrlError = validateApiUrl(apiUrl);
              newErrors = {
                api_key: apiKeyError,
                api_url: apiUrlError
              };
              setErrors(newErrors);
              setTouched({
                api_key: true,
                api_url: true
              });

              // Check if there are any validation errors
              hasValidationErrors = Object.values(newErrors).some(function (error) {
                return error !== null;
              });
              if (!hasValidationErrors) {
                _context.next = 16;
                break;
              }
              // Focus first field with error
              firstErrorField = Object.keys(newErrors).find(function (key) {
                return newErrors[key];
              });
              if (firstErrorField) {
                element = document.getElementById(firstErrorField);
                if (element) {
                  element.focus();
                  element.scrollIntoView({
                    behavior: 'smooth',
                    block: 'center'
                  });
                }
              }
              return _context.abrupt("return");
            case 16:
              // Validate API connection before submitting the form
              setIsValidatingConnection(true);
              _context.prev = 17;
              _context.next = 20;
              return validateApiConnection(apiKey, apiUrl);
            case 20:
              connectionResult = _context.sent;
              if (!(connectionResult.status && connectionResult.status !== 200)) {
                _context.next = 28;
                break;
              }
              // Map API connection errors to form fields
              connectionErrors = {};
              if (connectionResult.status === 401) {
                connectionErrors.api_key = 'Invalid API key. Please check your credentials.';
              } else if (connectionResult.status === 403 || connectionResult.status === 422) {
                connectionErrors.api_key = 'Access denied. Please verify your API key and permissions.';
              } else if (connectionResult.status === 400) {
                // Check if it's a URL-related error
                if (connectionResult.error && (connectionResult.error.includes('URL') || connectionResult.error.includes('connect') || connectionResult.error.includes('resolve host') || connectionResult.error.includes('accessible'))) {
                  connectionErrors.api_url = connectionResult.error;
                } else {
                  connectionErrors.api_key = connectionResult.error || 'Invalid API key. Please check your credentials.';
                }
              } else if (connectionResult.status === 404) {
                connectionErrors.api_url = 'API endpoint not found. Please verify the API URL.';
              } else if (connectionResult.status === 408) {
                connectionErrors.general = 'Connection timeout. Please check your network connection and try again.';
              } else if (connectionResult.status === 0) {
                // Network error
                connectionErrors.general = 'Unable to connect to the API. Please check your network connection and API URL.';
              } else {
                connectionErrors.general = connectionResult.error || 'Failed to connect to the API. Please try again.';
              }
              setApiErrors(connectionErrors);

              // Focus the first field with an error (prefer field-specific errors over general)
              _firstErrorField = Object.keys(connectionErrors).find(function (key) {
                return connectionErrors[key] && key !== 'general';
              });
              if (_firstErrorField) {
                _element = document.getElementById(_firstErrorField);
                if (_element) {
                  _element.focus();
                  _element.scrollIntoView({
                    behavior: 'smooth',
                    block: 'center'
                  });
                }
              }
              return _context.abrupt("return");
            case 28:
              _context.next = 30;
              return handleSubmit(e);
            case 30:
              _context.next = 37;
              break;
            case 32:
              _context.prev = 32;
              _context.t0 = _context["catch"](17);
              // Handle API connection validation errors
              console.error('API connection validation error:', _context.t0);
              if (_context.t0 instanceof ApiError) {
                fieldErrors = _context.t0.getFieldErrors();
                if (Object.keys(fieldErrors).length > 0) {
                  setApiErrors(fieldErrors);

                  // Focus the first field with an error
                  _firstErrorField2 = Object.keys(fieldErrors)[0];
                  _element2 = document.getElementById(_firstErrorField2);
                  if (_element2) {
                    _element2.focus();
                    _element2.scrollIntoView({
                      behavior: 'smooth',
                      block: 'center'
                    });
                  }
                } else {
                  // Check if it's a network-related error
                  errorMessage = _context.t0.message;
                  targetField = 'general';
                  if (errorMessage.includes('URL') || errorMessage.includes('connect') || errorMessage.includes('resolve') || errorMessage.includes('Network error')) {
                    targetField = 'api_url';
                    errorMessage = 'Unable to connect to the API URL. Please verify the URL is correct and accessible.';
                  }
                  setApiErrors(_defineProperty({}, targetField, errorMessage));
                  if (targetField !== 'general') {
                    _element3 = document.getElementById(targetField);
                    if (_element3) {
                      _element3.focus();
                      _element3.scrollIntoView({
                        behavior: 'smooth',
                        block: 'center'
                      });
                    }
                  }
                }
              } else {
                // Handle non-ApiError exceptions
                _errorMessage = 'Failed to validate API connection. Please try again.';
                _targetField = 'general';
                if (_context.t0.message) {
                  msg = _context.t0.message.toLowerCase();
                  if (msg.includes('url') || msg.includes('connect') || msg.includes('resolve') || msg.includes('network')) {
                    _targetField = 'api_url';
                    _errorMessage = 'Unable to connect to the API URL. Please verify the URL is correct and accessible.';
                  }
                }
                setApiErrors(_defineProperty({}, _targetField, _errorMessage));
                if (_targetField !== 'general') {
                  _element4 = document.getElementById(_targetField);
                  if (_element4) {
                    _element4.focus();
                    _element4.scrollIntoView({
                      behavior: 'smooth',
                      block: 'center'
                    });
                  }
                }
              }
              return _context.abrupt("return");
            case 37:
              _context.prev = 37;
              setIsValidatingConnection(false);
              return _context.finish(37);
            case 40:
              _context.next = 45;
              break;
            case 42:
              _context.prev = 42;
              _context.t1 = _context["catch"](5);
              // Handle other form submission errors
              if (_context.t1 instanceof ApiError) {
                _fieldErrors = _context.t1.getFieldErrors();
                if (Object.keys(_fieldErrors).length > 0) {
                  // Set field-specific errors
                  setApiErrors(_fieldErrors);

                  // Focus the first field with an error
                  _firstErrorField3 = Object.keys(_fieldErrors)[0];
                  _element5 = document.getElementById(_firstErrorField3);
                  if (_element5) {
                    _element5.focus();
                    _element5.scrollIntoView({
                      behavior: 'smooth',
                      block: 'center'
                    });
                  }
                } else {
                  // Set general API error message
                  setApiErrors({
                    general: _context.t1.message
                  });
                }

                // Log error details for debugging
                console.error('API Error:', _context.t1.getErrorDetails());
              } else {
                // Handle non-API errors
                setApiErrors({
                  general: 'An unexpected error occurred. Please try again.'
                });
                console.error('Form submission error:', _context.t1);
              }
            case 45:
              _context.prev = 45;
              setIsSubmitting(false);
              setIsValidatingConnection(false);
              return _context.finish(45);
            case 49:
            case "end":
              return _context.stop();
          }
        }, _callee, null, [[5, 42, 45, 49], [17, 32, 37, 40]]);
      }));
      return function handleFormSubmit(_x) {
        return _ref2.apply(this, arguments);
      };
    }();
    // API Key configuration form - only shown if user has permission to configure
    if (!canConfigure) {
      return /*#__PURE__*/jsxRuntimeExports.jsx("div", {
        className: "ao-container",
        children: /*#__PURE__*/jsxRuntimeExports.jsx("div", {
          className: "ao-message ao-message--error",
          children: "You do not have permission to configure API settings."
        })
      });
    }
    return /*#__PURE__*/jsxRuntimeExports.jsx("div", {
      className: "ao-container",
      children: /*#__PURE__*/jsxRuntimeExports.jsx("div", {
        className: "ao-inner-container",
        children: /*#__PURE__*/jsxRuntimeExports.jsxs("form", {
          onSubmit: handleFormSubmit,
          className: "ao-form",
          noValidate: true,
          children: [/*#__PURE__*/jsxRuntimeExports.jsxs("div", {
            className: "ao-form-group",
            children: [/*#__PURE__*/jsxRuntimeExports.jsxs("label", {
              htmlFor: "api_key",
              className: "ao-label",
              children: ["API key ", /*#__PURE__*/jsxRuntimeExports.jsx("span", {
                className: "ao-required",
                children: "*"
              }), /*#__PURE__*/jsxRuntimeExports.jsx("span", {
                className: "ao-info",
                "data-tooltip": "Enter your Acquia Optimize API key provided in your account dashboard",
                children: "\u24D8"
              })]
            }), /*#__PURE__*/jsxRuntimeExports.jsx("textarea", {
              id: "api_key",
              value: apiKey,
              onChange: handleApiKeyChange,
              onBlur: function onBlur(e) {
                return handleFieldBlur('api_key', e.target.value);
              },
              placeholder: "Enter API key here",
              required: true,
              className: "ao-textarea ".concat(hasFieldError('api_key') ? 'ao-textarea--error' : ''),
              "aria-invalid": hasFieldError('api_key') ? 'true' : 'false',
              "aria-describedby": hasFieldError('api_key') ? 'api_key-error' : undefined
            }), hasFieldError('api_key') && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
              id: "api_key-error",
              className: "ao-error-message",
              role: "alert",
              children: getFieldError('api_key')
            })]
          }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
            className: "ao-form-group",
            children: [/*#__PURE__*/jsxRuntimeExports.jsxs("label", {
              htmlFor: "api_url",
              className: "ao-label",
              children: ["API URL ", /*#__PURE__*/jsxRuntimeExports.jsx("span", {
                className: "ao-required",
                children: "*"
              }), /*#__PURE__*/jsxRuntimeExports.jsx("span", {
                className: "ao-info",
                "data-tooltip": "Enter the URL endpoint for API calls (e.g., https://api.example.com/v1)",
                children: "\u24D8"
              })]
            }), /*#__PURE__*/jsxRuntimeExports.jsx("input", {
              id: "api_url",
              type: "text",
              value: apiUrl,
              onChange: handleApiUrlChange,
              onBlur: function onBlur(e) {
                return handleFieldBlur('api_url', e.target.value);
              },
              placeholder: "Enter API url here",
              required: true,
              className: "ao-input ".concat(hasFieldError('api_url') ? 'ao-input--error' : ''),
              "aria-invalid": hasFieldError('api_url') ? 'true' : 'false',
              "aria-describedby": hasFieldError('api_url') ? 'api_url-error' : undefined
            }), hasFieldError('api_url') && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
              id: "api_url-error",
              className: "ao-error-message",
              role: "alert",
              children: getFieldError('api_url')
            })]
          }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
            className: "ao-form-group",
            children: [/*#__PURE__*/jsxRuntimeExports.jsxs("label", {
              htmlFor: "accessibility",
              className: "ao-label",
              children: ["Accessibility Guideline ", /*#__PURE__*/jsxRuntimeExports.jsx("span", {
                className: "ao-required",
                children: "*"
              }), /*#__PURE__*/jsxRuntimeExports.jsx("span", {
                className: "ao-info",
                "data-tooltip": "Choose which WCAG accessibility standard to test against",
                children: "\u24D8"
              })]
            }), /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
              className: "ao-select-container",
              children: [/*#__PURE__*/jsxRuntimeExports.jsxs("select", {
                id: "accessibility",
                value: accessibilityGuideline,
                onChange: function onChange(e) {
                  return setAccessibilityGuideline(e.target.value);
                },
                required: true,
                className: "ao-select",
                children: [/*#__PURE__*/jsxRuntimeExports.jsx("option", {
                  value: "WCAG2-A",
                  children: "WCAG 2.0 A"
                }), /*#__PURE__*/jsxRuntimeExports.jsx("option", {
                  value: "WCAG2-AA",
                  children: "WCAG 2.0 AA"
                }), /*#__PURE__*/jsxRuntimeExports.jsx("option", {
                  value: "WCAG2-AAA",
                  children: "WCAG 2.0 AAA"
                }), /*#__PURE__*/jsxRuntimeExports.jsx("option", {
                  value: "WCAG21-A",
                  children: "WCAG 2.1 A"
                }), /*#__PURE__*/jsxRuntimeExports.jsx("option", {
                  value: "WCAG21-AA",
                  children: "WCAG 2.1 AA"
                }), /*#__PURE__*/jsxRuntimeExports.jsx("option", {
                  value: "WCAG21-AAA",
                  children: "WCAG 2.1 AAA"
                }), /*#__PURE__*/jsxRuntimeExports.jsx("option", {
                  value: "WCAG22-A",
                  children: "WCAG 2.2 A"
                }), /*#__PURE__*/jsxRuntimeExports.jsx("option", {
                  value: "WCAG22-AA",
                  children: "WCAG 2.2 AA"
                }), /*#__PURE__*/jsxRuntimeExports.jsx("option", {
                  value: "WCAG22-AAA",
                  children: "WCAG 2.2 AAA"
                })]
              }), /*#__PURE__*/jsxRuntimeExports.jsx("div", {
                className: "ao-select-arrow",
                children: "\u25BC"
              })]
            })]
          }), helperText && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
            className: "ao-message ".concat(helperText.includes('Error') ? 'ao-message--error' : 'ao-message--success'),
            children: helperText
          }), apiErrors.general && /*#__PURE__*/jsxRuntimeExports.jsx("div", {
            className: "ao-message ao-message--error",
            role: "alert",
            children: apiErrors.general
          }), isLoading || isSubmitting || isValidatingConnection ? /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
            className: "ao-loading-center",
            children: [/*#__PURE__*/jsxRuntimeExports.jsx("div", {
              className: "ao-spinner ao-spinner-form"
            }), isValidatingConnection && /*#__PURE__*/jsxRuntimeExports.jsx("p", {
              className: "ao-loading-text",
              children: "Validating API connection..."
            })]
          }) : /*#__PURE__*/jsxRuntimeExports.jsxs("div", {
            className: "ao-form-actions",
            children: [/*#__PURE__*/jsxRuntimeExports.jsx("button", {
              type: "button",
              onClick: function onClick() {
                return setShowApiKeyForm(false);
              },
              className: "ao-button-secondary",
              disabled: isSubmitting || isValidatingConnection,
              children: "Cancel"
            }), /*#__PURE__*/jsxRuntimeExports.jsx(Button, {
              type: "submit",
              disabled: !isFormValid(),
              children: isValidatingConnection ? 'Validating...' : isSubmitting ? 'Adding...' : 'Add'
            })]
          }), /*#__PURE__*/jsxRuntimeExports.jsx(Footer, {})]
        })
      })
    });
  };

  var ViewRenderer = function ViewRenderer(_ref) {
    var currentView = _ref.currentView,
      isInitialLoading = _ref.isInitialLoading,
      showApiKeyForm = _ref.showApiKeyForm,
      setShowApiKeyForm = _ref.setShowApiKeyForm,
      isLoading = _ref.isLoading,
      apiKey = _ref.apiKey,
      setApiKey = _ref.setApiKey,
      apiUrl = _ref.apiUrl,
      setApiUrl = _ref.setApiUrl,
      accessibilityGuideline = _ref.accessibilityGuideline,
      setAccessibilityGuideline = _ref.setAccessibilityGuideline,
      helperText = _ref.helperText,
      scanProgress = _ref.scanProgress,
      scanResults = _ref.scanResults,
      expandedSections = _ref.expandedSections,
      detailedIssues = _ref.detailedIssues,
      canConfigure = _ref.canConfigure,
      canScan = _ref.canScan,
      handleSubmit = _ref.handleSubmit,
      startQuickScan = _ref.startQuickScan,
      toggleSection = _ref.toggleSection,
      showIssuesForLevel = _ref.showIssuesForLevel,
      showSeoIssuesForCategory = _ref.showSeoIssuesForCategory;
    var renderInitialView = function renderInitialView() {
      return !showApiKeyForm ? /*#__PURE__*/jsxRuntimeExports.jsx(InitialView, {
        canConfigure: canConfigure,
        setShowApiKeyForm: setShowApiKeyForm
      }) : /*#__PURE__*/jsxRuntimeExports.jsx(ApiKeyFormView, {
        apiKey: apiKey,
        setApiKey: setApiKey,
        apiUrl: apiUrl,
        setApiUrl: setApiUrl,
        accessibilityGuideline: accessibilityGuideline,
        setAccessibilityGuideline: setAccessibilityGuideline,
        handleSubmit: handleSubmit,
        isLoading: isLoading,
        setShowApiKeyForm: setShowApiKeyForm,
        helperText: helperText,
        canConfigure: canConfigure
      });
    };
    // Show loading state while fetching initial data
    if (isInitialLoading) {
      return /*#__PURE__*/jsxRuntimeExports.jsx(LoadingView, {});
    }

    // Render different views based on currentView state
    switch (currentView) {
      case 'no-permission':
        return /*#__PURE__*/jsxRuntimeExports.jsx(NoPermissionView, {});
      case 'initial':
        return renderInitialView();
      case 'quick-scan':
        return /*#__PURE__*/jsxRuntimeExports.jsx(QuickScanView, {
          helperText: helperText,
          startQuickScan: startQuickScan,
          canScan: canScan,
          canConfigure: canConfigure
        });
      case 'scanning':
        return /*#__PURE__*/jsxRuntimeExports.jsx(ScanningView, {
          scanProgress: scanProgress
        });
      case 'results':
        return /*#__PURE__*/jsxRuntimeExports.jsx(ResultsView, {
          scanResults: scanResults,
          expandedSections: expandedSections,
          detailedIssues: detailedIssues,
          toggleSection: toggleSection,
          showIssuesForLevel: showIssuesForLevel,
          showSeoIssuesForCategory: showSeoIssuesForCategory,
          startQuickScan: startQuickScan,
          canScan: canScan,
          canConfigure: canConfigure
        });
      default:
        // If no valid view is specified, render the initial view.
        return renderInitialView();
    }
  };

  var _getDrupalSettings = getDrupalSettings(),
    imgSrc = _getDrupalSettings.imgSrc;
  var ConceptProver = function ConceptProver() {
    var conceptProverData = useConceptProverLogic();
    return /*#__PURE__*/jsxRuntimeExports.jsx(ViewRenderer, _objectSpread2(_objectSpread2({}, conceptProverData), {}, {
      imgSrc: "".concat(imgSrc, "logo.svg")
    }));
  };

  var EXTENSION_ID = 'acquia-optimize';
  var AcquiaOptimizeExtension = function AcquiaOptimizeExtension() {
    var _useState = ReactOriginal.useState(null),
      _useState2 = _slicedToArray(_useState, 2),
      portalRoot = _useState2[0],
      setPortalRoot = _useState2[1];

    // Get the currently active extension from the XB React app's Redux store.
    var activeExtension = useSelector(function (state) {
      return state.extensions.activeExtension;
    });
    ReactOriginal.useEffect(function () {
      if (activeExtension !== null && activeExtension !== void 0 && activeExtension.id) {
        // Wait for a tick here to ensure the div in the extension modal has been rendered so we can portal
        // our extension into it.
        requestAnimationFrame(function () {
          var targetDiv = document.querySelector("#extensionPortalContainer.xb-extension-".concat(activeExtension.id));
          if (targetDiv) {
            setPortalRoot(targetDiv);
          }
        });
      }
    }, [activeExtension]);

    // We don't want to render anything if the Extension is not active in the XB app.
    if ((activeExtension === null || activeExtension === void 0 ? void 0 : activeExtension.id) !== EXTENSION_ID || !portalRoot) {
      return null;
    }
    return /*#__PURE__*/require$$0__default["default"].createPortal(/*#__PURE__*/jsxRuntimeExports.jsx(ConceptProver, {}), portalRoot);
  };

  var _window = window,
    drupalSettings = _window.drupalSettings;
  var container = document.createElement('div');
  container.id = 'experience-builder-extension';
  document.body.append(container);
  var root = clientExports.createRoot(container);

  // The XB store is available in Drupal settings, making it possible to add it
  // to this App via a <Provider>, giving us access to its data and actions.
  var store = drupalSettings.xb.store;
  root.render(/*#__PURE__*/jsxRuntimeExports.jsx(Provider_default, {
    store: store,
    children: /*#__PURE__*/jsxRuntimeExports.jsx(AcquiaOptimizeExtension, {})
  }));

}));
