import React from 'react';
import { useConceptProverLogic } from './hooks/useConceptProverLogic';
import { ViewRenderer } from './ViewRenderer';
import { getDrupalSettings } from './utils/constants';

// Get the dynamic module path from xbExtension settings
const { imgSrc } = getDrupalSettings();

const ConceptProver = () => {
  const conceptProverData = useConceptProverLogic();

  return (
    <ViewRenderer
      {...conceptProverData}
      imgSrc={`${imgSrc}logo.svg`}
    />
  );
};

export default ConceptProver;
