import React from 'react';
import { ExternalLinkIcon } from './Icons';

const Footer = ({ AcquiaDocs = false }) => {
	const { drupalSettings } = window;
	const accountUrl = drupalSettings?.xbExtension?.acquiaOptimize?.accountUrl || 'https://new.monsido.com';
	const accountText = drupalSettings?.xbExtension?.acquiaOptimize?.accountText || 'Go to your Web Governance account';

	return (
		<div className="ao-footer">
			{AcquiaDocs && (
				<div className="ao-footer-text">
					Results are not synchronized to your Acquia Web Governance account.<br/>
					To learn more visit <a href="https://docs.acquia.com/acquia-optimize" target="_blank" rel="noopener noreferrer" className="ao-link">Acquia Docs <ExternalLinkIcon /></a>
				</div>
			)}

			<a
				href={accountUrl}
				target="_blank"
				rel="noopener noreferrer"
				className="ao-account-button"
			>
				{accountText} <ExternalLinkIcon />
			</a>
    </div>
	);
};

export default Footer;
