import React from 'react';
import LoadingView from './views/LoadingView';
import NoPermissionView from './views/NoPermissionView';
import QuickScanView from './views/QuickScanView';
import ScanningView from './views/ScanningView';
import ResultsView from './views/ResultsView';
import InitialView from './views/InitialView';
import ApiKeyFormView from './views/ApiKeyFormView';

export const ViewRenderer = ({
  currentView,
  isInitialLoading,
  // State props
  showApiKeyForm,
  setShowApiKeyForm,
  isLoading,
  apiKey,
  setApiKey,
  apiUrl,
  setApiUrl,
  accessibilityGuideline,
  setAccessibilityGuideline,
  helperText,
  scanProgress,
  scanResults,
  expandedSections,
  detailedIssues,
  canConfigure,
  canScan,
  // Handler props
  handleSubmit,
  startQuickScan,
  toggleSection,
  showIssuesForLevel,
  showSeoIssuesForCategory
}) => {
  const renderInitialView = () => {
    return !showApiKeyForm ? (
      <InitialView
        canConfigure={canConfigure}
        setShowApiKeyForm={setShowApiKeyForm}
      />
    ) : (
      <ApiKeyFormView
        apiKey={apiKey}
        setApiKey={setApiKey}
        apiUrl={apiUrl}
        setApiUrl={setApiUrl}
        accessibilityGuideline={accessibilityGuideline}
        setAccessibilityGuideline={setAccessibilityGuideline}
        handleSubmit={handleSubmit}
        isLoading={isLoading}
        setShowApiKeyForm={setShowApiKeyForm}
        helperText={helperText}
        canConfigure={canConfigure}
      />
    );
  }
  // Show loading state while fetching initial data
  if (isInitialLoading) {
    return <LoadingView />;
  }

  // Render different views based on currentView state
  switch (currentView) {
    case 'no-permission':
      return <NoPermissionView />;

    case 'initial':
      return renderInitialView();

    case 'quick-scan':
      return (
        <QuickScanView
          helperText={helperText}
          startQuickScan={startQuickScan}
          canScan={canScan}
          canConfigure={canConfigure}
        />
      );

    case 'scanning':
      return <ScanningView scanProgress={scanProgress} />;

    case 'results':
      return (
        <ResultsView
          scanResults={scanResults}
          expandedSections={expandedSections}
          detailedIssues={detailedIssues}
          toggleSection={toggleSection}
          showIssuesForLevel={showIssuesForLevel}
          showSeoIssuesForCategory={showSeoIssuesForCategory}
          startQuickScan={startQuickScan}
          canScan={canScan}
          canConfigure={canConfigure}
        />
      );

    default:
      // If no valid view is specified, render the initial view.
      return renderInitialView();
  }
};
