import { useState } from 'react';

export const useConceptProverState = () => {
  // Form and UI state
  const [showApiKeyForm, setShowApiKeyForm] = useState(false);
  const [isLoading, setIsLoading] = useState(false);
  const [apiKey, setApiKey] = useState('');
  const [apiUrl, setApiUrl] = useState('');
  const [accessibilityGuideline, setAccessibilityGuideline] = useState('WCAG21-AA');
  const [helperText, setHelperText] = useState('');
  const [currentView, setCurrentView] = useState('initial');
  const [csrfToken, setCsrfToken] = useState('');

  // Scan related state
  const [scanProgress, setScanProgress] = useState(0);
  const [scanResults, setScanResults] = useState(null);
  const [scanId, setScanId] = useState(null);

  // UI state
  const [isDebugMode, setIsDebugMode] = useState(true); // Temporarily enabled for debugging
  const [expandedSections, setExpandedSections] = useState({
    accessibility: false,
    readability: false,
    seo: false,
    dataPrivacy: false
  });

  const [detailedIssues, setDetailedIssues] = useState({
    A: false,
    AA: false,
    AAA: false,
    high: false,
    medium: false,
    low: false,
    technical: false
  });

  // Permission state
  const [canConfigure, setCanConfigure] = useState(false);
  const [canScan, setCanScan] = useState(false);
  const [isInitialLoading, setIsInitialLoading] = useState(true);

  return {
    // Form state
    showApiKeyForm, setShowApiKeyForm,
    isLoading, setIsLoading,
    apiKey, setApiKey,
    apiUrl, setApiUrl,
    accessibilityGuideline, setAccessibilityGuideline,
    helperText, setHelperText,
    currentView, setCurrentView,
    csrfToken, setCsrfToken,

    // Scan state
    scanProgress, setScanProgress,
    scanResults, setScanResults,
    scanId, setScanId,

    // UI state
    isDebugMode, setIsDebugMode,
    expandedSections, setExpandedSections,
    detailedIssues, setDetailedIssues,

    // Permission state
    canConfigure, setCanConfigure,
    canScan, setCanScan,
    isInitialLoading, setIsInitialLoading
  };
};
