import { GenericCheckIcon, DataPrivacyIcon, GenericWarningIcon } from '../Icons';

const DataPrivacySection = ({
  expandedSections,
  toggleSection,
  dataPrivacyIssues
}) => {
  const dataPrivacyCount = dataPrivacyIssues?.length || 0;
  return (
    <div className="ao-category-section">
      <div
        className="ao-category-header"
        onClick={() => toggleSection('dataPrivacy')}
      >
        <div className="ao-category-title">
          <DataPrivacyIcon />
          <h3 className="ao-category-name">Data Privacy</h3>
        </div>

        <div className="ao-category-count">
          {dataPrivacyCount > 0 ? (
            <>
              <GenericWarningIcon />
              <span className="ao-count-number ao-count-number--error">{dataPrivacyCount}</span>
            </>
          ) : (
            <>
              <GenericCheckIcon />
              <span className="ao-count-number ao-count-number--success">0</span>
            </>
          )}

          <svg
            className={`ao-category-arrow ${expandedSections.dataPrivacy ? 'ao-category-arrow--expanded' : ''}`}
            viewBox="0 0 24 24"
            fill="#333"
          >
            <path d="M7 10L12 15L17 10H7Z"/>
          </svg>
        </div>
      </div>

      {expandedSections.dataPrivacy && (
        <div className="ao-data-privacy-content">
          {dataPrivacyIssues && dataPrivacyIssues.length > 0 ? (
            <div className="ao-issues-container">
              {dataPrivacyIssues.map((issue, index) => (
                <div key={index} className="ao-issue">
                  <div className="ao-issue-header">
                    <div className="ao-issue-title">
                      {issue.name || `Data Privacy Issue ${index + 1}`}
                    </div>
                    {issue.priority && (
                      <div className={`ao-seo-issue-badge ao-seo-issue-badge--${issue.priority.toLowerCase()}`}>
                        {issue.priority}
                      </div>
                    )}
                  </div>
                  {issue.content && (
                    <div className="ao-issue-content">
                      <div dangerouslySetInnerHTML={{ __html: issue.content }} />
                    </div>
                  )}
                </div>
              ))}
            </div>
          ) : (
            <div className="ao-data-privacy-content">
              <p className="ao-issue-content">
                No data privacy issues were detected on this page. The scan checks for:
              </p>
              <ul className="ao-data-privacy-list">
                <li>Insecure form submissions</li>
                <li>Missing privacy policies</li>
                <li>Potentially unsafe third-party scripts</li>
                <li>Data collection without consent</li>
              </ul>
            </div>
          )}
        </div>
      )}
    </div>
  );
};

export default DataPrivacySection;
