import React from 'react';
import Button from '../Button';
import { NoIssueIcon, RetryIcon, WarningIcon } from '../Icons';
import { formatScanDate } from '../utils/constants';

const ResultsHeader = ({
  totalIssues,
  scanDate,
  startQuickScan,
  canScan,
  canConfigure
}) => {
  // Use processed scan date if available, otherwise format current date
  const displayDate = scanDate || formatScanDate();
  return (
    <div className="ao-results-card">
      {totalIssues > 0 ? (
        <div className="ao-results-header ao-results-header--error">
          <WarningIcon />
          <h2 className="ao-results-title">
            {totalIssues} issues total detected
          </h2>
        </div>
      ) : (
        <div className="ao-results-header ao-results-header--success">
          <NoIssueIcon />
          <h2 className="ao-results-title">
            No issues detected
          </h2>
        </div>
      )}
      <p className="ao-results-subtitle">Quick Scan is complete</p>
      <p className="ao-results-date">Scanned date: {displayDate}</p>

      <div className="ao-rescan-button">
        <Button
          onClick={startQuickScan}
          disabled={!canScan && !canConfigure}
          className="ao-button ao-button--icon"
        >
          <RetryIcon />
          Re-scan page
        </Button>
      </div>
    </div>
  );
};

export default ResultsHeader;
