import React from 'react';
import Button from '../Button';
import Footer from '../Footer';
import { getDrupalSettings } from '../utils/constants';
import { AcquiaOptimizeLogo } from '../Icons';

const { imgSrc } = getDrupalSettings();

const InitialView = ({ canConfigure, setShowApiKeyForm }) => {
  // Debug mode can be set based on environment or settings
  const isDebugMode = process.env.NODE_ENV === 'development' || window?.drupalSettings?.xbExtension?.acquiaOptimize?.debug;

  // User does not have permission to configure
  if (!canConfigure) {
    return (
      <div className="ao-container">
        <div className="ao-inner-container">
          <AcquiaOptimizeLogo OptimizeLogo = {`${imgSrc}`} />

          <h2 className="ao-heading">
            Acquia Web Governance
          </h2>

          <div className="ao-message ao-message--error">
            You do not have permission to configure API settings.
          </div>

          <div style={{
            display: 'flex',
            flexDirection: 'column',
            justifyContent: 'center',
            alignItems: 'center',
            gap: '16px',
            width: '100%',
            marginTop: '15px'
          }}>
            <Button
              style={{
                backgroundColor: 'white',
                color: 'var(--ao-primary-blue)',
                border: '2px solid var(--ao-primary-blue)',
                maxWidth: '400px',
                width: '100%',
              }}
              onClick={() => {
                // Handle registration for free scan
                window.open('https://docs.acquia.com/acquia-optimize', '_blank');
              }}
            >
              Learn more about Acquia Web Governance
            </Button>
          </div>
        </div>
      </div>
    );
  }

  // User has permission to add API key
  return (
    <div className="ao-container">
      <div className="ao-inner-container" style={{ maxWidth: '400px' }}>
        <Button
          onClick={() => setShowApiKeyForm(true)}
        >
          <span style={{ fontSize: '14px' }}>⚡ Enter API Key</span>
        </Button>

        <div style={{
            display: 'flex',
            flexDirection: 'column',
            justifyContent: 'center',
            alignItems: 'center',
            gap: '16px',
            width: '100%',
            marginTop: '15px'
          }}>
          <Button
            style={{
              backgroundColor: 'white',
              color: 'var(--ao-dark-blue)',
              border: '1px solid rgba(0, 132, 230, 0.63)',
              fontSize: '14px',
            }}
            onClick={() => {
              window.open('https://docs.acquia.com/acquia-optimize', '_blank');
            }}
          >
            Register for a free scan
          </Button>

          <Footer />
        </div>
      </div>
    </div>
  );
};

export default InitialView;
