import { getDrupalSettings } from '../utils/constants';
import { AcquiaOptimizeLogo, NoPermissionIcon } from '../Icons';
import Footer from '../Footer';

const { imgSrc } = getDrupalSettings();

const NoPermissionView = () => {
  return (
    <div className="ao-container">
      <div className="ao-inner-container">
        <AcquiaOptimizeLogo OptimizeLogo = {`${imgSrc}`} />

        <div className="ao-message ao-message--error" style={{
          backgroundColor: 'var(--ao-light-red)',
          borderRadius: '8px',
          padding: '25px',
          textAlign: 'center',
          width: '100%',
          boxSizing: 'border-box'
        }}>
          <NoPermissionIcon />
          <h3 style={{ margin: '0 0 10px 0', color: 'var(--ao-gray-800)' }}>Permission Denied</h3>
          <p style={{ color: 'var(--ao-gray-600)', margin: '0 0 15px 0' }}>
            You don't have permission to use Acquia Web Governance. You need either the "scan acquia optimize"
            or "administer acquia optimize" permission to access this feature.
          </p>
        </div>

       <Footer />
      </div>
    </div>
  );
};

export default NoPermissionView;
