# Acquia Web Governance Module

Module that implements the Acquia Web Governance Quick Scan for editors in Drupal to see potential SEO and accessibility issues on any page. The module provides an intuitive modal-based interface for content editors and seamless integration with Canvas.

## Features

### Core Scanning Capabilities
- **Accessibility Analysis**: Comprehensive checks against WCAG 2.0, 2.1, and 2.2 standards (A, AA, AAA levels)
- **SEO Analysis**: Detailed suggestions for Search Engine optimization with categorized issue types
- **Readability Assessment**: Content difficulty scoring to improve content accessibility
- **Data Privacy Compliance**: Scans for potential data protection violations

### User Interface & Experience
- **Modal-based Interface**: Clean, non-intrusive modal dialog for content pages
- **Real-time AJAX Scanning**: Live progress indicators with responsive feedback
- **Collapsible Results**: Organized, expandable sections for different issue categories
- **Multi-stage Modal**: Initial scan → scanning progress → detailed results workflow
- **Responsive Design**: Optimized for desktop and tablet editing environments

### Integration Features
- **Drupal Content Integration**: Seamless integration with standard Drupal content editing workflow
- **Canvas Support**: Dedicated React-based extension for Canvas authoring environment
- **Permission-based Access**: Granular permission controls for scanning and administration
- **API Configuration**: Flexible API endpoint and credential management

## Installation

1. Install with Composer:
```sh
composer require drupal/acquia_optimize
```

2. Enable the module from `/admin/modules` or via Drush:
```sh
drush en acquia_optimize
```

3. Configure API credentials (see Configuration section below)

## Configuration

### Prerequisites
- Valid Acquia Web Governance account with API access
- API Key and API URL from your Monsido dashboard
- Proper user permissions configured

### Setup Process

**Configuration access requires the `administer acquia optimize` permission**

1. **Navigate to Configuration**: Go to `/admin/config/content/acquia-optimize` or via:
   ```sh
   Administration » Configuration » Content authoring » Acquia Web Governance
   ```

2. **API Configuration**:
   - **API Key**: Enter your Web Governance API key from your Monsido account
   - **API URL**: Set the API endpoint (must use HTTPS and be a valid Monsido domain)
   - **Connection Validation**: The system automatically validates your API connection before saving

3. **Accessibility Standards**: Choose your preferred WCAG compliance level:
   - WCAG 2.0: A, AA, AAA
   - WCAG 2.1: A, AA, AAA
   - WCAG 2.2: A, AA, AAA

4. **Development Options**:
   - **Debug Mode**: Enable for detailed logging during development and troubleshooting

### Security Features
- All API communication uses HTTPS encryption
- Configuration access is permission-restricted

### User Permissions

The module uses a permission-based access system:

- **`scan acquia optimize`**: Allows users to perform Web Governance scans on content
- **`administer acquia optimize`**: Allows users to configure API settings and module administration

### Modal-Based Scanning Interface

#### Regular Content Pages

The Web Governance scanner integrates directly into Drupal's content editing interface:

1. **Access Location**: While editing any content node, look for the "Acquia Web Governance" section in the sidebar
2. **Button States**:
   - **"Configure API"**: Appears when API credentials are not set (redirects to configuration)
   - **"Quick Scan"**: Appears when API is configured and ready to scan

#### Modal Workflow

The scanning process uses a progressive modal interface:

**Stage 1 - Initial**:
- Web Governance branding and scan initiation
- "Start Quick Scan" button
- Quick access to API configuration

**Stage 2 - Scanning**:
- Real-time progress indicator
- "Scanning in progress" feedback
- Cannot be cancelled once started

**Stage 3 - Results**:
- Comprehensive results dashboard
- Collapsible sections for different issue types
- "Rescan" option for immediate re-analysis
- Direct links to detailed issue information

#### Content Scanning Process

1. **Node Validation**: System validates the current node and creates a preview version
2. **AJAX Processing**: Form state is temporarily saved for preview generation
3. **API Communication**: Content is sent to Web Governance API for analysis
4. **Result Processing**: Response is categorized and formatted for display
5. **Modal Display**: Results are presented in the organized modal interface

### Canvas Integration

For sites using [Canvas](https://www.drupal.org/project/canvas), the module provides a dedicated React-based extension:

#### Canvas Extension Features

1. **Seamless Integration**: Native extension within the Canvas authoring environment
2. **Sidebar Access**: Dedicated Web Governance panel in the Canvas sidebar
3. **Context-Aware Scanning**: Analyzes the actual rendered Canvas layout including all components
4. **Real-Time Feedback**: Immediate results without leaving the Canvas interface
5. **Iterative Workflow**: Make changes and re-scan instantly

#### Canvas Usage Workflow

1. **Extension Access**: While editing an Canvas page, locate the Web Governance extension in the sidebar
2. **One-Click Scanning**: Click "Start Quick Scan" to analyze the current page state
3. **Live Results**: View detailed analysis without switching interfaces
4. **Immediate Iteration**:
   - Make layout adjustments in Canvas
   - Re-scan to see improvements
   - Repeat until optimal results achieved

#### Canvas-Specific Benefits

- **Visual Editor Integration**: No need to switch between editing and testing interfaces
- **Component-Level Analysis**: Scans include Canvas specific components and layouts
- **Design-Time optimization**: Catch issues during the design process, not after publication
- **Responsive Testing**: Results reflect the actual responsive behavior of Canvas layouts


### Scan Results Interface

The modal interface provides comprehensive, organized results:

#### Results Dashboard

- **Issue Summary Header**:
  - Total issues count with clear visual indicators
  - Success state for pages with no issues found
  - Scan completion timestamp
  - One-click "Rescan" functionality

- **Categorized Results Sections**:
  - **Accessibility Issues**: WCAG compliance violations organized by severity level
  - **SEO Opportunities**: Search engine optimization suggestions categorized by impact
  - **Readability Analysis**: Content difficulty assessment with improvement suggestions
  - **Data Privacy**: Data protection and compliance issue detection

#### Interactive Features

- **Collapsible Sections**: Click any category header to expand/collapse detailed results
- **Issue Details**: Each issue includes:
  - Clear description of the problem
  - Specific location information
  - Actionable improvement suggestions
  - Severity level indication

- **Export & Documentation**:
  - Results link to comprehensive Acquia documentation
  - Direct access to your Web Governance account dashboard
  - Note: Modal results are not automatically synchronized to your account

## Architecture & API Integration

### Module Architecture

The module follows Drupal best practices with a clean separation of concerns:

- **Controller Layer**: `AcquiaOptimizeController` handles all AJAX endpoints and API communication
- **Service Layer**: `ApiClientFactory` and `ApiClient` manage external API integration
- **Form Layer**: `SettingsForm` and `AcquiaOptimizeFormAlter` handle configuration and content integration
- **Utility Layer**: `Utilities` class provides shared functionality and data processing
- **Template Layer**: Twig templates with staged rendering for progressive modal experience

### API Client Features

The module uses a robust factory pattern for API client creation:

- **Flexible Configuration**: Supports multiple API endpoints and credential sets
- **Secure Communication**: HTTPS-only API communication with credential validation
- **Error Handling**: Comprehensive error handling with detailed logging
- **Connection Validation**: Real-time API connection testing
- **Response Processing**: Automatic response validation and data transformation

### Frontend Architecture

#### Drupal Integration (Content Pages)
- **AJAX Form Integration**: Seamless integration with Drupal's AJAX form system
- **Progressive Modal**: Three-stage modal workflow (initial → scanning → results)
- **Real-time Updates**: Live progress indicators and status updates
- **Responsive UI**: Mobile and tablet-optimized interface

#### React Integration (Canvas)
- **Standalone React App**: Complete React application for Canvas integration
- **Component Architecture**: Modular, reusable React components
- **State Management**: Local state management for scan workflow
- **Portal Rendering**: Clean integration with Canvas's extension system

## Tests

Tests can be run with `phpunit --group acquia-optimize`.
