<?php

namespace Drupal\acquia_optimize;

use Drupal\Core\Asset\LibraryDiscoveryInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use GuzzleHttp\ClientInterface;
use Psr\Log\LoggerInterface;

/**
 * API client factory.
 */
class ApiClientFactory {

  public function __construct(
    private readonly ClientInterface $client,
    private readonly LibraryDiscoveryInterface $libraryDiscovery,
    private readonly ConfigFactoryInterface $configFactory,
    private readonly LoggerInterface $logger,
  ) {}

  /**
   * Creates an ApiClient instance with optional API key and URL.
   */
  public function create(?string $apiKey = NULL, ?string $apiUrl = NULL): ApiClient {
    return new ApiClient(
      $this->client,
      $this->libraryDiscovery,
      $this->configFactory,
      $this->logger,
      $apiKey,
      $apiUrl,
    );
  }

}
