export const useFormHandlers = (state, apiService) => {
  const handleSubmit = async (e) => {
    e.preventDefault();
    state.setIsLoading(true);
    state.setHelperText('');

    try {
      await apiService.saveSettings({
        api_key: state.apiKey,
        api_url: state.apiUrl,
        accessibility: state.accessibilityGuideline
      });

      state.setHelperText('API key saved successfully!');
      // Hide form after successful save and show Quick Scan view
      setTimeout(() => {
        state.setShowApiKeyForm(false);
        state.setHelperText('');
        state.setCurrentView('quick-scan');
      }, 2000);
    } catch (error) {
      console.error('Error saving settings:', error);
      state.setHelperText(`Error: ${error.message}`);
    } finally {
      state.setIsLoading(false);
    }
  };

  return {
    handleSubmit
  };
};
