import { ReadabilityIcon } from '../Icons';

const ReadabilitySection = ({
  readabilityData,
  toggleSection,
  expandedSections
}) => {
  return (
    <div className="ao-category-section">
      <div
        className="ao-category-header"
        onClick={() => toggleSection('readability')}
      >
        <div className="ao-category-title">
          <ReadabilityIcon />
          <h3 className="ao-category-name">Readability</h3>
        </div>

        <div className="ao-category-count">
          <span style={{ fontSize: '24px', fontWeight: 'bold', color: readabilityData.score_color }}>{readabilityData.score_display}</span>
          <svg
            className={`ao-category-arrow ${expandedSections.readability ? 'ao-category-arrow--expanded' : ''}`}
            viewBox="0 0 24 24"
            fill="#333"
          >
            <path d="M7 10L12 15L17 10H7Z"/>
          </svg>
        </div>
      </div>

      {expandedSections.readability && (
        <div className="ao-category-content">
          <div className="ao-readability-info">
            <strong className="ao-readability-grade">{readabilityData.grade_level}:</strong>
            <span className="ao-readability-description">{readabilityData.description}</span>
          </div>

          <p className="ao-readability-explanation">
            Readability refers to how easily a reader can understand written text.
            LIX is a readability index that measures how easy or difficult a text is to read.
          </p>
          <p className="ao-readability-explanation">
            It analyzes sentence length and word length to assign a score, helping you gauge the reading level required to understand a web page.
            LIX is widely used to assess and compare the readability of texts in different languages.
          </p>
        </div>
      )}
    </div>
  );
};

export default ReadabilitySection;
