import React from 'react';
import { GenericWarningIcon, GenericCheckIcon, SeoIcon } from '../Icons';

const SEOSection = ({
  seoIssues,
  seoCount,
  toggleSection,
  expandedSections,
  detailedIssues,
  showSeoIssuesForCategory
}) => {

  return (
    <div className="ao-category-section">
      <div
        className="ao-category-header"
        onClick={() => toggleSection('seo')}
      >
        <div className="ao-category-title">
          <SeoIcon />
          <h3 className="ao-category-name">SEO</h3>
        </div>

        <div className="ao-category-count">
          {seoCount > 0 ? (
            <>
              <GenericWarningIcon />
              <span className="ao-count-number ao-count-number--error">{seoCount}</span>
            </>
          ) : (
            <>
               <GenericCheckIcon />
              <span className="ao-count-number ao-count-number--success">0</span>
            </>
          )}

          <svg
            className={`ao-category-arrow ${expandedSections.seo ? 'ao-category-arrow--expanded' : ''}`}
            viewBox="0 0 24 24"
            fill="#333"
          >
            <path d="M7 10L12 15L17 10H7Z"/>
          </svg>
        </div>
      </div>

      {expandedSections.seo && (
        <div className="ao-category-content">
          <div style={{ padding: '10px 0', width: '100%' }}>
            {(!seoIssues || seoIssues.length === 0) ? (
              <div style={{
                padding: '20px',
                textAlign: 'center',
                color: '#666',
                fontSize: '14px',
                backgroundColor: '#f8f9fa',
                borderRadius: '4px',
                border: '1px solid #e9ecef'
              }}>
                No SEO issues were detected on this page.
              </div>
            ) : (
              <>
                <div style={{ fontSize: '15px', fontWeight: '500', marginBottom: '8px', color: '#333' }}>SEO Opportunities</div>
                <div style={{ marginTop: '12px', width: '100%' }}>
              {/* Group SEO issues by category using the processed data */}
              {(() => {
                // Group issues by the processed category field
                const categorizedIssues = {
                  high: [],
                  medium: [],
                  low: [],
                  technical: []
                };

                // Count issues in each category using the processed category field
                seoIssues.forEach(issue => {
                  const category = issue.category || 'low'; // Use processed category
                  categorizedIssues[category].push(issue);
                });

                // Define icons and labels for each category
                const categoryConfig = {
                  high: {
                    label: 'High impact SEO Opportunities',
                    icon: <path d="M16 6l2.29 2.29-4.88 4.88-4-4L2 16.59 3.41 18l6-6 4 4 6.3-6.29L22 12V6h-6z" />
                  },
                  medium: {
                    label: 'Medium impact SEO Opportunities',
                    icon: <path d="M16 6l2.29 2.29-4.88 4.88-4-4L2 16.59 3.41 18l6-6 4 4 6.3-6.29L22 12V6h-6z" />
                  },
                  low: {
                    label: 'Low impact SEO Opportunities',
                    icon: <path d="M6 16l-1.41-1.41 4.59-4.59 4 4L20 7.13l1.4 1.41L13.4 16z" />
                  },
                  technical: {
                    label: 'Technical SEO Opportunities',
                    icon: <path d="M15.5 1h-8C6.12 1 5 2.12 5 3.5v17C5 21.88 6.12 23 7.5 23h8c1.38 0 2.5-1.12 2.5-2.5v-17C18 2.12 16.88 1 15.5 1zm-4 21c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5-4H7V4h9v14z" />
                  }
                };

                // Use our comprehensive SEO issues mapping

                return (
                  <>
                    {Object.keys(categorizedIssues).map(category => (
                      <div key={category}>
                        <div
                          className="ao-seo-category"
                          onClick={categorizedIssues[category].length > 0 ? (e) => showSeoIssuesForCategory(category, e) : undefined}
                        >
                          <div className="ao-seo-category-label">
                            <svg className="ao-seo-category-icon" viewBox="0 0 24 24" fill="currentColor">
                              {categoryConfig[category].icon}
                            </svg>
                            {categoryConfig[category].label}
                          </div>
                          <div style={{ display: 'flex', alignItems: 'center', pointerEvents: 'none' }}>
                            <span>{categorizedIssues[category].length}</span>
                            {categorizedIssues[category].length > 0 && (
                              <svg
                                style={{
                                  width: '18px',
                                  height: '18px',
                                  marginLeft: '6px',
                                  transform: detailedIssues[category] ? 'rotate(90deg)' : 'none',
                                  transition: 'transform 0.3s ease'
                                }}
                                viewBox="0 0 24 24"
                                fill="#333"
                              >
                                <path d="M14 5l7 7-7 7V5z" />
                              </svg>
                            )}
                          </div>
                        </div>

                        {/* Show detailed issues when expanded */}
                        {detailedIssues[category] && categorizedIssues[category].length > 0 && (
                          <div className="ao-issues-container">
                            {categorizedIssues[category].map((issue, index) => (
                              <div key={index} className="ao-issue">
                                <div className="ao-issue-header">
                                  <div className={`ao-seo-issue-badge ao-seo-issue-badge--${category}`}>
                                    {category.charAt(0).toUpperCase() + category.slice(1)}
                                  </div>
                                </div>
                                <div className="ao-issue-content">
                                  <div className="ao-issue-title">
                                    {issue.friendly_name || issue.name}
                                  </div>
                                  <div className="ao-issue-description">
                                    {issue.description || 'Addressing this issue will improve your search engine ranking.'}
                                  </div>
                                </div>
                              </div>
                            ))}
                          </div>
                        )}
                      </div>
                    ))}
                  </>
                );
              })()}
                </div>
              </>
            )}
          </div>
        </div>
      )}
    </div>
  );
};

export default SEOSection;
