// Helper function for conditional logging
export const debugError = (debugMode, ...args) => {
  if (debugMode) {
    console.error(...args);
  }
};

// Get the dynamic module path from canvasExtension settings.
export const getDrupalSettings = () => {
  const { drupalSettings } = window;
  return {
    imgSrc: drupalSettings?.canvasExtension?.acquiaOptimize?.imgSrc || '',
    csrfToken: drupalSettings?.csrf_token || ''
  };
};

// Function to format the date in "Mon, 25 Nov 2024" format
export const formatScanDate = () => {
  const now = new Date();
  const options = { weekday: 'short', day: 'numeric', month: 'short', year: 'numeric' };
  return now.toLocaleDateString('en-US', options);
};
