import { AcquiaOptimizeLogo, WheelIcon } from '../Icons';
import { getDrupalSettings } from '../utils/constants';
import Footer from '../Footer';

const { imgSrc } = getDrupalSettings();

const QuickScanView = ({
  helperText,
  startQuickScan,
  canScan,
  canConfigure
}) => {
  return (
    <div className="ao-container">
      <div className="ao-inner-container">
        <AcquiaOptimizeLogo OptimizeLogo = {`${imgSrc}`} />

        <h2 className="ao-heading">
          Quick Scan
        </h2>

        <p className="ao-subheading">
          Receive quick feedback on issues found within this page.
        </p>

        {helperText && (
          <div className={`ao-message ${helperText.includes('Error') ? 'ao-message--error' : 'ao-message--success'}`}>
            {helperText}
          </div>
        )}

        <div style={{
          display: 'flex',
          flexDirection: 'column',
          alignItems: 'center',
          gap: '15px',
          width: '100%'
        }}>
          <button
            onClick={startQuickScan}
            disabled={!canScan && !canConfigure}
            className="ao-button ao-button--icon"
          >
            <span style={{ marginRight: '8px', fontSize: '18px' }}>⚡</span>
            Start Quick Scan
            {(!canScan && !canConfigure) && <span style={{ marginLeft: '8px', fontSize: '12px' }}>(Permission required)</span>}
          </button>

          {canConfigure && (
            <a
              href="/admin/config/content/acquia-optimize"
              target="_blank"
              rel="noopener noreferrer"
              className="ao-link"
              style={{ color: 'var(--ao-gray-500)', fontSize: '14px' }}
            >
              <WheelIcon />
              Configure API Settings
            </a>
          )}
        </div>

        <Footer AcquiaDocs={true} />
      </div>
    </div>
  );
};

export default QuickScanView;
