<?php

declare(strict_types=1);

namespace Drupal\awg_auth_test;

use Drupal\awg_auth_test\HttpClientMiddleware\MockedResponseMiddleware;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderInterface;
use Symfony\Component\DependencyInjection\Reference;

/**
 * Service provider to register HTTP client middleware for testing.
 */
final class AwgTestServiceProvider implements ServiceProviderInterface {

  /**
   * {@inheritdoc}
   */
  public function register(ContainerBuilder $container): void {
    // Add the HTTP request middleware to Guzzle.
    $container
      ->register('awg_auth_test.http_client.middleware', MockedResponseMiddleware::class)
      ->addArgument(new Reference('logger.channel.default'))
      ->addArgument(new Reference('cache.default'))
      ->addTag('http_client_middleware');
  }

}
