import Footer from '../Footer';
import { getDrupalSettings } from '../utils/constants';
import { AcquiaOptimizeLogo } from '../Icons';

const { imgSrc } = getDrupalSettings();
// Remove filename to get just the directory path
const imgPath = imgSrc.replace(/\/[^\/]*$/, '');
const ScanningView = ({ scanProgress }) => {
  return (
    <div className="ao-container">
      <div className="ao-inner-container">
       <AcquiaOptimizeLogo OptimizeLogo = {`${imgPath}/start-scan.svg`} alt = 'Acquia Web Governance Scan' className = 'ao-scan' />
        <h2 className="ao-heading">
          Quick Scan in progress...
        </h2>

        <div className="ao-progress-container">
          <div
            className="ao-progress-bar"
            style={{
              width: `${scanProgress}%`,
            }}
          />
        </div>

       <Footer AcquiaDocs={true} />
      </div>
    </div>
  );
};

export default ScanningView;
