<?php

namespace Drupal\acsf_module_listing\Entity;

/**
 * ACSF entities extension to get entity variable value.
 */
trait AcsfEntityVariableTrait {

  /**
   * Returns variable value by variable name.
   *
   * @param string $variable
   *   Variable name.
   *
   * @return mixed
   *   Variable value.
   */
  public function getVariable(string $variable) {
    return $this->$variable;
  }

  /**
   * Sets variable value by variable name.
   *
   * @param string $variable
   *   Variable name.
   * @param mixed $value
   *   Variable value.
   *
   * @return $this
   *   Returns ACSF Entity.
   */
  public function setVariable(string $variable, mixed $value): static {
    if ($variable != 'id') {
      $this->$variable = $value;
    }
    return $this;
  }

}
