<?php

namespace Drupal\acsf_module_listing\Entity;

use Drupal\acsf_module_listing\AcsfEnvironmentEntityInterface;
use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the ACSF environment entity entity type.
 *
 * @ConfigEntityType(
 *   id = "acsf_environment_entity",
 *   label = @Translation("ACSF Environment Entity"),
 *   label_collection = @Translation("ACSF Environment Entities"),
 *   label_singular = @Translation("acsf environment entity"),
 *   label_plural = @Translation("acsf environment entities"),
 *   label_count = @PluralTranslation(
 *     singular = "@count acsf environment entity",
 *     plural = "@count acsf environment entities",
 *   ),
 *   handlers = {
 *     "list_builder" =
 *   "Drupal\acsf_module_listing\AcsfEnvironmentEntityListBuilder",
 *     "form" = {
 *       "add" = "Drupal\acsf_module_listing\Form\ACSFEnvironmentEntityForm",
 *       "edit" = "Drupal\acsf_module_listing\Form\ACSFEnvironmentEntityForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm"
 *     }
 *   },
 *   config_prefix = "acsf_environment_entity",
 *   admin_permission = "administer acsf_environment_entity",
 *   links = {
 *     "collection" = "/admin/structure/acsf-environment-entity",
 *     "add-form" = "/admin/structure/acsf-environment-entity/add",
 *     "edit-form" =
 *   "/admin/structure/acsf-environment-entity/{acsf_environment_entity}",
 *     "delete-form" =
 *   "/admin/structure/acsf-environment-entity/{acsf_environment_entity}/delete"
 *   },
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *     "description" = "description",
 *     "ssh_user" = "ssh_user",
 *     "ssh_url" = "ssh_url",
 *     "drush_path" = "drush_path",
 *     "acsf_env_url" = "acsf_env_url",
 *     "acsf_username" = "acsf_username",
 *     "acsf_api_key" = "acsf_api_key",
 *     "public_key_path" = "public_key_path",
 *     "private_key_path" = "private_key_path",
 *     "pass_phrase" = "pass_phrase"
 *   },
 *   config_export = {
 *     "id" = "id",
 *     "label"= "label",
 *     "description" = "description",
 *     "ssh_user" = "ssh_user",
 *     "ssh_url" = "ssh_url",
 *     "drush_path" = "drush_path",
 *     "acsf_username" = "acsf_username",
 *     "acsf_api_key" = "acsf_api_key",
 *     "acsf_env_url" = "acsf_env_url",
 *     "public_key_path" = "public_key_path",
 *     "private_key_path" = "private_key_path",
 *     "pass_phrase" = "pass_phrase"
 *   }
 * )
 */
class AcsfEnvironmentEntity extends ConfigEntityBase implements AcsfEnvironmentEntityInterface {

  use AcsfEntityVariableTrait;

  const ENTITY_TYPE = 'acsf_environment_entity';

  /**
   * The acsf environment entity ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The acsf environment entity label.
   *
   * @var string
   */
  protected $label;

  /**
   * The acsf_environment_entity description.
   *
   * @var string
   */
  protected $description;

  /**
   * The acsf environment entity status.
   *
   * @var bool
   */
  protected $status;

  /**
   * SSH server user name.
   *
   * @var string
   *   SSH server user name variable.
   */
  protected string $ssh_user;

  /**
   * SSH server URL.
   *
   * @var string
   *   SSH server URL variable.
   */
  protected string $ssh_url;

  /**
   * Drush path.
   *
   * @var string
   *   Path to the folder where drush is available to work with ACSF websites.
   */
  protected string $drush_path;

  /**
   * ACSF environment URL.
   *
   * @var string
   *   ACSF environment URL variable.
   */
  protected string $acsf_env_url;

  /**
   * ACSF API username.
   *
   * @var string
   *   ACSF name you can receive on {acsf_site}/users/{id}.
   */
  protected string $acsf_username;

  /**
   * ACSF API key.
   *
   * @var string
   *   ACSF API key you can receive on {acsf_site}/user/{id}/api-key.
   */
  protected string $acsf_api_key;

  /**
   * Public key.
   *
   * @var string
   *   Absolute path to the public key variable.
   */
  protected string $public_key_path;

  /**
   * Private key.
   *
   * @var string
   *   Absolute path to the private key variable.
   */
  protected string $private_key_path;

  /**
   * Pass phrase.
   *
   * @var string
   *   Pass phrase for key.
   */
  protected string $pass_phrase;

}
