<?php

namespace Drupal\acsf_module_listing\Form;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Implements the ACSFModulesListingConfigurationForm.
 *
 * @see \Drupal\Core\Form\ConfigFormBase
 */
class ACSFModulesListingConfigurationForm extends ConfigFormBase {

  /**
   * Config service.
   *
   * @var \Drupal\Core\Config\ImmutableConfig
   *   Config service variable.
   */
  protected $config;

  /**
   * Constructs a SymptomQuestionnaireAdminForm object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The factory for configuration objects.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    parent::__construct($config_factory);

    $this->config = $config_factory->get('acsf_module_listing.modules_usage_configuration');
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory')
    );
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['acsf_module_listing.modules_usage_configuration'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'acsf_module_listing_modules_usage_configuration_admin_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('acsf_module_listing.modules_usage_configuration');
    $values = $config->get('configuration');

    $form['configuration'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Global configuration'),
      '#tree' => TRUE,
    ];

    $form['configuration']['cache_lifetime'] = [
      '#type' => 'textfield',
      '#attributes' => [
        'type' => 'number',
      ],
      '#title' => $this->t('Cache lifetime in seconds'),
      '#required' => TRUE,
      '#maxlength' => 5,
      '#description' => $this->t('How long the query result will be stored'),
      '#default_value' => $values['cache_lifetime'] ?? 3600,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $config = $this->config('acsf_module_listing.modules_usage_configuration');

    $config->set('configuration', $form_state->getValue('configuration'))
      ->save(TRUE);
  }

}
