<?php

namespace Drupal\acsf_module_listing\Services;

use Drupal\acsf_module_listing\Entity\AcsfEnvironmentEntity;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\Logger\LoggerChannelInterface;
use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\Entity\EntityInterface;

/**
 * AcsfEnvironmentEntityService responsible for managing AcsfEnvironmentEntity.
 */
class AcsfEnvironmentEntityService {

  /**
   * Entity type manager service.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   *   Entity type manager service variable.
   */
  protected EntityTypeManagerInterface $entityTypeManager;

  /**
   * Messenger service.
   *
   * @var \Drupal\Core\Messenger\MessengerInterface
   *   Messenger service variable.
   */
  protected MessengerInterface $messenger;

  /**
   * Logger channel service.
   *
   * @var \Drupal\Core\Logger\LoggerChannelInterface
   *   Logger channel service variable.
   */
  protected LoggerChannelInterface $logger;

  /**
   * AcsfEnvironmentEntityService constructor.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entityTypeManager
   *   Entity type manager service.
   * @param \Drupal\Core\Messenger\MessengerInterface $messenger
   *   Messenger service.
   * @param \Drupal\Core\Logger\LoggerChannelFactoryInterface $logger_factory
   *   Logger factory service.
   */
  public function __construct(EntityTypeManagerInterface $entityTypeManager, MessengerInterface $messenger, LoggerChannelFactoryInterface $logger_factory) {
    $this->entityTypeManager = $entityTypeManager;
    $this->messenger = $messenger;
    $this->logger = $logger_factory->get('acsf_module_listing');
  }

  /**
   * Load entity by ID.
   *
   * @param string $id
   *   Entity id.
   *
   * @return \Drupal\Core\Entity\EntityInterface|null
   *   Returns entity ACSF Environment Entity.
   */
  public function loadAcsfEnvironmentById(string $id): EntityInterface|null {
    try {
      $entityStorage = $this->entityTypeManager->getStorage(AcsfEnvironmentEntity::ENTITY_TYPE);
      return $entityStorage->load($id);
    }
    catch (\Exception $exception) {
      $this->logger->error($exception->getMessage(), ['exception' => $exception]);
    }
    $this->messenger->addError('Something went wrong. Please check database logs.');

    return NULL;
  }

}
