<?php

namespace Drupal\acsf_module_listing;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of acsf environment entities.
 */
class AcsfEnvironmentEntityListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Label');
    $header['id'] = $this->t('Machine name');
    $header['ssh_url'] = $this->t('SSH URL');
    $header['status'] = $this->t('Status');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /**
     * @var \Drupal\acsf_module_listing\AcsfEnvironmentEntityInterface $entity
     */
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    $row['ssh_url'] = !empty($entity->getVariable('ssh_url')) ? $entity->getVariable('ssh_url') : '';
    $row['status'] = $entity->status() ? $this->t('Enabled') : $this->t('Disabled');
    return $row + parent::buildRow($entity);
  }

}
