<?php

namespace Drupal\acsf_module_listing\Services;

/**
 * Provides Modules service.
 */
class AcsfModulesCommon {

  /**
   * Map returned data from information per site to information per module.
   *
   * @param array $data
   *   Raw data array with list of modules.
   *
   * @return array
   *   Sorted array of results.
   */
  public function remapModulesList(array $data): array {
    $modules_list = [];
    foreach ($data as $site => $modules) {
      foreach ($modules as $module) {
        if (count($module) < 3) {
          continue;
        }
        $name = substr($module[count($module) - 3], 1, strlen($module[count($module) - 3]) - 2);
        $sites = array_key_exists($name, $modules_list) ? $modules_list[$name]['sites'] : [];
        if ($module[count($module) - 2] == 'Enabled') {
          $sites[] = $site;
        }

        $modules_list[$name] = [
          'machine_name' => $name,
          'name' => $module[count($module) - 4],
          'sites' => $sites,
          'version' => $module[count($module) - 1],
        ];
      }
    }
    usort(
      $modules_list, function ($a, $b) {
        if (count($a['sites']) > count($b['sites'])) {
          return 1;
        }
        elseif (count($a['sites']) < count($b['sites'])) {
          return -1;
        }
        else {
          return 0;
        }
      }
    );
    return $modules_list;
  }

}
